require 'vertx/vertx'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.consul.ConsulClient
module VertxConsul
  #  A Vert.x service used to interact with Consul.
  class ConsulClient
    # @private
    # @param j_del [::VertxConsul::ConsulClient] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxConsul::ConsulClient] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == ConsulClient
    end
    def @@j_api_type.wrap(obj)
      ConsulClient.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtConsul::ConsulClient.java_class
    end
    #  Returns the nodes registered in a datacenter
    # @overload catalogNodesWithOptions(options,resultHandler)
    #   @param [Hash{String => Object}] options options used to request nodes
    #   @yield will be provided with list of nodes
    # @return [self]
    def catalog_nodes_with_options(*args)
      if args[0].class == Hash && true
        if (block_given?)
          @j_del.java_method(:catalogNodesWithOptions, [Java::IoVertxExtConsul::NodeQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::NodeQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:catalogNodesWithOptions, [Java::IoVertxExtConsul::NodeQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::NodeQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::NodeList))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling catalog_nodes_with_options(#{args[0]})"
      end
    end
    #  Returns the checks associated with the service
    # @overload healthChecks(service,resultHandler)
    #   @param [String] service the service name
    #   @yield will be provided with list of checks
    # @return [self]
    def health_checks(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:healthChecks, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:healthChecks, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::CheckList))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling health_checks(#{args[0]})"
      end
    end
    #  Returns the active sessions
    # @overload listSessions(resultHandler)
    #   @yield will be provided with list of sessions
    # @return [self]
    def list_sessions
      if true
        if (block_given?)
          @j_del.java_method(:listSessions, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:listSessions, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::SessionList))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling list_sessions()"
      end
    end
    #  Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.
    # @overload updateCheckWithNote(checkId,status,note,resultHandler)
    #   @param [String] checkId the ID of check
    #   @param [:PASSING,:WARNING,:CRITICAL] status new status of check
    #   @param [String] note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
    #   @yield will be called when complete
    # @return [self]
    def update_check_with_note(*args)
      if args[0].class == String && args[1].class == Symbol && args[2].class == String && true
        if (block_given?)
          @j_del.java_method(:updateCheckWithNote, [Java::java.lang.String.java_class,Java::IoVertxExtConsul::CheckStatus.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxExtConsul::CheckStatus.valueOf(args[1].to_s),args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:updateCheckWithNote, [Java::java.lang.String.java_class,Java::IoVertxExtConsul::CheckStatus.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxExtConsul::CheckStatus.valueOf(args[1].to_s),args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling update_check_with_note(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Adds a new service, with an optional health check, to the local agent.
    # @overload registerService(serviceOptions,resultHandler)
    #   @param [Hash{String => Object}] serviceOptions the options of new service
    #   @yield will be called when complete
    # @return [self]
    def register_service(*args)
      if args[0].class == Hash && true
        if (block_given?)
          @j_del.java_method(:registerService, [Java::IoVertxExtConsul::ServiceOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::ServiceOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:registerService, [Java::IoVertxExtConsul::ServiceOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::ServiceOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling register_service(#{args[0]})"
      end
    end
    #  Remove a service from the local agent. The agent will take care of deregistering the service with the Catalog.
    #  If there is an associated check, that is also deregistered.
    # @overload deregisterService(id,resultHandler)
    #   @param [String] id the ID of service
    #   @yield will be called when complete
    # @return [self]
    def deregister_service(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:deregisterService, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:deregisterService, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling deregister_service(#{args[0]})"
      end
    end
    #  Fires a new user event
    # @overload fireEvent(name,resultHandler)
    #   @param [String] name name of event
    #   @yield will be provided with properties of event
    # @return [self]
    def fire_event(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:fireEvent, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:fireEvent, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::Event))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling fire_event(#{args[0]})"
      end
    end
    # @overload putValueWithOptions(key,value,options,resultHandler)
    #   @param [String] key the key
    #   @param [String] value the value
    #   @param [Hash{String => Object}] options options used to push pair
    #   @yield will be provided with success of operation
    # @return [self]
    def put_value_with_options(*args)
      if args[0].class == String && args[1].class == String && args[2].class == Hash && true
        if (block_given?)
          @j_del.java_method(:putValueWithOptions, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxExtConsul::KeyValueOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],Java::IoVertxExtConsul::KeyValueOptions.new(::Vertx::Util::Utils.to_json_object(args[2])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:putValueWithOptions, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxExtConsul::KeyValueOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],Java::IoVertxExtConsul::KeyValueOptions.new(::Vertx::Util::Utils.to_json_object(args[2])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling put_value_with_options(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Returns the list of key/value pairs that corresponding to the specified key prefix.
    #  An empty {Hash{String => Object}} object will be returned if no such key prefix is found.
    #  This is blocking query unlike {::VertxConsul::ConsulClient#get_values}
    # @overload getValuesWithOptions(keyPrefix,options,resultHandler)
    #   @param [String] keyPrefix the prefix
    #   @param [Hash{String => Object}] options the blocking options
    #   @yield will be provided with list of key/value pairs
    # @return [self]
    def get_values_with_options(*args)
      if args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:getValuesWithOptions, [Java::java.lang.String.java_class,Java::IoVertxExtConsul::BlockingQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxExtConsul::BlockingQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:getValuesWithOptions, [Java::java.lang.String.java_class,Java::IoVertxExtConsul::BlockingQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxExtConsul::BlockingQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::KeyValueList))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_values_with_options(#{args[0]},#{args[1]})"
      end
    end
    #  Remove a check from the local agent. The agent will take care of deregistering the check from the Catalog.
    # @overload deregisterCheck(checkId,resultHandler)
    #   @param [String] checkId the ID of check
    #   @yield will be called when complete
    # @return [self]
    def deregister_check(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:deregisterCheck, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:deregisterCheck, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling deregister_check(#{args[0]})"
      end
    end
    #  Returns the most recent events known by the agent.
    #  This is blocking query unlike {::VertxConsul::ConsulClient#list_events}. However, the semantics of this endpoint
    #  are slightly different. Most blocking queries provide a monotonic index and block until a newer index is available.
    #  This can be supported as a consequence of the total ordering of the consensus protocol. With gossip,
    #  there is no ordering, and instead <code>X-Consul-Index</code> maps to the newest event that matches the query.
    #  <p>
    #  In practice, this means the index is only useful when used against a single agent and has no meaning globally.
    #  Because Consul defines the index as being opaque, clients should not be expecting a natural ordering either.
    # @overload listEventsWithOptions(options,resultHandler)
    #   @param [Hash{String => Object}] options the blocking options
    #   @yield will be provided with list of events
    # @return [self]
    def list_events_with_options(*args)
      if args[0].class == Hash && true
        if (block_given?)
          @j_del.java_method(:listEventsWithOptions, [Java::IoVertxExtConsul::EventListOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::EventListOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:listEventsWithOptions, [Java::IoVertxExtConsul::EventListOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::EventListOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::EventList))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling list_events_with_options(#{args[0]})"
      end
    end
    #  Returns the node's registered services
    #  This is blocking query unlike {::VertxConsul::ConsulClient#catalog_node_services}
    # @overload catalogNodeServicesWithOptions(node,options,resultHandler)
    #   @param [String] node node name
    #   @param [Hash{String => Object}] options the blocking options
    #   @yield will be provided with list of services
    # @return [self]
    def catalog_node_services_with_options(*args)
      if args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:catalogNodeServicesWithOptions, [Java::java.lang.String.java_class,Java::IoVertxExtConsul::BlockingQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxExtConsul::BlockingQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:catalogNodeServicesWithOptions, [Java::java.lang.String.java_class,Java::IoVertxExtConsul::BlockingQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxExtConsul::BlockingQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::ServiceList))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling catalog_node_services_with_options(#{args[0]},#{args[1]})"
      end
    end
    #  Initialize a new session
    # @overload createSessionWithOptions(options,idHandler)
    #   @param [Hash{String => Object}] options options used to create session
    #   @yield will be provided with ID of new session
    # @return [self]
    def create_session_with_options(*args)
      if args[0].class == Hash && true
        if (block_given?)
          @j_del.java_method(:createSessionWithOptions, [Java::IoVertxExtConsul::SessionOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::SessionOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createSessionWithOptions, [Java::IoVertxExtConsul::SessionOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::SessionOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_session_with_options(#{args[0]})"
      end
    end
    #  Get the Raft leader for the datacenter in which the agent is running.
    #  It returns an address in format "<code>10.1.10.12:8300</code>"
    # @overload leaderStatus(resultHandler)
    #   @yield will be provided with address of cluster leader
    # @return [self]
    def leader_status
      if true
        if (block_given?)
          @j_del.java_method(:leaderStatus, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:leaderStatus, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling leader_status()"
      end
    end
    #  Returns the WAN network coordinates for all Consul servers, organized by DCs
    # @overload coordinateDatacenters(resultHandler)
    #   @yield will be provided with network coordinates for all Consul servers
    # @return [self]
    def coordinate_datacenters
      if true
        if (block_given?)
          @j_del.java_method(:coordinateDatacenters, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:coordinateDatacenters, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling coordinate_datacenters()"
      end
    end
    #  Return all the datacenters that are known by the Consul server
    # @overload catalogDatacenters(resultHandler)
    #   @yield will be provided with list of datacenters
    # @return [self]
    def catalog_datacenters
      if true
        if (block_given?)
          @j_del.java_method(:catalogDatacenters, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:catalogDatacenters, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling catalog_datacenters()"
      end
    end
    #  Create a Consul client.
    # @overload create(vertx)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    # @overload create(vertx,options)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    #   @param [Hash{String => Object}] options the options
    # @return [::VertxConsul::ConsulClient] the client
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtConsul::ConsulClient.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxConsul::ConsulClient)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtConsul::ConsulClient.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtConsul::ConsulClientOptions.java_class]).call(args[0].j_del,Java::IoVertxExtConsul::ConsulClientOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxConsul::ConsulClient)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.
    # @overload warnCheck(checkId,resultHandler)
    #   @param [String] checkId the ID of check
    #   @yield will be called when complete
    # @return [self]
    def warn_check(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:warnCheck, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:warnCheck, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling warn_check(#{args[0]})"
      end
    end
    #  Remove the key/value pair that corresponding to the specified key
    # @overload deleteValue(key,resultHandler)
    #   @param [String] key the key
    #   @yield will be called on complete
    # @return [self]
    def delete_value(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:deleteValue, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:deleteValue, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling delete_value(#{args[0]})"
      end
    end
    #  Returns the nodes providing a service
    # @overload catalogServiceNodes(service,resultHandler)
    #   @param [String] service name of service
    #   @yield will be provided with list of nodes providing given service
    # @return [self]
    def catalog_service_nodes(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:catalogServiceNodes, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:catalogServiceNodes, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::ServiceList))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling catalog_service_nodes(#{args[0]})"
      end
    end
    #  Deletes an existing prepared query
    # @overload deletePreparedQuery(id,resultHandler)
    #   @param [String] id the id of the query to delete
    #   @yield will be called when complete
    # @return [self]
    def delete_prepared_query(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:deletePreparedQuery, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:deletePreparedQuery, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling delete_prepared_query(#{args[0]})"
      end
    end
    #  Returns the most recent events known by the agent
    # @overload listEvents(resultHandler)
    #   @yield will be provided with list of events
    # @return [self]
    def list_events
      if true
        if (block_given?)
          @j_del.java_method(:listEvents, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:listEvents, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::EventList))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling list_events()"
      end
    end
    #  Get list of Acl token
    # @overload listAclTokens(resultHandler)
    #   @yield will be provided with list of tokens
    # @return [self]
    def list_acl_tokens
      if true
        if (block_given?)
          @j_del.java_method(:listAclTokens, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:listAclTokens, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling list_acl_tokens()"
      end
    end
    #  Returns the LAN network coordinates for all nodes in a given DC
    #  This is blocking query unlike {::VertxConsul::ConsulClient#coordinate_nodes}
    # @overload coordinateNodesWithOptions(options,resultHandler)
    #   @param [Hash{String => Object}] options the blocking options
    #   @yield will be provided with network coordinates of nodes in datacenter
    # @return [self]
    def coordinate_nodes_with_options(*args)
      if args[0].class == Hash && true
        if (block_given?)
          @j_del.java_method(:coordinateNodesWithOptions, [Java::IoVertxExtConsul::BlockingQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::BlockingQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:coordinateNodesWithOptions, [Java::IoVertxExtConsul::BlockingQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::BlockingQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::CoordinateList))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling coordinate_nodes_with_options(#{args[0]})"
      end
    end
    #  Clone Acl token
    # @overload cloneAclToken(id,idHandler)
    #   @param [String] id the ID of token to be cloned
    #   @yield will be provided with ID of cloned token
    # @return [self]
    def clone_acl_token(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:cloneAclToken, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:cloneAclToken, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling clone_acl_token(#{args[0]})"
      end
    end
    #  Destroys the given session
    # @overload destroySession(id,resultHandler)
    #   @param [String] id the ID of session
    #   @yield will be called when complete
    # @return [self]
    def destroy_session(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:destroySession, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:destroySession, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling destroy_session(#{args[0]})"
      end
    end
    #  Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.
    # @overload warnCheckWithNote(checkId,note,resultHandler)
    #   @param [String] checkId the ID of check
    #   @param [String] note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
    #   @yield will be called when complete
    # @return [self]
    def warn_check_with_note(*args)
      if args[0].class == String && args[1].class == String && true
        if (block_given?)
          @j_del.java_method(:warnCheckWithNote, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:warnCheckWithNote, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling warn_check_with_note(#{args[0]},#{args[1]})"
      end
    end
    #  Update Acl token
    # @overload updateAclToken(token,idHandler)
    #   @param [Hash{String => Object}] token properties of the token to be updated
    #   @yield will be provided with ID of updated
    # @return [self]
    def update_acl_token(*args)
      if args[0].class == Hash && true
        if (block_given?)
          @j_del.java_method(:updateAclToken, [Java::IoVertxExtConsul::AclToken.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::AclToken.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:updateAclToken, [Java::IoVertxExtConsul::AclToken.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::AclToken.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling update_acl_token(#{args[0]})"
      end
    end
    #  Add a new check to the local agent. The agent is responsible for managing the status of the check
    #  and keeping the Catalog in sync.
    # @overload registerCheck(checkOptions,resultHandler)
    #   @param [Hash{String => Object}] checkOptions options used to register new check
    #   @yield will be called when complete
    # @return [self]
    def register_check(*args)
      if args[0].class == Hash && true
        if (block_given?)
          @j_del.java_method(:registerCheck, [Java::IoVertxExtConsul::CheckOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::CheckOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:registerCheck, [Java::IoVertxExtConsul::CheckOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::CheckOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling register_check(#{args[0]})"
      end
    end
    #  Get info of Acl token
    # @overload infoAclToken(id,tokenHandler)
    #   @param [String] id the ID of token
    #   @yield will be provided with token
    # @return [self]
    def info_acl_token(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:infoAclToken, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:infoAclToken, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::AclToken))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling info_acl_token(#{args[0]})"
      end
    end
    #  Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.
    # @overload failCheck(checkId,resultHandler)
    #   @param [String] checkId the ID of check
    #   @yield will be called when complete
    # @return [self]
    def fail_check(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:failCheck, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:failCheck, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling fail_check(#{args[0]})"
      end
    end
    #  Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.
    # @overload passCheck(checkId,resultHandler)
    #   @param [String] checkId the ID of check
    #   @yield will be called when complete
    # @return [self]
    def pass_check(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:passCheck, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:passCheck, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pass_check(#{args[0]})"
      end
    end
    #  Adds specified key/value pair
    # @overload putValue(key,value,resultHandler)
    #   @param [String] key the key
    #   @param [String] value the value
    #   @yield will be provided with success of operation
    # @return [self]
    def put_value(*args)
      if args[0].class == String && args[1].class == String && true
        if (block_given?)
          @j_del.java_method(:putValue, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:putValue, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling put_value(#{args[0]},#{args[1]})"
      end
    end
    # @overload createPreparedQuery(definition,resultHandler)
    #   @param [Hash{String => Object}] definition definition of the prepare query
    #   @yield will be provided with id of created prepare query
    # @return [self]
    def create_prepared_query(*args)
      if args[0].class == Hash && true
        if (block_given?)
          @j_del.java_method(:createPreparedQuery, [Java::IoVertxExtConsul::PreparedQueryDefinition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::PreparedQueryDefinition.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createPreparedQuery, [Java::IoVertxExtConsul::PreparedQueryDefinition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::PreparedQueryDefinition.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_prepared_query(#{args[0]})"
      end
    end
    #  Returns the nodes registered in a datacenter
    # @overload catalogNodes(resultHandler)
    #   @yield will be provided with list of nodes
    # @return [self]
    def catalog_nodes
      if true
        if (block_given?)
          @j_del.java_method(:catalogNodes, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:catalogNodes, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::NodeList))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling catalog_nodes()"
      end
    end
    #  Places a given service into "maintenance mode"
    # @overload maintenanceService(maintenanceOptions,resultHandler)
    #   @param [Hash{String => Object}] maintenanceOptions the maintenance options
    #   @yield will be called when complete
    # @return [self]
    def maintenance_service(*args)
      if args[0].class == Hash && true
        if (block_given?)
          @j_del.java_method(:maintenanceService, [Java::IoVertxExtConsul::MaintenanceOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::MaintenanceOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:maintenanceService, [Java::IoVertxExtConsul::MaintenanceOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::MaintenanceOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling maintenance_service(#{args[0]})"
      end
    end
    # @overload updatePreparedQuery(definition,resultHandler)
    #   @param [Hash{String => Object}] definition definition of the prepare query
    #   @yield will be called when complete
    # @return [self]
    def update_prepared_query(*args)
      if args[0].class == Hash && true
        if (block_given?)
          @j_del.java_method(:updatePreparedQuery, [Java::IoVertxExtConsul::PreparedQueryDefinition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::PreparedQueryDefinition.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:updatePreparedQuery, [Java::IoVertxExtConsul::PreparedQueryDefinition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::PreparedQueryDefinition.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling update_prepared_query(#{args[0]})"
      end
    end
    #  Returns the requested session information
    # @overload infoSession(id,resultHandler)
    #   @param [String] id the ID of requested session
    #   @yield will be provided with info of requested session
    # @return [self]
    def info_session(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:infoSession, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:infoSession, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::Session))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling info_session(#{args[0]})"
      end
    end
    #  Destroy Acl token
    # @overload destroyAclToken(id,resultHandler)
    #   @param [String] id the ID of token
    #   @yield will be called on complete
    # @return [self]
    def destroy_acl_token(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:destroyAclToken, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:destroyAclToken, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling destroy_acl_token(#{args[0]})"
      end
    end
    #  Returns the configuration and member information of the local agent
    # @overload agentInfo(resultHandler)
    #   @yield will be provided with the configuration and member information of the local agent
    # @return [self]
    def agent_info
      if true
        if (block_given?)
          @j_del.java_method(:agentInfo, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:agentInfo, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling agent_info()"
      end
    end
    #  Executes an existing prepared query.
    # @overload executePreparedQuery(query,resultHandler)
    #   @param [String] query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
    #   @yield will be provided with response
    # @return [self]
    def execute_prepared_query(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:executePreparedQuery, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:executePreparedQuery, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::PreparedQueryExecuteResponse))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling execute_prepared_query(#{args[0]})"
      end
    end
    #  Returns the list of keys that corresponding to the specified key prefix.
    # @overload getKeysWithOptions(keyPrefix,options,resultHandler)
    #   @param [String] keyPrefix the prefix
    #   @param [Hash{String => Object}] options the blocking options
    #   @yield will be provided with keys list
    # @return [self]
    def get_keys_with_options(*args)
      if args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:getKeysWithOptions, [Java::java.lang.String.java_class,Java::IoVertxExtConsul::BlockingQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxExtConsul::BlockingQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:getKeysWithOptions, [Java::java.lang.String.java_class,Java::IoVertxExtConsul::BlockingQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxExtConsul::BlockingQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_keys_with_options(#{args[0]},#{args[1]})"
      end
    end
    #  Initialize a new session
    # @overload createSession(idHandler)
    #   @yield will be provided with ID of new session
    # @return [self]
    def create_session
      if true
        if (block_given?)
          @j_del.java_method(:createSession, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createSession, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_session()"
      end
    end
    #  Return all the checks that are registered with the local agent.
    # @overload localChecks(resultHandler)
    #   @yield will be provided with list of checks
    # @return [self]
    def local_checks
      if true
        if (block_given?)
          @j_del.java_method(:localChecks, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:localChecks, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling local_checks()"
      end
    end
    #  Retrieves the Raft peers for the datacenter in which the the agent is running.
    #  It returns a list of addresses "<code>10.1.10.12:8300</code>", "<code>10.1.10.13:8300</code>"
    # @overload peersStatus(resultHandler)
    #   @yield will be provided with list of peers
    # @return [self]
    def peers_status
      if true
        if (block_given?)
          @j_del.java_method(:peersStatus, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:peersStatus, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling peers_status()"
      end
    end
    #  Renews the given session. This is used with sessions that have a TTL, and it extends the expiration by the TTL
    # @overload renewSession(id,resultHandler)
    #   @param [String] id the ID of session that should be renewed
    #   @yield will be provided with info of renewed session
    # @return [self]
    def renew_session(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:renewSession, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:renewSession, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::Session))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling renew_session(#{args[0]})"
      end
    end
    #  Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.
    # @overload passCheckWithNote(checkId,note,resultHandler)
    #   @param [String] checkId the ID of check
    #   @param [String] note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
    #   @yield will be called when complete
    # @return [self]
    def pass_check_with_note(*args)
      if args[0].class == String && args[1].class == String && true
        if (block_given?)
          @j_del.java_method(:passCheckWithNote, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:passCheckWithNote, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pass_check_with_note(#{args[0]},#{args[1]})"
      end
    end
    #  Returns an existing prepared query
    # @overload getPreparedQuery(id,resultHandler)
    #   @param [String] id the id of the query to read
    #   @yield will be provided with definition of the prepare query
    # @return [self]
    def get_prepared_query(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:getPreparedQuery, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:getPreparedQuery, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::PreparedQueryDefinition))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_prepared_query(#{args[0]})"
      end
    end
    #  Returns the LAN network coordinates for all nodes in a given DC
    # @overload coordinateNodes(resultHandler)
    #   @yield will be provided with network coordinates of nodes in datacenter
    # @return [self]
    def coordinate_nodes
      if true
        if (block_given?)
          @j_del.java_method(:coordinateNodes, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:coordinateNodes, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::CoordinateList))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling coordinate_nodes()"
      end
    end
    #  Returns the active sessions
    #  This is blocking query unlike {::VertxConsul::ConsulClient#list_sessions}
    # @overload listSessionsWithOptions(options,resultHandler)
    #   @param [Hash{String => Object}] options the blocking options
    #   @yield will be provided with list of sessions
    # @return [self]
    def list_sessions_with_options(*args)
      if args[0].class == Hash && true
        if (block_given?)
          @j_del.java_method(:listSessionsWithOptions, [Java::IoVertxExtConsul::BlockingQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::BlockingQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:listSessionsWithOptions, [Java::IoVertxExtConsul::BlockingQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::BlockingQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::SessionList))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling list_sessions_with_options(#{args[0]})"
      end
    end
    #  Returns the services registered in a datacenter
    #  This is blocking query unlike {::VertxConsul::ConsulClient#catalog_services}
    # @overload catalogServicesWithOptions(options,resultHandler)
    #   @param [Hash{String => Object}] options the blocking options
    #   @yield will be provided with list of services
    # @return [self]
    def catalog_services_with_options(*args)
      if args[0].class == Hash && true
        if (block_given?)
          @j_del.java_method(:catalogServicesWithOptions, [Java::IoVertxExtConsul::BlockingQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::BlockingQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:catalogServicesWithOptions, [Java::IoVertxExtConsul::BlockingQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::BlockingQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::ServiceList))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling catalog_services_with_options(#{args[0]})"
      end
    end
    #  Returns a list of all prepared queries.
    # @overload getAllPreparedQueries(resultHandler)
    #   @yield will be provided with list of definitions of the all prepare queries
    # @return [self]
    def get_all_prepared_queries
      if true
        if (block_given?)
          @j_del.java_method(:getAllPreparedQueries, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:getAllPreparedQueries, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_all_prepared_queries()"
      end
    end
    #  Returns the requested session information
    #  This is blocking query unlike {::VertxConsul::ConsulClient#info_session}
    # @overload infoSessionWithOptions(id,options,resultHandler)
    #   @param [String] id the ID of requested session
    #   @param [Hash{String => Object}] options the blocking options
    #   @yield will be provided with info of requested session
    # @return [self]
    def info_session_with_options(*args)
      if args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:infoSessionWithOptions, [Java::java.lang.String.java_class,Java::IoVertxExtConsul::BlockingQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxExtConsul::BlockingQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:infoSessionWithOptions, [Java::java.lang.String.java_class,Java::IoVertxExtConsul::BlockingQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxExtConsul::BlockingQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::Session))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling info_session_with_options(#{args[0]},#{args[1]})"
      end
    end
    #  Returns the active sessions for a given node
    #  This is blocking query unlike {::VertxConsul::ConsulClient#list_node_sessions}
    # @overload listNodeSessionsWithOptions(nodeId,options,resultHandler)
    #   @param [String] nodeId the ID of node
    #   @param [Hash{String => Object}] options the blocking options
    #   @yield will be provided with list of sessions
    # @return [self]
    def list_node_sessions_with_options(*args)
      if args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:listNodeSessionsWithOptions, [Java::java.lang.String.java_class,Java::IoVertxExtConsul::BlockingQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxExtConsul::BlockingQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:listNodeSessionsWithOptions, [Java::java.lang.String.java_class,Java::IoVertxExtConsul::BlockingQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxExtConsul::BlockingQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::SessionList))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling list_node_sessions_with_options(#{args[0]},#{args[1]})"
      end
    end
    #  Create new Acl token
    # @overload createAclToken(token,idHandler)
    #   @param [Hash{String => Object}] token properties of the token
    #   @yield will be provided with ID of created token
    # @return [self]
    def create_acl_token(*args)
      if args[0].class == Hash && true
        if (block_given?)
          @j_del.java_method(:createAclToken, [Java::IoVertxExtConsul::AclToken.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::AclToken.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createAclToken, [Java::IoVertxExtConsul::AclToken.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::AclToken.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_acl_token(#{args[0]})"
      end
    end
    #  Close the client and release its resources
    # @overload close()
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Returns the node's registered services
    # @overload catalogNodeServices(node,resultHandler)
    #   @param [String] node node name
    #   @yield will be provided with list of services
    # @return [self]
    def catalog_node_services(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:catalogNodeServices, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:catalogNodeServices, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::ServiceList))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling catalog_node_services(#{args[0]})"
      end
    end
    #  Returns the nodes providing the service. This endpoint is very similar to the {::VertxConsul::ConsulClient#catalog_service_nodes} endpoint;
    #  however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.
    # @overload healthServiceNodes(service,passing,resultHandler)
    #   @param [String] service the service name
    #   @param [true,false] passing if true, filter results to only nodes with all checks in the passing state
    #   @yield will be provided with list of services
    # @return [self]
    def health_service_nodes(*args)
      if args[0].class == String && (args[1].class == TrueClass || args[1].class == FalseClass) && true
        if (block_given?)
          @j_del.java_method(:healthServiceNodes, [Java::java.lang.String.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:healthServiceNodes, [Java::java.lang.String.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::ServiceEntryList))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling health_service_nodes(#{args[0]},#{args[1]})"
      end
    end
    #  Returns the checks associated with the service
    # @overload healthChecksWithOptions(service,options,resultHandler)
    #   @param [String] service the service name
    #   @param [Hash{String => Object}] options options used to request checks
    #   @yield will be provided with list of checks
    # @return [self]
    def health_checks_with_options(*args)
      if args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:healthChecksWithOptions, [Java::java.lang.String.java_class,Java::IoVertxExtConsul::CheckQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxExtConsul::CheckQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:healthChecksWithOptions, [Java::java.lang.String.java_class,Java::IoVertxExtConsul::CheckQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxExtConsul::CheckQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::CheckList))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling health_checks_with_options(#{args[0]},#{args[1]})"
      end
    end
    #  Returns the nodes providing the service. This endpoint is very similar to the {::VertxConsul::ConsulClient#catalog_service_nodes_with_options} endpoint;
    #  however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.
    # @overload healthServiceNodesWithOptions(service,passing,options,resultHandler)
    #   @param [String] service the service name
    #   @param [true,false] passing if true, filter results to only nodes with all checks in the passing state
    #   @param [Hash{String => Object}] options options used to request services
    #   @yield will be provided with list of services
    # @return [self]
    def health_service_nodes_with_options(*args)
      if args[0].class == String && (args[1].class == TrueClass || args[1].class == FalseClass) && args[2].class == Hash && true
        if (block_given?)
          @j_del.java_method(:healthServiceNodesWithOptions, [Java::java.lang.String.java_class,Java::boolean.java_class,Java::IoVertxExtConsul::ServiceQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],Java::IoVertxExtConsul::ServiceQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[2])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:healthServiceNodesWithOptions, [Java::java.lang.String.java_class,Java::boolean.java_class,Java::IoVertxExtConsul::ServiceQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],Java::IoVertxExtConsul::ServiceQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[2])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::ServiceEntryList))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling health_service_nodes_with_options(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Returns the active sessions for a given node
    # @overload listNodeSessions(nodeId,resultHandler)
    #   @param [String] nodeId the ID of node
    #   @yield will be provided with list of sessions
    # @return [self]
    def list_node_sessions(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:listNodeSessions, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:listNodeSessions, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::SessionList))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling list_node_sessions(#{args[0]})"
      end
    end
    #  Returns the list of key/value pairs that corresponding to the specified key prefix.
    #  An empty {Hash{String => Object}} object will be returned if no such key prefix is found.
    # @overload getValues(keyPrefix,resultHandler)
    #   @param [String] keyPrefix the prefix
    #   @yield will be provided with list of key/value pairs
    # @return [self]
    def get_values(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:getValues, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:getValues, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::KeyValueList))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_values(#{args[0]})"
      end
    end
    #  Returns the checks in the specified status
    # @overload healthStateWithOptions(healthState,options,resultHandler)
    #   @param [:PASSING,:WARNING,:CRITICAL,:ANY] healthState the health state
    #   @param [Hash{String => Object}] options options used to request checks
    #   @yield will be provided with list of checks
    # @return [self]
    def health_state_with_options(*args)
      if args[0].class == Symbol && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:healthStateWithOptions, [Java::IoVertxExtConsul::HealthState.java_class,Java::IoVertxExtConsul::CheckQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::HealthState.valueOf(args[0].to_s),Java::IoVertxExtConsul::CheckQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:healthStateWithOptions, [Java::IoVertxExtConsul::HealthState.java_class,Java::IoVertxExtConsul::CheckQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::HealthState.valueOf(args[0].to_s),Java::IoVertxExtConsul::CheckQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::CheckList))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling health_state_with_options(#{args[0]},#{args[1]})"
      end
    end
    #  Executes an existing prepared query.
    # @overload executePreparedQueryWithOptions(query,options,resultHandler)
    #   @param [String] query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
    #   @param [Hash{String => Object}] options the options used to execute prepared query
    #   @yield will be provided with response
    # @return [self]
    def execute_prepared_query_with_options(*args)
      if args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:executePreparedQueryWithOptions, [Java::java.lang.String.java_class,Java::IoVertxExtConsul::PreparedQueryExecuteOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxExtConsul::PreparedQueryExecuteOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:executePreparedQueryWithOptions, [Java::java.lang.String.java_class,Java::IoVertxExtConsul::PreparedQueryExecuteOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxExtConsul::PreparedQueryExecuteOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::PreparedQueryExecuteResponse))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling execute_prepared_query_with_options(#{args[0]},#{args[1]})"
      end
    end
    #  Returns the nodes providing a service
    # @overload catalogServiceNodesWithOptions(service,options,resultHandler)
    #   @param [String] service name of service
    #   @param [Hash{String => Object}] options options used to request services
    #   @yield will be provided with list of nodes providing given service
    # @return [self]
    def catalog_service_nodes_with_options(*args)
      if args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:catalogServiceNodesWithOptions, [Java::java.lang.String.java_class,Java::IoVertxExtConsul::ServiceQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxExtConsul::ServiceQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:catalogServiceNodesWithOptions, [Java::java.lang.String.java_class,Java::IoVertxExtConsul::ServiceQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxExtConsul::ServiceQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::ServiceList))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling catalog_service_nodes_with_options(#{args[0]},#{args[1]})"
      end
    end
    #  Returns key/value pair that corresponding to the specified key.
    #  An empty {Hash{String => Object}} object will be returned if no such key is found.
    #  This is blocking query unlike {::VertxConsul::ConsulClient#get_value}
    # @overload getValueWithOptions(key,options,resultHandler)
    #   @param [String] key the key
    #   @param [Hash{String => Object}] options the blocking options
    #   @yield will be provided with key/value pair
    # @return [self]
    def get_value_with_options(*args)
      if args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:getValueWithOptions, [Java::java.lang.String.java_class,Java::IoVertxExtConsul::BlockingQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxExtConsul::BlockingQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:getValueWithOptions, [Java::java.lang.String.java_class,Java::IoVertxExtConsul::BlockingQueryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxExtConsul::BlockingQueryOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::KeyValue))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_value_with_options(#{args[0]},#{args[1]})"
      end
    end
    #  Returns list of services registered with the local agent.
    # @overload localServices(resultHandler)
    #   @yield will be provided with list of services
    # @return [self]
    def local_services
      if true
        if (block_given?)
          @j_del.java_method(:localServices, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:localServices, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling local_services()"
      end
    end
    #  Returns the services registered in a datacenter
    # @overload catalogServices(resultHandler)
    #   @yield will be provided with list of services
    # @return [self]
    def catalog_services
      if true
        if (block_given?)
          @j_del.java_method(:catalogServices, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:catalogServices, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::ServiceList))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling catalog_services()"
      end
    end
    #  Returns the list of keys that corresponding to the specified key prefix.
    # @overload getKeys(keyPrefix,resultHandler)
    #   @param [String] keyPrefix the prefix
    #   @yield will be provided with keys list
    # @return [self]
    def get_keys(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:getKeys, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:getKeys, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_keys(#{args[0]})"
      end
    end
    #  Removes all the key/value pair that corresponding to the specified key prefix
    # @overload deleteValues(keyPrefix,resultHandler)
    #   @param [String] keyPrefix the prefix
    #   @yield will be called on complete
    # @return [self]
    def delete_values(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:deleteValues, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:deleteValues, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling delete_values(#{args[0]})"
      end
    end
    #  Returns key/value pair that corresponding to the specified key.
    #  An empty {Hash{String => Object}} object will be returned if no such key is found.
    # @overload getValue(key,resultHandler)
    #   @param [String] key the key
    #   @yield will be provided with key/value pair
    # @return [self]
    def get_value(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:getValue, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:getValue, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::KeyValue))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_value(#{args[0]})"
      end
    end
    #  Returns the checks in the specified status
    # @overload healthState(healthState,resultHandler)
    #   @param [:PASSING,:WARNING,:CRITICAL,:ANY] healthState the health state
    #   @yield will be provided with list of checks
    # @return [self]
    def health_state(*args)
      if args[0].class == Symbol && true
        if (block_given?)
          @j_del.java_method(:healthState, [Java::IoVertxExtConsul::HealthState.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::HealthState.valueOf(args[0].to_s),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:healthState, [Java::IoVertxExtConsul::HealthState.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::HealthState.valueOf(args[0].to_s),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::CheckList))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling health_state(#{args[0]})"
      end
    end
    #  Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.
    # @overload failCheckWithNote(checkId,note,resultHandler)
    #   @param [String] checkId the ID of check
    #   @param [String] note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
    #   @yield will be called when complete
    # @return [self]
    def fail_check_with_note(*args)
      if args[0].class == String && args[1].class == String && true
        if (block_given?)
          @j_del.java_method(:failCheckWithNote, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:failCheckWithNote, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling fail_check_with_note(#{args[0]},#{args[1]})"
      end
    end
    #  Fires a new user event
    # @overload fireEventWithOptions(name,options,resultHandler)
    #   @param [String] name name of event
    #   @param [Hash{String => Object}] options options used to create event
    #   @yield will be provided with properties of event
    # @return [self]
    def fire_event_with_options(*args)
      if args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:fireEventWithOptions, [Java::java.lang.String.java_class,Java::IoVertxExtConsul::EventOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxExtConsul::EventOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:fireEventWithOptions, [Java::java.lang.String.java_class,Java::IoVertxExtConsul::EventOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxExtConsul::EventOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::Event))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling fire_event_with_options(#{args[0]},#{args[1]})"
      end
    end
    #  Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.
    # @overload updateCheck(checkId,status,resultHandler)
    #   @param [String] checkId the ID of check
    #   @param [:PASSING,:WARNING,:CRITICAL] status new status of check
    #   @yield will be called when complete
    # @return [self]
    def update_check(*args)
      if args[0].class == String && args[1].class == Symbol && true
        if (block_given?)
          @j_del.java_method(:updateCheck, [Java::java.lang.String.java_class,Java::IoVertxExtConsul::CheckStatus.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxExtConsul::CheckStatus.valueOf(args[1].to_s),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:updateCheck, [Java::java.lang.String.java_class,Java::IoVertxExtConsul::CheckStatus.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxExtConsul::CheckStatus.valueOf(args[1].to_s),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling update_check(#{args[0]},#{args[1]})"
      end
    end
    #  Manages multiple operations inside a single, atomic transaction.
    # @overload transaction(request,resultHandler)
    #   @param [Hash{String => Object}] request transaction request
    #   @yield will be provided with result of transaction
    # @return [self]
    def transaction(*args)
      if args[0].class == Hash && true
        if (block_given?)
          @j_del.java_method(:transaction, [Java::IoVertxExtConsul::TxnRequest.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::TxnRequest.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:transaction, [Java::IoVertxExtConsul::TxnRequest.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtConsul::TxnRequest.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::TxnResponse))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling transaction(#{args[0]})"
      end
    end
  end
end
