require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.consul.WatchResult
module VertxConsul
  class WatchResult
    # @private
    # @param j_del [::VertxConsul::WatchResult] the java delegate
    def initialize(j_del, j_arg_T=nil)
      @j_del = j_del
      @j_arg_T = j_arg_T != nil ? j_arg_T : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::VertxConsul::WatchResult] the underlying java delegate
    def j_del
      @j_del
    end
    #  The next result of the operation. This will be null if the operation failed.
    # @overload nextResult()
    # @return [Object] the next result or null if the operation failed.
    def next_result
      if !block_given?
        return @j_arg_T.wrap(@j_del.java_method(:nextResult, []).call())
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling next_result()"
      end
    end
    #  The previous result of the operation.
    # @overload prevResult()
    # @return [Object] the previous result.
    def prev_result
      if !block_given?
        return @j_arg_T.wrap(@j_del.java_method(:prevResult, []).call())
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling prev_result()"
      end
    end
    #  A Throwable describing failure. This will be null if the operation succeeded.
    # @overload cause()
    # @return [Exception] the cause or null if the operation succeeded.
    def cause
      if !block_given?
        return ::Vertx::Util::Utils.from_throwable(@j_del.java_method(:cause, []).call())
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling cause()"
      end
    end
    #  Did it fail?
    # @overload failed()
    # @return [true,false] true if it failed or false otherwise
    def failed?
      if !block_given?
        return @j_del.java_method(:failed, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling failed?()"
      end
    end
    #  Did it succeed?
    # @overload succeeded()
    # @return [true,false] true if it succeded or false otherwise
    def succeeded?
      if !block_given?
        return @j_del.java_method(:succeeded, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling succeeded?()"
      end
    end
  end
end
