require 'vertx/promise'
require 'vertx/vertx'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.healthchecks.HealthChecks
module VertxHealthChecks
  class HealthChecks
    # @private
    # @param j_del [::VertxHealthChecks::HealthChecks] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxHealthChecks::HealthChecks] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == HealthChecks
    end
    def @@j_api_type.wrap(obj)
      HealthChecks.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtHealthchecks::HealthChecks.java_class
    end
    #  Unregisters a procedure.
    # @overload unregister(name)
    #   @param [String] name the name of the procedure
    # @return [self]
    def unregister(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:unregister, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling unregister(#{args[0]})"
      end
    end
    #  Creates a new instance of the default implementation of {::VertxHealthChecks::HealthChecks}.
    # @overload create(vertx)
    #   @param [::Vertx::Vertx] vertx the instance of Vert.x, must not be <code>null</code>
    # @return [::VertxHealthChecks::HealthChecks] the created instance
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtHealthchecks::HealthChecks.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxHealthChecks::HealthChecks)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]})"
      end
    end
    #  Invokes the registered procedure with the given name and sub-procedures. It computes the overall
    #  outcome.
    # @overload invoke(resultHandler)
    #   @yield the result handler, must not be <code>null</code>. The handler received the computed .
    # @overload invoke(name,resultHandler)
    #   @param [String] name 
    #   @yield the result handler, must not be <code>null</code>. The handler received an  marked as failed if the procedure with the given name cannot be found or invoked.
    # @return [self]
    def invoke(*args)
      if true && args[0] == nil
        @j_del.java_method(:invoke, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event != nil ? JSON.parse(event.encode) : nil) unless !block_given? }))
        return self
      elsif args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:invoke, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:invoke, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling invoke(#{args[0]})"
      end
    end
    #  Registers a health check procedure.
    #  <p>
    #  The procedure is a  taking a  of {Hash{String => Object}} as parameter.
    #  Procedures are asynchronous, and <strong>must</strong> complete or fail the given .
    #  If the future object is failed, the procedure outcome is considered as `DOWN`. If the future is
    #  completed without any object, the procedure outcome is considered as `UP`. If the future is completed
    #  with a (not-null) {Hash{String => Object}}, the procedure outcome is the received status.
    # @overload register(name,procedure)
    #   @param [String] name the name of the procedure, must not be <code>null</code> or empty
    #   @yield the procedure, must not be <code>null</code>
    # @overload register(name,timeout,procedure)
    #   @param [String] name the name of the procedure, must not be <code>null</code> or empty
    #   @param [Fixnum] timeout the procedure timeout in milliseconds
    #   @yield the procedure, must not be <code>null</code>
    # @return [::VertxHealthChecks::HealthChecks] the current {::VertxHealthChecks::HealthChecks}
    def register(*args)
      if args[0].class == String && true && args[1] == nil
        @j_del.java_method(:register, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Promise,::Vertx::Util::data_object_type(Java::IoVertxExtHealthchecks::Status))) unless !block_given? }))
        return self
      elsif args[0].class == String && args[1].class == Fixnum && true
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:register, [Java::java.lang.String.java_class,Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Promise,::Vertx::Util::data_object_type(Java::IoVertxExtHealthchecks::Status))) unless !block_given? })),::VertxHealthChecks::HealthChecks)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling register(#{args[0]},#{args[1]})"
      end
    end
  end
end
