require 'vertx/vertx'
require 'vertx-sql/sql_client'
require 'vertx-sql/sql_operations'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.jdbc.JDBCClient
module VertxJdbc
  #  An asynchronous client interface for interacting with a JDBC compliant database
  class JDBCClient < ::VertxSql::SQLClient
    # @private
    # @param j_del [::VertxJdbc::JDBCClient] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxJdbc::JDBCClient] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == JDBCClient
    end
    def @@j_api_type.wrap(obj)
      JDBCClient.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtJdbc::JDBCClient.java_class
    end
    #  Create a JDBC client which shares its data source with any other JDBC clients created with the same
    #  data source name
    # @overload createShared(vertx,config)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    #   @param [Hash{String => Object}] config the configuration
    # @overload createShared(vertx,config,dataSourceName)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    #   @param [Hash{String => Object}] config the configuration
    #   @param [String] dataSourceName the data source name
    # @return [::VertxJdbc::JDBCClient] the client
    def self.create_shared(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtJdbc::JDBCClient.java_method(:createShared, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1])),::VertxJdbc::JDBCClient)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && args[2].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtJdbc::JDBCClient.java_method(:createShared, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::java.lang.String.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1]),args[2]),::VertxJdbc::JDBCClient)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_shared(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
    #  getting a connection from the pool (this object) and return it back after the execution. Only the first result
    #  from the result set is returned.
    # @overload querySingle(sql,handler)
    #   @param [String] sql the statement to execute
    #   @yield the result handler
    # @return [self]
    def query_single(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:querySingle, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:querySingle, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling query_single(#{args[0]})"
      end
    end
    #  Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
    #  boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
    #  Only the first result from the result set is returned.
    # @overload querySingleWithParams(sql,arguments,handler)
    #   @param [String] sql the statement to execute
    #   @param [Array<String,Object>] arguments the arguments
    #   @yield the result handler
    # @return [self]
    def query_single_with_params(*args)
      if args[0].class == String && args[1].class == Array && true
        if (block_given?)
          @j_del.java_method(:querySingleWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_array(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:querySingleWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_array(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling query_single_with_params(#{args[0]},#{args[1]})"
      end
    end
    #  Create a JDBC client which maintains its own data source.
    # @overload createNonShared(vertx,config)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    #   @param [Hash{String => Object}] config the configuration
    # @return [::VertxJdbc::JDBCClient] the client
    def self.create_non_shared(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtJdbc::JDBCClient.java_method(:createNonShared, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1])),::VertxJdbc::JDBCClient)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_non_shared(#{args[0]},#{args[1]})"
      end
    end
    #  The default data source provider is C3P0
    def self.DEFAULT_PROVIDER_CLASS
      Java::IoVertxExtJdbc::JDBCClient.DEFAULT_PROVIDER_CLASS
    end
    #  The name of the default data source
    def self.DEFAULT_DS_NAME
      Java::IoVertxExtJdbc::JDBCClient.DEFAULT_DS_NAME
    end
  end
end
