require 'vertx/pipe'
require 'vertx-kafka-client/kafka_consumer_record'
require 'vertx/write_stream'
require 'vertx/vertx'
require 'vertx/read_stream'
require 'vertx-kafka-client/kafka_consumer_records'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.kafka.client.consumer.KafkaConsumer
module VertxKafkaClient
  #  Vert.x Kafka consumer.
  #  <p>
  #  You receive Kafka records by providing a {::VertxKafkaClient::KafkaConsumer#handler}. As messages arrive the handler
  #  will be called with the records.
  #  <p>
  #  The {::VertxKafkaClient::KafkaConsumer#pause} and {::VertxKafkaClient::KafkaConsumer#resume} provides global control over reading the records from the consumer.
  #  <p>
  #  The {::VertxKafkaClient::KafkaConsumer#pause} and {::VertxKafkaClient::KafkaConsumer#resume} provides finer grained control over reading records
  #  for specific Topic/Partition, these are Kafka's specific operations.
  class KafkaConsumer
    include ::Vertx::ReadStream
    # @private
    # @param j_del [::VertxKafkaClient::KafkaConsumer] the java delegate
    def initialize(j_del, j_arg_K=nil, j_arg_V=nil)
      @j_del = j_del
      @j_arg_K = j_arg_K != nil ? j_arg_K : ::Vertx::Util::unknown_type
      @j_arg_V = j_arg_V != nil ? j_arg_V : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::VertxKafkaClient::KafkaConsumer] the underlying java delegate
    def j_del
      @j_del
    end
    # @overload handler(handler)
    #   @yield 
    # @return [self]
    def handler
      if true
        @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxKafkaClient::KafkaConsumerRecord, nil, nil)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handler()"
      end
    end
    #  Get the set of partitions that were previously paused by a call to pause(Set).
    # @overload paused(handler)
    #   @yield handler called on operation completed
    # @return [void]
    def paused
      if true
        if (block_given?)
          return @j_del.java_method(:paused, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.to_set(ar.result).map! { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil } : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:paused, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.to_set(ar.result).map! { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling paused()"
      end
    end
    #  Commit current offsets for all the subscribed list of topics and partition.
    # @overload commit(completionHandler)
    #   @yield handler called on operation completed
    # @return [void]
    def commit
      if true
        if (block_given?)
          return @j_del.java_method(:commit, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:commit, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling commit()"
      end
    end
    #  Sets the poll timeout (in ms) for the underlying native Kafka Consumer. Defaults to 1000.
    #  Setting timeout to a lower value results in a more 'responsive' client, because it will block for a shorter period
    #  if no data is available in the assigned partition and therefore allows subsequent actions to be executed with a shorter
    #  delay. At the same time, the client will poll more frequently and thus will potentially create a higher load on the Kafka Broker.
    # @overload pollTimeout(timeout)
    #   @param [Fixnum] timeout The time, in milliseconds, spent waiting in poll if data is not available in the buffer. If 0, returns immediately with any records that are available currently in the native Kafka consumer's buffer, else returns empty. Must not be negative.
    # @return [self]
    def poll_timeout(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:pollTimeout, [Java::long.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling poll_timeout(#{args[0]})"
      end
    end
    #  Executes a poll for getting messages from Kafka
    # @overload poll(timeout,handler)
    #   @param [Fixnum] timeout The time, in milliseconds, spent waiting in poll if data is not available in the buffer. If 0, returns immediately with any records that are available currently in the native Kafka consumer's buffer, else returns empty. Must not be negative.
    #   @yield handler called after the poll with batch of records (can be empty).
    # @return [void]
    def poll(*args)
      if args[0].class == Fixnum && true
        if (block_given?)
          return @j_del.java_method(:poll, [Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxKafkaClient::KafkaConsumerRecords, nil, nil) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:poll, [Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxKafkaClient::KafkaConsumerRecords, nil, nil) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxKafkaClient::KafkaConsumerRecords.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling poll(#{args[0]})"
      end
    end
    #  Get the current subscription.
    # @overload subscription(handler)
    #   @yield handler called on operation completed
    # @return [self]
    def subscription
      if true
        if (block_given?)
          @j_del.java_method(:subscription, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.to_set(ar.result).map! { |elt| elt } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:subscription, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.to_set(ar.result).map! { |elt| elt } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling subscription()"
      end
    end
    #  Overrides the fetch offsets that the consumer will use on the next poll.
    #  <p>
    #  Due to internal buffering of messages,
    #  the  will
    #  continue to observe messages fetched with respect to the old offset
    #  until some time <em>after</em> the given <code>completionHandler</code>
    #  is called. In contrast, the once the given <code>completionHandler</code>
    #  is called the {::VertxKafkaClient::KafkaConsumer#batch_handler} will only see messages
    #  consistent with the new offset.
    # @overload seek(topicPartition,offset,completionHandler)
    #   @param [Hash{String => Object}] topicPartition topic partition for which seek
    #   @param [Fixnum] offset offset to seek inside the topic partition
    #   @yield handler called on operation completed
    # @return [self]
    def seek(*args)
      if args[0].class == Hash && args[1].class == Fixnum && true
        if (block_given?)
          @j_del.java_method(:seek, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(args[0])),args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:seek, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(args[0])),args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling seek(#{args[0]},#{args[1]})"
      end
    end
    #  Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
    #  <p>
    #  Elements emitted by this stream will be written to the write stream until this stream ends or fails.
    #  <p>
    #  Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
    #  called with the result.
    # @overload pipeTo(dst,handler)
    #   @param [::Vertx::WriteStream] dst the destination write stream
    #   @yield 
    # @return [void]
    def pipe_to(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pipe_to(#{args[0]})"
      end
    end
    #  Set the handler to be used when batches of messages are fetched
    #  from the Kafka server. Batch handlers need to take care not to block
    #  the event loop when dealing with large batches. It is better to process
    #  records individually using the {::VertxKafkaClient::KafkaConsumer#handler(Handler) record handler}.
    # @overload batchHandler(handler)
    #   @yield handler called when batches of messages are fetched
    # @return [self]
    def batch_handler
      if true
        @j_del.java_method(:batchHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxKafkaClient::KafkaConsumerRecords, nil, nil)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling batch_handler()"
      end
    end
    #  Unsubscribe from topics currently subscribed with subscribe.
    # @overload unsubscribe(completionHandler)
    #   @yield handler called on operation completed
    # @return [self]
    def unsubscribe
      if true
        if (block_given?)
          @j_del.java_method(:unsubscribe, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:unsubscribe, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling unsubscribe()"
      end
    end
    #  Create a new KafkaConsumer instance
    # @overload create(vertx,config)
    #   @param [::Vertx::Vertx] vertx Vert.x instance to use
    #   @param [Hash{String => String}] config Kafka consumer configuration
    # @overload create(vertx,config,keyType,valueType)
    #   @param [::Vertx::Vertx] vertx Vert.x instance to use
    #   @param [Hash{String => String}] config Kafka consumer configuration
    #   @param [Nil] keyType class type for the key deserialization
    #   @param [Nil] valueType class type for the value deserialization
    # @return [::VertxKafkaClient::KafkaConsumer] an instance of the KafkaConsumer
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given? && args[2] == nil && args[3] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxKafkaClientConsumer::KafkaConsumer.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::JavaUtil::Map.java_class]).call(args[0].j_del,Hash[args[1].map { |k,v| [k,v] }]),::VertxKafkaClient::KafkaConsumer, nil, nil)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && args[2].class == Class && args[3].class == Class && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxKafkaClientConsumer::KafkaConsumer.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::JavaUtil::Map.java_class,Java::JavaLang::Class.java_class,Java::JavaLang::Class.java_class]).call(args[0].j_del,Hash[args[1].map { |k,v| [k,v] }],::Vertx::Util::Utils.j_class_of(args[2]),::Vertx::Util::Utils.j_class_of(args[3])),::VertxKafkaClient::KafkaConsumer, ::Vertx::Util::Utils.v_type_of(args[2]), ::Vertx::Util::Utils.v_type_of(args[3]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]},#{args[2]},#{args[3]})"
      end
    end
    #  Pause this stream and return a  to transfer the elements of this stream to a destination .
    #  <p/>
    #  The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
    # @overload pipe()
    # @return [::Vertx::Pipe] a pipe
    def pipe
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:pipe, []).call(),::Vertx::Pipe,::VertxKafkaClient::KafkaConsumerRecord.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pipe()"
      end
    end
    #  Seek to the last offset for each of the given partitions.
    #  <p>
    #  Due to internal buffering of messages,
    #  the  will
    #  continue to observe messages fetched with respect to the old offset
    #  until some time <em>after</em> the given <code>completionHandler</code>
    #  is called. In contrast, the once the given <code>completionHandler</code>
    #  is called the {::VertxKafkaClient::KafkaConsumer#batch_handler} will only see messages
    #  consistent with the new offset.
    # @overload seekToEnd(topicPartition,completionHandler)
    #   @param [Hash{String => Object}] topicPartition topic partition for which seek
    #   @yield handler called on operation completed
    # @overload seekToEnd(topicPartitions,completionHandler)
    #   @param [Set<Hash{String => Object}>] topicPartitions topic partition for which seek
    #   @yield handler called on operation completed
    # @return [self]
    def seek_to_end(*args)
      if args[0].class == Hash && true
        if (block_given?)
          @j_del.java_method(:seekToEnd, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:seekToEnd, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == Set && true
        if (block_given?)
          @j_del.java_method(:seekToEnd, [Java::JavaUtil::Set.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::JavaUtil::LinkedHashSet.new(args[0].map { |element| Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(element)) }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:seekToEnd, [Java::JavaUtil::Set.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::JavaUtil::LinkedHashSet.new(args[0].map { |element| Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(element)) }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling seek_to_end(#{args[0]})"
      end
    end
    #  Close the consumer
    # @overload close(completionHandler)
    #   @yield handler called on operation completed
    # @return [void]
    def close
      if true
        if (block_given?)
          return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Look up the offset for the given partition by timestamp. Note: the result might be null in case
    #  for the given timestamp no offset can be found -- e.g., when the timestamp refers to the future
    # @overload offsetsForTimes(topicPartition,timestamp,handler)
    #   @param [Hash{String => Object}] topicPartition TopicPartition to query.
    #   @param [Fixnum] timestamp Timestamp to be used in the query.
    #   @yield handler called on operation completed
    # @return [void]
    def offsets_for_times(*args)
      if args[0].class == Hash && args[1].class == Fixnum && true
        if (block_given?)
          return @j_del.java_method(:offsetsForTimes, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::JavaLang::Long.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(args[0])),args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:offsetsForTimes, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::JavaLang::Long.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(args[0])),args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxKafkaClientConsumer::OffsetAndTimestamp))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling offsets_for_times(#{args[0]},#{args[1]})"
      end
    end
    #  Resume specified partitions which have been paused with pause.
    # @overload resume()
    # @overload resume(topicPartition,completionHandler)
    #   @param [Hash{String => Object}] topicPartition topic partition from which resume fetching
    #   @yield handler called on operation completed
    # @overload resume(topicPartitions,completionHandler)
    #   @param [Set<Hash{String => Object}>] topicPartitions topic partition from which resume fetching
    #   @yield handler called on operation completed
    # @return [self]
    def resume(*args)
      if !block_given? && args[0] == nil
        @j_del.java_method(:resume, []).call()
        return self
      elsif args[0].class == Hash && true
        if (block_given?)
          @j_del.java_method(:resume, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:resume, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == Set && true
        if (block_given?)
          @j_del.java_method(:resume, [Java::JavaUtil::Set.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::JavaUtil::LinkedHashSet.new(args[0].map { |element| Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(element)) }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:resume, [Java::JavaUtil::Set.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::JavaUtil::LinkedHashSet.new(args[0].map { |element| Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(element)) }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resume(#{args[0]})"
      end
    end
    #  Get the last offset for the given partition. The last offset of a partition is the offset
    #  of the upcoming message, i.e. the offset of the last available message + 1.
    # @overload endOffsets(topicPartition,handler)
    #   @param [Hash{String => Object}] topicPartition the partition to get the end offset.
    #   @yield handler called on operation completed. The end offset for the given partition.
    # @return [void]
    def end_offsets(*args)
      if args[0].class == Hash && true
        if (block_given?)
          return @j_del.java_method(:endOffsets, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:endOffsets, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling end_offsets(#{args[0]})"
      end
    end
    #  Get the last committed offset for the given partition (whether the commit happened by this process or another).
    # @overload committed(topicPartition,handler)
    #   @param [Hash{String => Object}] topicPartition topic partition for getting last committed offset
    #   @yield handler called on operation completed
    # @return [void]
    def committed(*args)
      if args[0].class == Hash && true
        if (block_given?)
          return @j_del.java_method(:committed, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:committed, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxKafkaClientConsumer::OffsetAndMetadata))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling committed(#{args[0]})"
      end
    end
    #  Subscribe to the given list of topics to get dynamically assigned partitions.
    #  <p>
    #  Due to internal buffering of messages, when changing the subscribed topics
    #  the old set of topics may remain in effect
    #  (as observed by the  record handler})
    #  until some time <em>after</em> the given <code>completionHandler</code>
    #  is called. In contrast, the once the given <code>completionHandler</code>
    #  is called the {::VertxKafkaClient::KafkaConsumer#batch_handler} will only see messages
    #  consistent with the new set of topics.
    # @overload subscribe(topic,completionHandler)
    #   @param [String] topic topic to subscribe to
    #   @yield handler called on operation completed
    # @overload subscribe(topics,completionHandler)
    #   @param [Set<String>] topics topics to subscribe to
    #   @yield handler called on operation completed
    # @return [self]
    def subscribe(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:subscribe, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:subscribe, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == Set && true
        if (block_given?)
          @j_del.java_method(:subscribe, [Java::JavaUtil::Set.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::JavaUtil::LinkedHashSet.new(args[0].map { |element| element }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:subscribe, [Java::JavaUtil::Set.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::JavaUtil::LinkedHashSet.new(args[0].map { |element| element }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling subscribe(#{args[0]})"
      end
    end
    #  Get the set of partitions currently assigned to this consumer.
    # @overload assignment(handler)
    #   @yield handler called on operation completed
    # @return [self]
    def assignment
      if true
        if (block_given?)
          @j_del.java_method(:assignment, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.to_set(ar.result).map! { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:assignment, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.to_set(ar.result).map! { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling assignment()"
      end
    end
    #  Get the first offset for the given partitions.
    # @overload beginningOffsets(topicPartition,handler)
    #   @param [Hash{String => Object}] topicPartition the partition to get the earliest offset.
    #   @yield handler called on operation completed. Returns the earliest available offset for the given partition
    # @return [void]
    def beginning_offsets(*args)
      if args[0].class == Hash && true
        if (block_given?)
          return @j_del.java_method(:beginningOffsets, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:beginningOffsets, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling beginning_offsets(#{args[0]})"
      end
    end
    #  Set the handler called when topic partitions are revoked to the consumer
    # @overload partitionsRevokedHandler(handler)
    #   @yield handler called on revoked topic partitions
    # @return [self]
    def partitions_revoked_handler
      if true
        @j_del.java_method(:partitionsRevokedHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.to_set(event).map! { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil }) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling partitions_revoked_handler()"
      end
    end
    #  Suspend fetching from the requested partitions.
    #  <p>
    #  Due to internal buffering of messages,
    #  the  will
    #  continue to observe messages from the given <code>topicPartitions</code>
    #  until some time <em>after</em> the given <code>completionHandler</code>
    #  is called. In contrast, the once the given <code>completionHandler</code>
    #  is called the {::VertxKafkaClient::KafkaConsumer#batch_handler} will not see messages
    #  from the given <code>topicPartitions</code>.
    # @overload pause()
    # @overload pause(topicPartition,completionHandler)
    #   @param [Hash{String => Object}] topicPartition topic partition from which suspend fetching
    #   @yield handler called on operation completed
    # @overload pause(topicPartitions,completionHandler)
    #   @param [Set<Hash{String => Object}>] topicPartitions topic partition from which suspend fetching
    #   @yield handler called on operation completed
    # @return [self]
    def pause(*args)
      if !block_given? && args[0] == nil
        @j_del.java_method(:pause, []).call()
        return self
      elsif args[0].class == Hash && true
        if (block_given?)
          @j_del.java_method(:pause, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:pause, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == Set && true
        if (block_given?)
          @j_del.java_method(:pause, [Java::JavaUtil::Set.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::JavaUtil::LinkedHashSet.new(args[0].map { |element| Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(element)) }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:pause, [Java::JavaUtil::Set.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::JavaUtil::LinkedHashSet.new(args[0].map { |element| Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(element)) }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pause(#{args[0]})"
      end
    end
    #  Set the handler called when topic partitions are assigned to the consumer
    # @overload partitionsAssignedHandler(handler)
    #   @yield handler called on assigned topic partitions
    # @return [self]
    def partitions_assigned_handler
      if true
        @j_del.java_method(:partitionsAssignedHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.to_set(event).map! { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil }) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling partitions_assigned_handler()"
      end
    end
    # @overload endHandler(endHandler)
    #   @yield 
    # @return [self]
    def end_handler
      if true
        @j_del.java_method(:endHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling end_handler()"
      end
    end
    #  Get metadata about the partitions for a given topic.
    # @overload partitionsFor(topic,handler)
    #   @param [String] topic topic partition for which getting partitions info
    #   @yield handler called on operation completed
    # @return [self]
    def partitions_for(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:partitionsFor, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:partitionsFor, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling partitions_for(#{args[0]})"
      end
    end
    # @overload fetch(amount)
    #   @param [Fixnum] amount 
    # @return [self]
    def fetch(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:fetch, [Java::long.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling fetch(#{args[0]})"
      end
    end
    #  Get the offset of the next record that will be fetched (if a record with that offset exists).
    # @overload position(partition,handler)
    #   @param [Hash{String => Object}] partition The partition to get the position for
    #   @yield handler called on operation completed
    # @return [void]
    def position(*args)
      if args[0].class == Hash && true
        if (block_given?)
          return @j_del.java_method(:position, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:position, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling position(#{args[0]})"
      end
    end
    #  Seek to the first offset for each of the given partitions.
    #  <p>
    #  Due to internal buffering of messages,
    #  the  will
    #  continue to observe messages fetched with respect to the old offset
    #  until some time <em>after</em> the given <code>completionHandler</code>
    #  is called. In contrast, the once the given <code>completionHandler</code>
    #  is called the {::VertxKafkaClient::KafkaConsumer#batch_handler} will only see messages
    #  consistent with the new offset.
    # @overload seekToBeginning(topicPartition,completionHandler)
    #   @param [Hash{String => Object}] topicPartition topic partition for which seek
    #   @yield handler called on operation completed
    # @overload seekToBeginning(topicPartitions,completionHandler)
    #   @param [Set<Hash{String => Object}>] topicPartitions topic partition for which seek
    #   @yield handler called on operation completed
    # @return [self]
    def seek_to_beginning(*args)
      if args[0].class == Hash && true
        if (block_given?)
          @j_del.java_method(:seekToBeginning, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:seekToBeginning, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == Set && true
        if (block_given?)
          @j_del.java_method(:seekToBeginning, [Java::JavaUtil::Set.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::JavaUtil::LinkedHashSet.new(args[0].map { |element| Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(element)) }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:seekToBeginning, [Java::JavaUtil::Set.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::JavaUtil::LinkedHashSet.new(args[0].map { |element| Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(element)) }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling seek_to_beginning(#{args[0]})"
      end
    end
    # @overload exceptionHandler(handler)
    #   @yield 
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exception_handler()"
      end
    end
    #  Manually assign a list of partition to this consumer.
    #  <p>
    #  Due to internal buffering of messages, when reassigning
    #  the old set of partitions may remain in effect
    #  (as observed by the  record handler)}
    #  until some time <em>after</em> the given <code>completionHandler</code>
    #  is called. In contrast, the once the given <code>completionHandler</code>
    #  is called the {::VertxKafkaClient::KafkaConsumer#batch_handler} will only see messages
    #  consistent with the new set of partitions.
    # @overload assign(topicPartition,completionHandler)
    #   @param [Hash{String => Object}] topicPartition partition which want assigned
    #   @yield handler called on operation completed
    # @overload assign(topicPartitions,completionHandler)
    #   @param [Set<Hash{String => Object}>] topicPartitions partitions which want assigned
    #   @yield handler called on operation completed
    # @return [self]
    def assign(*args)
      if args[0].class == Hash && true
        if (block_given?)
          @j_del.java_method(:assign, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:assign, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == Set && true
        if (block_given?)
          @j_del.java_method(:assign, [Java::JavaUtil::Set.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::JavaUtil::LinkedHashSet.new(args[0].map { |element| Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(element)) }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:assign, [Java::JavaUtil::Set.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::JavaUtil::LinkedHashSet.new(args[0].map { |element| Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(element)) }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling assign(#{args[0]})"
      end
    end
  end
end
