require 'vertx-kafka-client/kafka_header'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.kafka.client.consumer.KafkaConsumerRecord
module VertxKafkaClient
  #  Vert.x Kafka consumer record
  class KafkaConsumerRecord
    # @private
    # @param j_del [::VertxKafkaClient::KafkaConsumerRecord] the java delegate
    def initialize(j_del, j_arg_K=nil, j_arg_V=nil)
      @j_del = j_del
      @j_arg_K = j_arg_K != nil ? j_arg_K : ::Vertx::Util::unknown_type
      @j_arg_V = j_arg_V != nil ? j_arg_V : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::VertxKafkaClient::KafkaConsumerRecord] the underlying java delegate
    def j_del
      @j_del
    end
    # @overload headers()
    # @return [Array<::VertxKafkaClient::KafkaHeader>] the list of consumer record headers
    def headers
      if !block_given?
        return @j_del.java_method(:headers, []).call().to_a.map { |elt| ::Vertx::Util::Utils.safe_create(elt,::VertxKafkaClient::KafkaHeader) }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling headers()"
      end
    end
    # @overload partition()
    # @return [Fixnum] the partition from which this record is received
    def partition
      if !block_given?
        return @j_del.java_method(:partition, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling partition()"
      end
    end
    # @overload offset()
    # @return [Fixnum] the position of this record in the corresponding Kafka partition.
    def offset
      if !block_given?
        return @j_del.java_method(:offset, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling offset()"
      end
    end
    # @overload checksum()
    # @return [Fixnum] the checksum (CRC32) of the record.
    def checksum
      if !block_given?
        return @j_del.java_method(:checksum, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling checksum()"
      end
    end
    # @overload topic()
    # @return [String] the topic this record is received from
    def topic
      if !block_given?
        return @j_del.java_method(:topic, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling topic()"
      end
    end
    # @overload timestampType()
    # @return [:NO_TIMESTAMP_TYPE,:CREATE_TIME,:LOG_APPEND_TIME] the timestamp type of this record
    def timestamp_type
      if !block_given?
        return @j_del.java_method(:timestampType, []).call().name.intern
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling timestamp_type()"
      end
    end
    # @overload value()
    # @return [Object] the value
    def value
      if !block_given?
        return @j_arg_V.wrap(@j_del.java_method(:value, []).call())
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling value()"
      end
    end
    # @overload key()
    # @return [Object] the key (or null if no key is specified)
    def key
      if !block_given?
        return @j_arg_K.wrap(@j_del.java_method(:key, []).call())
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling key()"
      end
    end
    # @overload timestamp()
    # @return [Fixnum] the timestamp of this record
    def timestamp
      if !block_given?
        return @j_del.java_method(:timestamp, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling timestamp()"
      end
    end
  end
end
