require 'vertx/buffer'
require 'vertx-kafka-client/kafka_header'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.kafka.client.producer.KafkaProducerRecord
module VertxKafkaClient
  #  Vert.x Kafka producer record.
  class KafkaProducerRecord
    # @private
    # @param j_del [::VertxKafkaClient::KafkaProducerRecord] the java delegate
    def initialize(j_del, j_arg_K=nil, j_arg_V=nil)
      @j_del = j_del
      @j_arg_K = j_arg_K != nil ? j_arg_K : ::Vertx::Util::unknown_type
      @j_arg_V = j_arg_V != nil ? j_arg_V : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::VertxKafkaClient::KafkaProducerRecord] the underlying java delegate
    def j_del
      @j_del
    end
    # @overload headers()
    # @return [Array<::VertxKafkaClient::KafkaHeader>] the headers of this record
    def headers
      if !block_given?
        if @cached_headers != nil
          return @cached_headers
        end
        return @cached_headers = @j_del.java_method(:headers, []).call().to_a.map { |elt| ::Vertx::Util::Utils.safe_create(elt,::VertxKafkaClient::KafkaHeader) }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling headers()"
      end
    end
    #  Add a list of headers to this record.
    # @overload addHeaders(headers)
    #   @param [Array<::VertxKafkaClient::KafkaHeader>] headers the headers
    # @return [self]
    def add_headers(*args)
      if args[0].class == Array && !block_given?
        @j_del.java_method(:addHeaders, [Java::JavaUtil::List.java_class]).call(args[0].map { |element| element.j_del })
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_headers(#{args[0]})"
      end
    end
    #  Like {::VertxKafkaClient::KafkaProducerRecord#add_header} but with a key/value pair
    # @overload addHeader(header)
    #   @param [::VertxKafkaClient::KafkaHeader] header the header
    # @overload addHeader(key,value)
    #   @param [String] key 
    #   @param [String] value 
    # @overload addHeader(key,value)
    #   @param [String] key 
    #   @param [::Vertx::Buffer] value 
    # @return [self]
    def add_header(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        @j_del.java_method(:addHeader, [Java::IoVertxKafkaClientProducer::KafkaHeader.java_class]).call(args[0].j_del)
        return self
      elsif args[0].class == String && args[1].class == String && !block_given?
        @j_del.java_method(:addHeader, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
        return self
      elsif args[0].class == String && args[1].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:addHeader, [Java::java.lang.String.java_class,Java::IoVertxCoreBuffer::Buffer.java_class]).call(args[0],args[1].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_header(#{args[0]},#{args[1]})"
      end
    end
    # @overload partition()
    # @return [Fixnum] the partition to which the record will be sent (or null if no partition was specified)
    def partition
      if !block_given?
        return @j_del.java_method(:partition, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling partition()"
      end
    end
    # @overload topic()
    # @return [String] the topic this record is being sent to
    def topic
      if !block_given?
        return @j_del.java_method(:topic, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling topic()"
      end
    end
    #  Create a concrete instance of a Vert.x producer record
    # @overload create(topic,value)
    #   @param [String] topic the topic this record is being sent to
    #   @param [Object] value the value
    # @overload create(topic,key,value)
    #   @param [String] topic the topic this record is being sent to
    #   @param [Object] key the key (or null if no key is specified)
    #   @param [Object] value the value
    # @overload create(topic,key,value,timestamp,partition)
    #   @param [String] topic the topic this record is being sent to
    #   @param [Object] key the key (or null if no key is specified)
    #   @param [Object] value the value
    #   @param [Fixnum] timestamp the timestamp of this record
    #   @param [Fixnum] partition the partition to which the record will be sent (or null if no partition was specified)
    # @return [::VertxKafkaClient::KafkaProducerRecord] Vert.x producer record
    def self.create(*args)
      if args[0].class == String && ::Vertx::Util::unknown_type.accept?(args[1]) && !block_given? && args[2] == nil && args[3] == nil && args[4] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxKafkaClientProducer::KafkaProducerRecord.java_method(:create, [Java::java.lang.String.java_class,Java::java.lang.Object.java_class]).call(args[0],::Vertx::Util::Utils.to_object(args[1])),::VertxKafkaClient::KafkaProducerRecord, nil, nil)
      elsif args[0].class == String && ::Vertx::Util::unknown_type.accept?(args[1]) && ::Vertx::Util::unknown_type.accept?(args[2]) && !block_given? && args[3] == nil && args[4] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxKafkaClientProducer::KafkaProducerRecord.java_method(:create, [Java::java.lang.String.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(args[0],::Vertx::Util::Utils.to_object(args[1]),::Vertx::Util::Utils.to_object(args[2])),::VertxKafkaClient::KafkaProducerRecord, nil, nil)
      elsif args[0].class == String && ::Vertx::Util::unknown_type.accept?(args[1]) && ::Vertx::Util::unknown_type.accept?(args[2]) && args[3].class == Fixnum && args[4].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxKafkaClientProducer::KafkaProducerRecord.java_method(:create, [Java::java.lang.String.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::JavaLang::Long.java_class,Java::JavaLang::Integer.java_class]).call(args[0],::Vertx::Util::Utils.to_object(args[1]),::Vertx::Util::Utils.to_object(args[2]),args[3],::Vertx::Util::Utils.to_integer(args[4])),::VertxKafkaClient::KafkaProducerRecord, nil, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]},#{args[2]},#{args[3]},#{args[4]})"
      end
    end
    # @overload value()
    # @return [Object] the value
    def value
      if !block_given?
        return @j_arg_V.wrap(@j_del.java_method(:value, []).call())
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling value()"
      end
    end
    # @overload key()
    # @return [Object] the key (or null if no key is specified)
    def key
      if !block_given?
        return @j_arg_K.wrap(@j_del.java_method(:key, []).call())
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling key()"
      end
    end
    # @overload timestamp()
    # @return [Fixnum] the timestamp of this record
    def timestamp
      if !block_given?
        return @j_del.java_method(:timestamp, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling timestamp()"
      end
    end
  end
end
