require 'vertx/vertx'
require 'vertx-mqtt/mqtt_endpoint'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.mqtt.MqttServer
module VertxMqtt
  #  An MQTT server
  #  <p>
  #     You can accept incoming MQTT connection requests providing a {::VertxMqtt::MqttServer#endpoint_handler}. As the
  #     requests arrive, the handler will be called with an instance of {::VertxMqtt::MqttEndpoint} in order to manage the
  #     communication with the remote MQTT client.
  #  </p>
  class MqttServer
    # @private
    # @param j_del [::VertxMqtt::MqttServer] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxMqtt::MqttServer] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MqttServer
    end
    def @@j_api_type.wrap(obj)
      MqttServer.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxMqtt::MqttServer.java_class
    end
    #  Set the endpoint handler for the server. If an MQTT client connect to the server a
    #  new MqttEndpoint instance will be created and passed to the handler
    # @overload endpointHandler(handler)
    #   @yield the endpoint handler
    # @return [self]
    def endpoint_handler
      if true
        @j_del.java_method(:endpointHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxMqtt::MqttEndpoint)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling endpoint_handler()"
      end
    end
    #  The actual port the server is listening on. This is useful if you bound the server specifying 0 as port number
    #  signifying an ephemeral port
    # @overload actualPort()
    # @return [Fixnum] the actual port the server is listening on.
    def actual_port
      if !block_given?
        return @j_del.java_method(:actualPort, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling actual_port()"
      end
    end
    #  Return an MQTT server instance
    # @overload create(vertx)
    #   @param [::Vertx::Vertx] vertx Vert.x instance
    # @overload create(vertx,options)
    #   @param [::Vertx::Vertx] vertx Vert.x instance
    #   @param [Hash{String => Object}] options MQTT server options
    # @return [::VertxMqtt::MqttServer] MQTT server instance
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxMqtt::MqttServer.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxMqtt::MqttServer)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxMqtt::MqttServer.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxMqtt::MqttServerOptions.java_class]).call(args[0].j_del,Java::IoVertxMqtt::MqttServerOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxMqtt::MqttServer)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  Close the server supplying an handler that will be called when the server is actually closed (or has failed).
    # @overload close(completionHandler)
    #   @yield the handler called on completion
    # @return [void]
    def close
      if true
        if (block_given?)
          return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Set an exception handler for the server, that will be called when an error happens independantly of an
    #  accepted {::VertxMqtt::MqttEndpoint}, like a rejected connection
    # @overload exceptionHandler(handler)
    #   @yield the exception handler
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exception_handler()"
      end
    end
    #  Start the server listening for incoming connections on the port and host specified
    #  It ignores any options specified through the constructor
    # @overload listen(listenHandler)
    #   @yield handler called when the asynchronous listen call ends
    # @overload listen(port,listenHandler)
    #   @param [Fixnum] port the port to listen on
    #   @yield handler called when the asynchronous listen call ends
    # @overload listen(port,host,listenHandler)
    #   @param [Fixnum] port the port to listen on
    #   @param [String] host the host to listen on
    #   @yield handler called when the asynchronous listen call ends
    # @return [self]
    def listen(*args)
      if true && args[0] == nil && args[1] == nil
        if (block_given?)
          @j_del.java_method(:listen, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMqtt::MqttServer) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:listen, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMqtt::MqttServer) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxMqtt::MqttServer.j_api_type)
        end
      elsif args[0].class == Fixnum && true && args[1] == nil
        if (block_given?)
          @j_del.java_method(:listen, [Java::int.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMqtt::MqttServer) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:listen, [Java::int.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMqtt::MqttServer) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxMqtt::MqttServer.j_api_type)
        end
      elsif args[0].class == Fixnum && args[1].class == String && true
        if (block_given?)
          @j_del.java_method(:listen, [Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMqtt::MqttServer) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:listen, [Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMqtt::MqttServer) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxMqtt::MqttServer.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling listen(#{args[0]},#{args[1]})"
      end
    end
  end
end
