require 'vertx/buffer'
require 'vertx-rabbitmq/rabbit_mq_message'
require 'vertx/vertx'
require 'vertx/future'
require 'vertx-rabbitmq/rabbit_mq_consumer'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.rabbitmq.RabbitMQClient
module VertxRabbitmq
  class RabbitMQClient
    # @private
    # @param j_del [::VertxRabbitmq::RabbitMQClient] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxRabbitmq::RabbitMQClient] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == RabbitMQClient
    end
    def @@j_api_type.wrap(obj)
      RabbitMQClient.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxRabbitmq::RabbitMQClient.java_class
    end
    #  Unbind an exchange from an exchange.
    # @overload exchangeUnbind(destination,source,routingKey,resultHandler)
    #   @param [String] destination 
    #   @param [String] source 
    #   @param [String] routingKey 
    #   @yield 
    # @return [void]
    def exchange_unbind(*args)
      if args[0].class == String && args[1].class == String && args[2].class == String && true
        if (block_given?)
          return @j_del.java_method(:exchangeUnbind, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:exchangeUnbind, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exchange_unbind(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Enables publisher acknowledgements on this channel. Can be called once during client initialisation. Calls to basicPublish()
    #  will have to be confirmed.
    # @overload confirmSelect(resultHandler)
    #   @yield 
    # @return [void]
    def confirm_select
      if true
        if (block_given?)
          return @j_del.java_method(:confirmSelect, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:confirmSelect, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling confirm_select()"
      end
    end
    #  Wait until all messages published since the last call have been either ack'd or nack'd by the broker; or until timeout elapses. If the timeout expires a TimeoutException is thrown.
    # @overload waitForConfirms(resultHandler)
    #   @yield 
    # @overload waitForConfirms(timeout,resultHandler)
    #   @param [Fixnum] timeout 
    #   @yield 
    # @return [void]
    def wait_for_confirms(*args)
      if true && args[0] == nil
        if (block_given?)
          return @j_del.java_method(:waitForConfirms, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:waitForConfirms, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == Fixnum && true
        if (block_given?)
          return @j_del.java_method(:waitForConfirms, [Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:waitForConfirms, [Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling wait_for_confirms(#{args[0]})"
      end
    end
    #  Returns the number of messages in a queue ready to be delivered.
    # @overload messageCount(queue,resultHandler)
    #   @param [String] queue 
    #   @yield 
    # @return [void]
    def message_count(*args)
      if args[0].class == String && true
        if (block_given?)
          return @j_del.java_method(:messageCount, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:messageCount, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling message_count(#{args[0]})"
      end
    end
    #  Request specific "quality of service" settings.
    # 
    #  These settings impose limits on the amount of data the server
    #  will deliver to consumers before requiring acknowledgements.
    #  Thus they provide a means of consumer-initiated flow control.
    # @overload basicQos(prefetchCount,resultHandler)
    #   @param [Fixnum] prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
    #   @yield handler called when operation is done with a result of the operation
    # @overload basicQos(prefetchCount,global,resultHandler)
    #   @param [Fixnum] prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
    #   @param [true,false] global true if the settings should be applied to the entire channel rather than each consumer
    #   @yield handler called when operation is done with a result of the operation
    # @overload basicQos(prefetchSize,prefetchCount,global,resultHandler)
    #   @param [Fixnum] prefetchSize maximum amount of content (measured in octets) that the server will deliver, 0 if unlimited
    #   @param [Fixnum] prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
    #   @param [true,false] global true if the settings should be applied to the entire channel rather than each consumer
    #   @yield handler called when operation is done with a result of the operation
    # @return [void]
    def basic_qos(*args)
      if args[0].class == Fixnum && true && args[1] == nil && args[2] == nil
        if (block_given?)
          return @j_del.java_method(:basicQos, [Java::int.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:basicQos, [Java::int.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == Fixnum && (args[1].class == TrueClass || args[1].class == FalseClass) && true && args[2] == nil
        if (block_given?)
          return @j_del.java_method(:basicQos, [Java::int.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:basicQos, [Java::int.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == Fixnum && args[1].class == Fixnum && (args[2].class == TrueClass || args[2].class == FalseClass) && true
        if (block_given?)
          return @j_del.java_method(:basicQos, [Java::int.java_class,Java::int.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:basicQos, [Java::int.java_class,Java::int.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling basic_qos(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Bind a queue to an exchange
    # @overload queueBind(queue,exchange,routingKey,resultHandler)
    #   @param [String] queue 
    #   @param [String] exchange 
    #   @param [String] routingKey 
    #   @yield 
    # @return [void]
    def queue_bind(*args)
      if args[0].class == String && args[1].class == String && args[2].class == String && true
        if (block_given?)
          return @j_del.java_method(:queueBind, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:queueBind, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling queue_bind(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Check if a connection is open
    # @overload isConnected()
    # @return [true,false] true when the connection is open, false otherwise
    def connected?
      if !block_given?
        return @j_del.java_method(:isConnected, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling connected?()"
      end
    end
    #  Start the rabbitMQ client. Create the connection and the chanel.
    # @overload start(resultHandler)
    #   @yield 
    # @return [void]
    def start
      if true
        if (block_given?)
          return @j_del.java_method(:start, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:start, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling start()"
      end
    end
    #  Create a consumer with the given <code>options</code>.
    # @overload basicConsumer(queue,resultHandler)
    #   @param [String] queue 
    #   @yield 
    # @overload basicConsumer(queue,options,resultHandler)
    #   @param [String] queue the name of a queue
    #   @param [Hash{String => Object}] options options for queue
    #   @yield a handler through which you can find out the operation status; if the operation succeeds you can begin to receive messages through an instance of {::VertxRabbitmq::RabbitMQConsumer}
    # @return [void]
    def basic_consumer(*args)
      if args[0].class == String && true && args[1] == nil
        if (block_given?)
          return @j_del.java_method(:basicConsumer, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRabbitmq::RabbitMQConsumer) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:basicConsumer, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRabbitmq::RabbitMQConsumer) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxRabbitmq::RabbitMQConsumer.j_api_type)
        end
      elsif args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          return @j_del.java_method(:basicConsumer, [Java::java.lang.String.java_class,Java::IoVertxRabbitmq::QueueOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxRabbitmq::QueueOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRabbitmq::RabbitMQConsumer) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:basicConsumer, [Java::java.lang.String.java_class,Java::IoVertxRabbitmq::QueueOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxRabbitmq::QueueOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRabbitmq::RabbitMQConsumer) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxRabbitmq::RabbitMQConsumer.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling basic_consumer(#{args[0]},#{args[1]})"
      end
    end
    #  Retrieve a message from a queue using AMQP.Basic.Get
    # @overload basicGet(queue,autoAck,resultHandler)
    #   @param [String] queue 
    #   @param [true,false] autoAck 
    #   @yield 
    # @return [void]
    def basic_get(*args)
      if args[0].class == String && (args[1].class == TrueClass || args[1].class == FalseClass) && true
        if (block_given?)
          return @j_del.java_method(:basicGet, [Java::java.lang.String.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRabbitmq::RabbitMQMessage) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:basicGet, [Java::java.lang.String.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRabbitmq::RabbitMQMessage) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxRabbitmq::RabbitMQMessage.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling basic_get(#{args[0]},#{args[1]})"
      end
    end
    #  Check if a channel is open
    # @overload isOpenChannel()
    # @return [true,false] true when the connection is open, false otherwise
    def open_channel?
      if !block_given?
        return @j_del.java_method(:isOpenChannel, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling open_channel?()"
      end
    end
    #  Actively declare a server-named exclusive, autodelete, non-durable queue.
    # @overload queueDeclareAuto(resultHandler)
    #   @yield 
    # @return [void]
    def queue_declare_auto
      if true
        if (block_given?)
          return @j_del.java_method(:queueDeclareAuto, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:queueDeclareAuto, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling queue_declare_auto()"
      end
    end
    #  Bind an exchange to an exchange.
    # @overload exchangeBind(destination,source,routingKey,resultHandler)
    #   @param [String] destination 
    #   @param [String] source 
    #   @param [String] routingKey 
    #   @yield 
    # @return [void]
    def exchange_bind(*args)
      if args[0].class == String && args[1].class == String && args[2].class == String && true
        if (block_given?)
          return @j_del.java_method(:exchangeBind, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:exchangeBind, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exchange_bind(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Like {::VertxRabbitmq::RabbitMQClient#queue_delete} but returns a <code>Future</code> of the asynchronous result
    # @overload queueDelete(queue)
    #   @param [String] queue 
    # @return [::Vertx::Future]
    def queue_delete(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:queueDelete, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::Future, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling queue_delete(#{args[0]})"
      end
    end
    #  Delete an exchange, without regard for whether it is in use or not.
    # @overload exchangeDelete(exchange,resultHandler)
    #   @param [String] exchange 
    #   @yield 
    # @return [void]
    def exchange_delete(*args)
      if args[0].class == String && true
        if (block_given?)
          return @j_del.java_method(:exchangeDelete, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:exchangeDelete, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exchange_delete(#{args[0]})"
      end
    end
    #  Stop the rabbitMQ client. Close the connection and its chanel.
    # @overload stop(resultHandler)
    #   @yield 
    # @return [void]
    def stop
      if true
        if (block_given?)
          return @j_del.java_method(:stop, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:stop, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling stop()"
      end
    end
    #  Like {::VertxRabbitmq::RabbitMQClient#queue_declare} but returns a <code>Future</code> of the asynchronous result
    # @overload queueDeclare(queue,durable,exclusive,autoDelete)
    #   @param [String] queue 
    #   @param [true,false] durable 
    #   @param [true,false] exclusive 
    #   @param [true,false] autoDelete 
    # @return [::Vertx::Future]
    def queue_declare(*args)
      if args[0].class == String && (args[1].class == TrueClass || args[1].class == FalseClass) && (args[2].class == TrueClass || args[2].class == FalseClass) && (args[3].class == TrueClass || args[3].class == FalseClass) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:queueDeclare, [Java::java.lang.String.java_class,Java::boolean.java_class,Java::boolean.java_class,Java::boolean.java_class]).call(args[0],args[1],args[2],args[3]),::Vertx::Future, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling queue_declare(#{args[0]},#{args[1]},#{args[2]},#{args[3]})"
      end
    end
    #  Acknowledge one or several received messages. Supply the deliveryTag from the AMQP.Basic.GetOk or AMQP.Basic.Deliver
    #  method containing the received message being acknowledged.
    # @overload basicAck(deliveryTag,multiple,resultHandler)
    #   @param [Fixnum] deliveryTag 
    #   @param [true,false] multiple 
    #   @yield 
    # @return [void]
    def basic_ack(*args)
      if args[0].class == Fixnum && (args[1].class == TrueClass || args[1].class == FalseClass) && true
        if (block_given?)
          return @j_del.java_method(:basicAck, [Java::long.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:basicAck, [Java::long.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling basic_ack(#{args[0]},#{args[1]})"
      end
    end
    #  Create and return a client.
    # @overload create(vertx)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    # @overload create(vertx,config)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    #   @param [Hash{String => Object}] config the client config
    # @return [::VertxRabbitmq::RabbitMQClient] the client
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxRabbitmq::RabbitMQClient.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxRabbitmq::RabbitMQClient)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxRabbitmq::RabbitMQClient.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxRabbitmq::RabbitMQOptions.java_class]).call(args[0].j_del,Java::IoVertxRabbitmq::RabbitMQOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxRabbitmq::RabbitMQClient)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  Publish a message. Publishing to a non-existent exchange will result in a channel-level protocol exception,
    #  which closes the channel. Invocations of Channel#basicPublish will eventually block if a resource-driven alarm is in effect.
    # @overload basicPublish(exchange,routingKey,body,resultHandler)
    #   @param [String] exchange 
    #   @param [String] routingKey 
    #   @param [::Vertx::Buffer] body 
    #   @yield 
    # @return [void]
    def basic_publish(*args)
      if args[0].class == String && args[1].class == String && args[2].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:basicPublish, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:basicPublish, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling basic_publish(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Reject one or several received messages.
    # @overload basicNack(deliveryTag,multiple,requeue,resultHandler)
    #   @param [Fixnum] deliveryTag 
    #   @param [true,false] multiple 
    #   @param [true,false] requeue 
    #   @yield 
    # @return [void]
    def basic_nack(*args)
      if args[0].class == Fixnum && (args[1].class == TrueClass || args[1].class == FalseClass) && (args[2].class == TrueClass || args[2].class == FalseClass) && true
        if (block_given?)
          return @j_del.java_method(:basicNack, [Java::long.java_class,Java::boolean.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:basicNack, [Java::long.java_class,Java::boolean.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling basic_nack(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Declare an exchange with additional parameters such as dead lettering, an alternate exchange or TTL.
    # @overload exchangeDeclare(exchange,type,durable,autoDelete,resultHandler)
    #   @param [String] exchange 
    #   @param [String] type 
    #   @param [true,false] durable 
    #   @param [true,false] autoDelete 
    #   @yield 
    # @overload exchangeDeclare(exchange,type,durable,autoDelete,config,resultHandler)
    #   @param [String] exchange 
    #   @param [String] type 
    #   @param [true,false] durable 
    #   @param [true,false] autoDelete 
    #   @param [Hash{String => Object}] config 
    #   @yield 
    # @return [void]
    def exchange_declare(*args)
      if args[0].class == String && args[1].class == String && (args[2].class == TrueClass || args[2].class == FalseClass) && (args[3].class == TrueClass || args[3].class == FalseClass) && true && args[4] == nil
        if (block_given?)
          return @j_del.java_method(:exchangeDeclare, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::boolean.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],args[3],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:exchangeDeclare, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::boolean.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],args[3],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && args[1].class == String && (args[2].class == TrueClass || args[2].class == FalseClass) && (args[3].class == TrueClass || args[3].class == FalseClass) && args[4].class == Hash && true
        if (block_given?)
          return @j_del.java_method(:exchangeDeclare, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::boolean.java_class,Java::boolean.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],args[3],::Vertx::Util::Utils.to_json_object(args[4]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:exchangeDeclare, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::boolean.java_class,Java::boolean.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],args[3],::Vertx::Util::Utils.to_json_object(args[4]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exchange_declare(#{args[0]},#{args[1]},#{args[2]},#{args[3]},#{args[4]})"
      end
    end
    #  Like {::VertxRabbitmq::RabbitMQClient#queue_delete_if} but returns a <code>Future</code> of the asynchronous result
    # @overload queueDeleteIf(queue,ifUnused,ifEmpty)
    #   @param [String] queue 
    #   @param [true,false] ifUnused 
    #   @param [true,false] ifEmpty 
    # @return [::Vertx::Future]
    def queue_delete_if(*args)
      if args[0].class == String && (args[1].class == TrueClass || args[1].class == FalseClass) && (args[2].class == TrueClass || args[2].class == FalseClass) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:queueDeleteIf, [Java::java.lang.String.java_class,Java::boolean.java_class,Java::boolean.java_class]).call(args[0],args[1],args[2]),::Vertx::Future, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling queue_delete_if(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
  end
end
