require 'vertx/buffer'
require 'vertx-redis/command'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.redis.client.Request
module VertxRedis
  #  Builder for REDIS requests that will be encoded according to the RESP protocol was introduced in Redis 1.2.
  #  Which became the standard way for talking with the Redis server in Redis 2.0.
  # 
  #  Redis <a href="https://redis.io/topics/protocol">protocol documentation</a> states:
  # 
  #  <blockquote>
  #      Clients send commands to a Redis server as a RESP Array of Bulk Strings.
  #  </blockquote>
  # 
  #  So all non String/Bulk types will be encoded to Bulk for convenience.
  class Request
    # @private
    # @param j_del [::VertxRedis::Request] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxRedis::Request] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Request
    end
    def @@j_api_type.wrap(obj)
      Request.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxRedisClient::Request.java_class
    end
    #  Adds a NULL encoded string
    # @overload nullArg()
    # @return [self]
    def null_arg
      if !block_given?
        @j_del.java_method(:nullArg, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling null_arg()"
      end
    end
    #  Adds a String using a specific character encoding argument
    # @overload arg(arg)
    #   @param [String] arg 
    # @overload arg(arg)
    #   @param [::Vertx::Buffer] arg 
    # @overload arg(arg)
    #   @param [Fixnum] arg 
    # @overload arg(arg)
    #   @param [true,false] arg 
    # @overload arg(arg,enc)
    #   @param [String] arg 
    #   @param [String] enc 
    # @return [self]
    def arg(*args)
      if args[0].class == String && !block_given? && args[1] == nil
        @j_del.java_method(:arg, [Java::java.lang.String.java_class]).call(args[0])
        return self
      elsif args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        @j_del.java_method(:arg, [Java::IoVertxCoreBuffer::Buffer.java_class]).call(args[0].j_del)
        return self
      elsif args[0].class == Fixnum && !block_given? && args[1] == nil
        @j_del.java_method(:arg, [Java::long.java_class]).call(args[0])
        return self
      elsif (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given? && args[1] == nil
        @j_del.java_method(:arg, [Java::boolean.java_class]).call(args[0])
        return self
      elsif args[0].class == String && args[1].class == String && !block_given?
        @j_del.java_method(:arg, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling arg(#{args[0]},#{args[1]})"
      end
    end
    # @overload cmd(command)
    #   @param [::VertxRedis::Command] command 
    # @return [::VertxRedis::Request]
    def self.cmd(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Request.java_method(:cmd, [Java::IoVertxRedisClient::Command.java_class]).call(args[0].j_del),::VertxRedis::Request)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling cmd(#{args[0]})"
      end
    end
    #  Get the Command that is to be used by this request.
    # @overload command()
    # @return [::VertxRedis::Command] the command.
    def command
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:command, []).call(),::VertxRedis::Command)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling command()"
      end
    end
  end
end
