require 'vertx-service-discovery/service_discovery'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.servicediscovery.types.EventBusService
module VertxServiceDiscovery
  #   for event bus services (service proxies).
  #  Consumers receive a service proxy to use the service.
  class EventBusService
    # @private
    # @param j_del [::VertxServiceDiscovery::EventBusService] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxServiceDiscovery::EventBusService] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == EventBusService
    end
    def @@j_api_type.wrap(obj)
      EventBusService.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxServicediscoveryTypes::EventBusService.java_class
    end
    #  Lookup for a service record and if found, retrieve it and return the service object (used to consume the service).
    #  This is a convenient method to avoid explicit lookup and then retrieval of the service. This method requires to
    #  have the <code>clientClass</code> set with the expected set of client. This is important for usages not using Java so
    #  you can pass the expected type.
    # @overload getServiceProxyWithJsonFilter(discovery,filter,clientClass,resultHandler)
    #   @param [::VertxServiceDiscovery::ServiceDiscovery] discovery the service discovery
    #   @param [Hash{String => Object}] filter the filter as json object
    #   @param [Nil] clientClass the client class
    #   @yield the result handler
    # @return [Object] <code>null</code> - do not use
    def self.get_service_proxy_with_json_filter(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Hash && args[2].class == Class && true
        return ::Vertx::Util::Utils.v_type_of(args[2]).wrap(Java::IoVertxServicediscoveryTypes::EventBusService.java_method(:getServiceProxyWithJsonFilter, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::JavaLang::Class.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.j_class_of(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.v_type_of(args[2]).wrap(ar.result) : nil) } : promise))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_service_proxy_with_json_filter(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Sugar method to creates a record for this type.
    #  <p>
    #  The java interface is added to the metadata in the `service.interface` key.
    # @overload createRecord(name,address,classname)
    #   @param [String] name the service name
    #   @param [String] address the address
    #   @param [String] classname the payload class
    # @overload createRecord(name,address,itf,metadata)
    #   @param [String] name the name of the service.
    #   @param [String] address the event bus address on which the service available
    #   @param [String] itf the Java interface (name)
    #   @param [Hash{String => Object}] metadata the metadata
    # @return [Hash{String => Object}] the created record
    def self.create_record(*args)
      if args[0].class == String && args[1].class == String && args[2].class == String && !block_given? && args[3] == nil
        return Java::IoVertxServicediscoveryTypes::EventBusService.java_method(:createRecord, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2]) != nil ? JSON.parse(Java::IoVertxServicediscoveryTypes::EventBusService.java_method(:createRecord, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2]).toJson.encode) : nil
      elsif args[0].class == String && args[1].class == String && args[2].class == String && args[3].class == Hash && !block_given?
        return Java::IoVertxServicediscoveryTypes::EventBusService.java_method(:createRecord, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(args[0],args[1],args[2],::Vertx::Util::Utils.to_json_object(args[3])) != nil ? JSON.parse(Java::IoVertxServicediscoveryTypes::EventBusService.java_method(:createRecord, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(args[0],args[1],args[2],::Vertx::Util::Utils.to_json_object(args[3])).toJson.encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_record(#{args[0]},#{args[1]},#{args[2]},#{args[3]})"
      end
    end
    #  Lookup for a service record and if found, retrieve it and return the service object (used to consume the service).
    #  This is a convenient method to avoid explicit lookup and then retrieval of the service. This method requires to
    #  have the <code>clientClass</code> set with the expected set of client. This is important for usages not using Java so
    #  you can pass the expected type.
    # @overload getServiceProxy(discovery,filter,clientClass,resultHandler)
    #   @param [::VertxServiceDiscovery::ServiceDiscovery] discovery the service discovery
    #   @param [Proc] filter the filter
    #   @param [Nil] clientClass the client class
    #   @yield the result handler
    # @return [Object] <code>null</code> - do not use
    def self.get_service_proxy(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Proc && args[2].class == Class && true
        return ::Vertx::Util::Utils.v_type_of(args[2]).wrap(Java::IoVertxServicediscoveryTypes::EventBusService.java_method(:getServiceProxy, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::JavaUtilFunction::Function.java_class,Java::JavaLang::Class.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,(Proc.new { |event| args[1].call(event != nil ? JSON.parse(event.toJson.encode) : nil) unless args[1] == nil }),::Vertx::Util::Utils.j_class_of(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.v_type_of(args[2]).wrap(ar.result) : nil) } : promise))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_service_proxy(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Unknown type.
    def self.UNKNOWN
      Java::IoVertxServicediscoveryTypes::EventBusService.UNKNOWN
    end
    #  Name of the type.
    def self.TYPE
      Java::IoVertxServicediscoveryTypes::EventBusService.TYPE
    end
  end
end
