require 'vertx-service-discovery/service_discovery'
require 'vertx/message_consumer'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.servicediscovery.types.MessageSource
module VertxServiceDiscovery
  #  Service type for data producer. Providers are publishing data to a specific event bus address.
  class MessageSource
    # @private
    # @param j_del [::VertxServiceDiscovery::MessageSource] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxServiceDiscovery::MessageSource] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MessageSource
    end
    def @@j_api_type.wrap(obj)
      MessageSource.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxServicediscoveryTypes::MessageSource.java_class
    end
    #  Create a record representing a data producer.
    # @overload createRecord(name,address)
    #   @param [String] name the name of the service
    #   @param [String] address the address on which the data is sent.
    # @overload createRecord(name,address,type)
    #   @param [String] name the name of the service
    #   @param [String] address the address on which the data is sent
    #   @param [String] type the type of payload
    # @overload createRecord(name,address,type,metadata)
    #   @param [String] name the name of the service
    #   @param [String] address the address on which the data is sent
    #   @param [String] type the type of payload (fully qualified name of the class)
    #   @param [Hash{String => Object}] metadata additional metadata
    # @return [Hash{String => Object}] the created record
    def self.create_record(*args)
      if args[0].class == String && args[1].class == String && !block_given? && args[2] == nil && args[3] == nil
        return Java::IoVertxServicediscoveryTypes::MessageSource.java_method(:createRecord, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1]) != nil ? JSON.parse(Java::IoVertxServicediscoveryTypes::MessageSource.java_method(:createRecord, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1]).toJson.encode) : nil
      elsif args[0].class == String && args[1].class == String && args[2].class == String && !block_given? && args[3] == nil
        return Java::IoVertxServicediscoveryTypes::MessageSource.java_method(:createRecord, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2]) != nil ? JSON.parse(Java::IoVertxServicediscoveryTypes::MessageSource.java_method(:createRecord, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2]).toJson.encode) : nil
      elsif args[0].class == String && args[1].class == String && args[2].class == String && args[3].class == Hash && !block_given?
        return Java::IoVertxServicediscoveryTypes::MessageSource.java_method(:createRecord, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(args[0],args[1],args[2],::Vertx::Util::Utils.to_json_object(args[3])) != nil ? JSON.parse(Java::IoVertxServicediscoveryTypes::MessageSource.java_method(:createRecord, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(args[0],args[1],args[2],::Vertx::Util::Utils.to_json_object(args[3])).toJson.encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_record(#{args[0]},#{args[1]},#{args[2]},#{args[3]})"
      end
    end
    #  Convenient method that looks for a message source and provides the configured . The
    #  async result is marked as failed is there are no matching services, or if the lookup fails.
    # @overload getConsumer(discovery,filter,resultHandler)
    #   @param [::VertxServiceDiscovery::ServiceDiscovery] discovery The service discovery instance
    #   @param [Hash{String => Object}] filter The filter, optional
    #   @yield The result handler
    # @overload getConsumer(discovery,filter,resultHandler)
    #   @param [::VertxServiceDiscovery::ServiceDiscovery] discovery The service discovery instance
    #   @param [Proc] filter The filter, must not be <code>null</code>
    #   @yield The result handler
    # @return [void]
    def self.get_consumer(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Hash && true
        if (block_given?)
          return Java::IoVertxServicediscoveryTypes::MessageSource.java_method(:getConsumer, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::MessageConsumer, nil) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          Java::IoVertxServicediscoveryTypes::MessageSource.java_method(:getConsumer, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::MessageConsumer, nil) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::MessageConsumer.j_api_type)
        end
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Proc && true
        if (block_given?)
          return Java::IoVertxServicediscoveryTypes::MessageSource.java_method(:getConsumer, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::JavaUtilFunction::Function.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,(Proc.new { |event| args[1].call(event != nil ? JSON.parse(event.toJson.encode) : nil) unless args[1] == nil }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::MessageConsumer, nil) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          Java::IoVertxServicediscoveryTypes::MessageSource.java_method(:getConsumer, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::JavaUtilFunction::Function.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,(Proc.new { |event| args[1].call(event != nil ? JSON.parse(event.toJson.encode) : nil) unless args[1] == nil }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::MessageConsumer, nil) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::MessageConsumer.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_consumer(#{args[0]},#{args[1]})"
      end
    end
    #  Unknown type.
    def self.UNKNOWN
      Java::IoVertxServicediscoveryTypes::MessageSource.UNKNOWN
    end
    def self.TYPE
      Java::IoVertxServicediscoveryTypes::MessageSource.TYPE
    end
  end
end
