require 'vertx-redis/redis'
require 'vertx-service-discovery/service_discovery'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.servicediscovery.types.RedisDataSource
module VertxServiceDiscovery
  #  Service type for Redis data source.
  class RedisDataSource
    # @private
    # @param j_del [::VertxServiceDiscovery::RedisDataSource] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxServiceDiscovery::RedisDataSource] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == RedisDataSource
    end
    def @@j_api_type.wrap(obj)
      RedisDataSource.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxServicediscoveryTypes::RedisDataSource.java_class
    end
    #  Convenient method that looks for a Redis data source and provides the configured {::VertxRedis::Redis}.
    #  The async result is marked as failed is there are no matching services, or if the lookup fails.
    # @overload getRedisClient(discovery,filter,resultHandler)
    #   @param [::VertxServiceDiscovery::ServiceDiscovery] discovery The service discovery instance
    #   @param [Hash{String => Object}] filter The filter, optional
    #   @yield The result handler
    # @overload getRedisClient(discovery,filter,resultHandler)
    #   @param [::VertxServiceDiscovery::ServiceDiscovery] discovery The service discovery instance
    #   @param [Proc] filter The filter, cannot be <code>null</code>
    #   @yield The result handler
    # @overload getRedisClient(discovery,filter,consumerConfiguration,resultHandler)
    #   @param [::VertxServiceDiscovery::ServiceDiscovery] discovery The service discovery instance
    #   @param [Hash{String => Object}] filter The filter, optional
    #   @param [Hash{String => Object}] consumerConfiguration The additional consumer configuration
    #   @yield The result handler
    # @overload getRedisClient(discovery,filter,consumerConfiguration,resultHandler)
    #   @param [::VertxServiceDiscovery::ServiceDiscovery] discovery The service discovery instance
    #   @param [Proc] filter The filter, cannot be <code>null</code>
    #   @param [Hash{String => Object}] consumerConfiguration The additional consumer configuration
    #   @yield The result handler
    # @return [void]
    def self.get_redis_client(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Hash && true && args[2] == nil
        if (block_given?)
          return Java::IoVertxServicediscoveryTypes::RedisDataSource.java_method(:getRedisClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Redis) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          Java::IoVertxServicediscoveryTypes::RedisDataSource.java_method(:getRedisClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Redis) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxRedis::Redis.j_api_type)
        end
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Proc && true && args[2] == nil
        if (block_given?)
          return Java::IoVertxServicediscoveryTypes::RedisDataSource.java_method(:getRedisClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::JavaUtilFunction::Function.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,(Proc.new { |event| args[1].call(event != nil ? JSON.parse(event.toJson.encode) : nil) unless args[1] == nil }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Redis) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          Java::IoVertxServicediscoveryTypes::RedisDataSource.java_method(:getRedisClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::JavaUtilFunction::Function.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,(Proc.new { |event| args[1].call(event != nil ? JSON.parse(event.toJson.encode) : nil) unless args[1] == nil }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Redis) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxRedis::Redis.j_api_type)
        end
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && args[2].class == Hash && true
        if (block_given?)
          return Java::IoVertxServicediscoveryTypes::RedisDataSource.java_method(:getRedisClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Redis) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          Java::IoVertxServicediscoveryTypes::RedisDataSource.java_method(:getRedisClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Redis) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxRedis::Redis.j_api_type)
        end
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Proc && args[2].class == Hash && true
        if (block_given?)
          return Java::IoVertxServicediscoveryTypes::RedisDataSource.java_method(:getRedisClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::JavaUtilFunction::Function.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,(Proc.new { |event| args[1].call(event != nil ? JSON.parse(event.toJson.encode) : nil) unless args[1] == nil }),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Redis) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          Java::IoVertxServicediscoveryTypes::RedisDataSource.java_method(:getRedisClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::JavaUtilFunction::Function.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,(Proc.new { |event| args[1].call(event != nil ? JSON.parse(event.toJson.encode) : nil) unless args[1] == nil }),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Redis) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxRedis::Redis.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_redis_client(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Convenient method to create a record for a Redis data source.
    # @overload createRecord(name,location,metadata)
    #   @param [String] name the service name
    #   @param [Hash{String => Object}] location the location of the service (e.g. url, port...)
    #   @param [Hash{String => Object}] metadata additional metadata
    # @return [Hash{String => Object}] the created record
    def self.create_record(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == Hash && !block_given?
        return Java::IoVertxServicediscoveryTypes::RedisDataSource.java_method(:createRecord, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2])) != nil ? JSON.parse(Java::IoVertxServicediscoveryTypes::RedisDataSource.java_method(:createRecord, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2])).toJson.encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_record(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Unknown type.
    def self.UNKNOWN
      Java::IoVertxServicediscoveryTypes::RedisDataSource.UNKNOWN
    end
    def self.TYPE
      Java::IoVertxServicediscoveryTypes::RedisDataSource.TYPE
    end
  end
end
