require 'vertx-shell/command'
require 'vertx/vertx'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.shell.command.CommandResolver
module VertxShell
  #  A resolver for commands, so the shell can discover commands.
  class CommandResolver
    # @private
    # @param j_del [::VertxShell::CommandResolver] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxShell::CommandResolver] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == CommandResolver
    end
    def @@j_api_type.wrap(obj)
      CommandResolver.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtShellCommand::CommandResolver.java_class
    end
    #  Returns a single command by its name.
    # @overload getCommand(name)
    #   @param [String] name the command name
    # @return [::VertxShell::Command] the commad or null
    def get_command(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getCommand, [Java::java.lang.String.java_class]).call(args[0]),::VertxShell::Command)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_command(#{args[0]})"
      end
    end
    # @overload commands()
    # @return [Array<::VertxShell::Command>] the current commands
    def commands
      if !block_given?
        return @j_del.java_method(:commands, []).call().to_a.map { |elt| ::Vertx::Util::Utils.safe_create(elt,::VertxShell::Command) }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling commands()"
      end
    end
    # @overload baseCommands(vertx)
    #   @param [::Vertx::Vertx] vertx 
    # @return [::VertxShell::CommandResolver] the base commands of Vert.x Shell.
    def self.base_commands(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtShellCommand::CommandResolver.java_method(:baseCommands, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxShell::CommandResolver)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling base_commands(#{args[0]})"
      end
    end
  end
end
