require 'vertx-shell/tty'
require 'vertx-shell/session'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.shell.system.Process
module VertxShell
  #  A process managed by the shell.
  class Process
    # @private
    # @param j_del [::VertxShell::Process] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxShell::Process] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Process
    end
    def @@j_api_type.wrap(obj)
      Process.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtShellSystem::Process.java_class
    end
    #  Resume the process.
    # @overload suspend()
    # @overload suspend(completionHandler)
    #   @yield handler called after suspend callback
    # @return [void]
    def suspend
      if !block_given?
        return @j_del.java_method(:suspend, []).call()
      elsif true
        return @j_del.java_method(:suspend, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling suspend()"
      end
    end
    #  Suspend the process.
    # @overload resume()
    # @overload resume(foreground)
    #   @param [true,false] foreground 
    # @overload resume(completionHandler)
    #   @yield handler called after resume callback
    # @overload resume(foreground,completionHandler)
    #   @param [true,false] foreground 
    #   @yield handler called after resume callback
    # @return [void]
    def resume(*args)
      if !block_given? && args[0] == nil
        return @j_del.java_method(:resume, []).call()
      elsif (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        return @j_del.java_method(:resume, [Java::boolean.java_class]).call(args[0])
      elsif true && args[0] == nil
        return @j_del.java_method(:resume, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
      elsif (args[0].class == TrueClass || args[0].class == FalseClass) && true
        return @j_del.java_method(:resume, [Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],(Proc.new { |event| yield(nil) unless !block_given? }))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resume(#{args[0]})"
      end
    end
    #  Set an handler for being notified when the process terminates.
    # @overload terminatedHandler(handler)
    #   @yield the handler called when the process terminates.
    # @return [self]
    def terminated_handler
      if true
        @j_del.java_method(:terminatedHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling terminated_handler()"
      end
    end
    #  Run the process.
    # 
    # @overload run()
    # @overload run(foregraound)
    #   @param [true,false] foregraound 
    # @return [void]
    def run(*args)
      if !block_given? && args[0] == nil
        return @j_del.java_method(:run, []).call()
      elsif (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        return @j_del.java_method(:run, [Java::boolean.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling run(#{args[0]})"
      end
    end
    # @overload getTty()
    # @return [::VertxShell::Tty] the process tty
    def get_tty
      if !block_given?
        if @cached_get_tty != nil
          return @cached_get_tty
        end
        return @cached_get_tty = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getTty, []).call(),::VertxShell::Tty)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_tty()"
      end
    end
    #  Set the process tty.
    # @overload setTty(tty)
    #   @param [::VertxShell::Tty] tty the process tty
    # @return [self]
    def set_tty(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:setTty, [Java::IoVertxExtShellTerm::Tty.java_class]).call(args[0].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_tty(#{args[0]})"
      end
    end
    #  Attempt to interrupt the process.
    # @overload interrupt()
    # @overload interrupt(completionHandler)
    #   @yield handler called after interrupt callback
    # @return [true,false] true if the process caught the signal
    def interrupt?
      if !block_given?
        return @j_del.java_method(:interrupt, []).call()
      elsif true
        return @j_del.java_method(:interrupt, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling interrupt?()"
      end
    end
    # @overload exitCode()
    # @return [Fixnum] the process exit code when the status is  otherwise <code>null</code>
    def exit_code
      if !block_given?
        return @j_del.java_method(:exitCode, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exit_code()"
      end
    end
    #  Set the process in background.
    # @overload toBackground()
    # @overload toBackground(completionHandler)
    #   @yield handler called after background callback
    # @return [void]
    def to_background
      if !block_given?
        return @j_del.java_method(:toBackground, []).call()
      elsif true
        return @j_del.java_method(:toBackground, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling to_background()"
      end
    end
    #  Terminate the process.
    # @overload terminate()
    # @overload terminate(completionHandler)
    #   @yield handler called after end callback
    # @return [void]
    def terminate
      if !block_given?
        return @j_del.java_method(:terminate, []).call()
      elsif true
        return @j_del.java_method(:terminate, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling terminate()"
      end
    end
    #  Set the process session
    # @overload setSession(session)
    #   @param [::VertxShell::Session] session the process session
    # @return [self]
    def set_session(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:setSession, [Java::IoVertxExtShellSession::Session.java_class]).call(args[0].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_session(#{args[0]})"
      end
    end
    #  Set the process in foreground.
    # @overload toForeground()
    # @overload toForeground(completionHandler)
    #   @yield handler called after foreground callback
    # @return [void]
    def to_foreground
      if !block_given?
        return @j_del.java_method(:toForeground, []).call()
      elsif true
        return @j_del.java_method(:toForeground, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling to_foreground()"
      end
    end
    # @overload getSession()
    # @return [::VertxShell::Session] the process session
    def get_session
      if !block_given?
        if @cached_get_session != nil
          return @cached_get_session
        end
        return @cached_get_session = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getSession, []).call(),::VertxShell::Session)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_session()"
      end
    end
    # @overload status()
    # @return [:READY,:RUNNING,:STOPPED,:TERMINATED] the current process status
    def status
      if !block_given?
        return @j_del.java_method(:status, []).call().name.intern
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling status()"
      end
    end
  end
end
