require 'vertx-shell/tty'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.shell.term.Pty
module VertxShell
  #  A pseudo terminal used for controlling a {::VertxShell::Tty}. This interface acts as a pseudo
  #  terminal master, {::VertxShell::Pty#slave} returns the assocated slave pseudo terminal.
  class Pty
    # @private
    # @param j_del [::VertxShell::Pty] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxShell::Pty] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Pty
    end
    def @@j_api_type.wrap(obj)
      Pty.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtShellTerm::Pty.java_class
    end
    # @overload slave()
    # @return [::VertxShell::Tty] the pseudo terminal slave
    def slave
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:slave, []).call(),::VertxShell::Tty)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling slave()"
      end
    end
    #  Resize the terminal.
    # @overload setSize(width,height)
    #   @param [Fixnum] width 
    #   @param [Fixnum] height 
    # @return [self]
    def set_size(*args)
      if args[0].class == Fixnum && args[1].class == Fixnum && !block_given?
        @j_del.java_method(:setSize, [Java::int.java_class,Java::int.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_size(#{args[0]},#{args[1]})"
      end
    end
    #  Set the standard out handler of the pseudo terminal.
    # @overload stdoutHandler(handler)
    #   @yield the standard output
    # @return [self]
    def stdout_handler
      if true
        @j_del.java_method(:stdoutHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling stdout_handler()"
      end
    end
    #  Create a new pseudo terminal.
    # @overload create()
    # @overload create(terminalType)
    #   @param [String] terminalType the terminal type, for instance 
    # @return [::VertxShell::Pty] the created pseudo terminal
    def self.create(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtShellTerm::Pty.java_method(:create, []).call(),::VertxShell::Pty)
      elsif args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtShellTerm::Pty.java_method(:create, [Java::java.lang.String.java_class]).call(args[0]),::VertxShell::Pty)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]})"
      end
    end
    #  Write data to the slave standard input of the pseudo terminal.
    # @overload write(data)
    #   @param [String] data the data to write
    # @return [self]
    def write(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:write, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write(#{args[0]})"
      end
    end
  end
end
