require 'vertx-shell/job'
require 'vertx-shell/job_controller'
require 'vertx-shell/cli_token'
require 'vertx-shell/session'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.shell.Shell
module VertxShell
  #  An interactive session between a consumer and a shell.
  class Shell
    # @private
    # @param j_del [::VertxShell::Shell] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxShell::Shell] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Shell
    end
    def @@j_api_type.wrap(obj)
      Shell.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtShell::Shell.java_class
    end
    #  Set a new prompt in this session.
    # @overload setPrompt(prompt)
    #   @yield the new prompt will be calculated when it's needed.
    # @return [void]
    def set_prompt(*args)
      if block_given? && args[0] == nil
        return @j_del.java_method(:setPrompt, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxShell::Session)) unless !block_given? }))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_prompt(#{args[0]})"
      end
    end
    # @overload session()
    # @return [::VertxShell::Session] the current shell session
    def session
      if !block_given?
        if @cached_session != nil
          return @cached_session
        end
        return @cached_session = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:session, []).call(),::VertxShell::Session)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling session()"
      end
    end
    #  See {::VertxShell::Shell#create_job}
    # @overload createJob(line)
    #   @param [Array<::VertxShell::CliToken>] line the command line creating this job
    # @overload createJob(line)
    #   @param [String] line 
    # @return [::VertxShell::Job]
    def create_job(*args)
      if args[0].class == Array && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createJob, [Java::JavaUtil::List.java_class]).call(args[0].map { |element| element.j_del }),::VertxShell::Job)
      elsif args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createJob, [Java::java.lang.String.java_class]).call(args[0]),::VertxShell::Job)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_job(#{args[0]})"
      end
    end
    #  Close the shell.
    # @overload close()
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    # @overload jobController()
    # @return [::VertxShell::JobController] the shell's job controller
    def job_controller
      if !block_given?
        if @cached_job_controller != nil
          return @cached_job_controller
        end
        return @cached_job_controller = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:jobController, []).call(),::VertxShell::JobController)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling job_controller()"
      end
    end
  end
end
