require 'vertx-shell/completion'
require 'vertx-shell/signal_handler'
require 'vertx-shell/tty'
require 'vertx-shell/session'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.shell.term.Term
module VertxShell
  #  The terminal.
  class Term < ::VertxShell::Tty
    # @private
    # @param j_del [::VertxShell::Term] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxShell::Term] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Term
    end
    def @@j_api_type.wrap(obj)
      Term.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtShellTerm::Term.java_class
    end
    # @overload lastAccessedTime()
    # @return [Fixnum] the last time this term received input
    def last_accessed_time
      if !block_given?
        return @j_del.java_method(:lastAccessedTime, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling last_accessed_time()"
      end
    end
    #  Set a suspend signal handler on the term.
    # @overload suspendHandler(handler)
    #   @param [::VertxShell::SignalHandler] handler the suspend handler
    # @return [self]
    def suspend_handler(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:suspendHandler, [Java::IoVertxExtShellTerm::SignalHandler.java_class]).call(args[0].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling suspend_handler(#{args[0]})"
      end
    end
    # @overload stdinHandler(handler)
    #   @yield 
    # @return [self]
    def stdin_handler
      if true
        @j_del.java_method(:stdinHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling stdin_handler()"
      end
    end
    #  Set an interrupt signal handler on the term.
    # @overload interruptHandler(handler)
    #   @param [::VertxShell::SignalHandler] handler the interrupt handler
    # @return [self]
    def interrupt_handler(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:interruptHandler, [Java::IoVertxExtShellTerm::SignalHandler.java_class]).call(args[0].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling interrupt_handler(#{args[0]})"
      end
    end
    #  Echo some text in the terminal, escaped if necessary.<p/>
    # @overload echo(text)
    #   @param [String] text the text to echo
    # @return [self]
    def echo(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:echo, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling echo(#{args[0]})"
      end
    end
    #  Associate the term with a session.
    # @overload setSession(session)
    #   @param [::VertxShell::Session] session the session to set
    # @return [::VertxShell::Term] a reference to this, so the API can be used fluently
    def set_session(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:setSession, [Java::IoVertxExtShellSession::Session.java_class]).call(args[0].j_del),::VertxShell::Term)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_session(#{args[0]})"
      end
    end
    #  Set a handler that will be called when the terminal is closed.
    # @overload closeHandler(handler)
    #   @yield the handler
    # @return [self]
    def close_handler
      if true
        @j_del.java_method(:closeHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close_handler()"
      end
    end
    #  Close the connection to terminal.
    # @overload close()
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    # @overload write(data)
    #   @param [String] data 
    # @return [self]
    def write(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:write, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write(#{args[0]})"
      end
    end
    #  Prompt the user a line of text, providing a completion handler to handle user's completion.
    # @overload readline(prompt,lineHandler)
    #   @param [String] prompt the displayed prompt
    #   @yield the line handler called with the line
    # @overload readline(prompt,lineHandler,completionHandler)
    #   @param [String] prompt the displayed prompt
    #   @param [Proc] lineHandler the line handler called with the line
    #   @yield the completion handler
    # @return [void]
    def readline(*args)
      if args[0].class == String && true && args[1] == nil
        return @j_del.java_method(:readline, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],(Proc.new { |event| yield(event) unless !block_given? }))
      elsif args[0].class == String && args[1].class == Proc && true
        return @j_del.java_method(:readline, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],(Proc.new { |event| args[1].call(event) unless args[1] == nil }),(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxShell::Completion)) unless !block_given? }))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling readline(#{args[0]},#{args[1]})"
      end
    end
    # @overload resizehandler(handler)
    #   @yield 
    # @return [self]
    def resizehandler
      if true
        @j_del.java_method(:resizehandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resizehandler()"
      end
    end
  end
end
