require 'vertx-sql-client/sql_client'
require 'vertx-sql-client/row'
require 'vertx-sql-client/row_set'
require 'vertx/future'
require 'vertx-sql-client/prepared_query'
require 'vertx-sql-client/tuple'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.sqlclient.Transaction
module VertxSqlClient
  #  A transaction that allows to control the transaction and receive events.
  class Transaction < ::VertxSqlClient::SqlClient
    # @private
    # @param j_del [::VertxSqlClient::Transaction] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxSqlClient::Transaction] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Transaction
    end
    def @@j_api_type.wrap(obj)
      Transaction.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxSqlclient::Transaction.java_class
    end
    #  Like {::VertxSqlClient::Transaction#rollback} with an handler to be notified when the transaction rollback has completed
    # @overload rollback(handler)
    #   @yield 
    # @return [void]
    def rollback
      if true
        if (block_given?)
          return @j_del.java_method(:rollback, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:rollback, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling rollback()"
      end
    end
    #  Create a prepared query.
    # @overload prepare(sql,handler)
    #   @param [String] sql the sql
    #   @yield the handler notified with the prepared query asynchronously
    # @return [self]
    def prepare(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:prepare, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::PreparedQuery) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:prepare, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::PreparedQuery) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxSqlClient::PreparedQuery.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling prepare(#{args[0]})"
      end
    end
    #  Set an handler to be called when the transaction is aborted.
    # @overload abortHandler(handler)
    #   @yield the handler
    # @return [self]
    def abort_handler
      if true
        @j_del.java_method(:abortHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling abort_handler()"
      end
    end
    # @overload preparedBatch(sql,batch,handler)
    #   @param [String] sql 
    #   @param [Array<::VertxSqlClient::Tuple>] batch 
    #   @yield 
    # @return [self]
    def prepared_batch(*args)
      if args[0].class == String && args[1].class == Array && true
        if (block_given?)
          @j_del.java_method(:preparedBatch, [Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].map { |element| element.j_del },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:preparedBatch, [Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].map { |element| element.j_del },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxSqlClient::RowSet.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling prepared_batch(#{args[0]},#{args[1]})"
      end
    end
    # @overload query(sql,handler)
    #   @param [String] sql 
    #   @yield 
    # @return [self]
    def query(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:query, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:query, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxSqlClient::RowSet.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling query(#{args[0]})"
      end
    end
    #  Like {::VertxSqlClient::Transaction#commit} with an handler to be notified when the transaction commit has completed
    # @overload commit(handler)
    #   @yield 
    # @return [void]
    def commit
      if true
        if (block_given?)
          return @j_del.java_method(:commit, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:commit, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling commit()"
      end
    end
    #  Rollback the transaction and release the associated resources.
    # @overload close()
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    # @overload preparedQuery(sql,handler)
    #   @param [String] sql 
    #   @yield 
    # @overload preparedQuery(sql,arguments,handler)
    #   @param [String] sql 
    #   @param [::VertxSqlClient::Tuple] arguments 
    #   @yield 
    # @return [self]
    def prepared_query(*args)
      if args[0].class == String && true && args[1] == nil
        if (block_given?)
          @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxSqlClient::RowSet.j_api_type)
        end
      elsif args[0].class == String && args[1].class.method_defined?(:j_del) && true
        if (block_given?)
          @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxSqlclient::Tuple.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxSqlclient::Tuple.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxSqlClient::RowSet.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling prepared_query(#{args[0]},#{args[1]})"
      end
    end
  end
end
