require 'vertx-sql/sql_row_stream'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.sql.SQLOperations
module VertxSql
  module SQLOperations
    #  Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
    # @overload call(sql,resultHandler)
    #   @param [String] sql the SQL to execute. For example <code>{call getEmpName}</code>.
    #   @yield the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
    # @return [self]
    def call(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:call, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:call, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtSql::ResultSet))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling call(#{args[0]})"
      end
    end
    #  Executes the given SQL <code>SELECT</code> prepared statement which returns the results of the query.
    # @overload queryWithParams(sql,params,resultHandler)
    #   @param [String] sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
    #   @param [Array<String,Object>] params these are the parameters to fill the statement.
    #   @yield the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
    # @return [self]
    def query_with_params(*args)
      if args[0].class == String && args[1].class == Array && true
        if (block_given?)
          @j_del.java_method(:queryWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_array(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:queryWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_array(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtSql::ResultSet))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling query_with_params(#{args[0]},#{args[1]})"
      end
    end
    #  Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
    # 
    #  The index of params and outputs are important for both arrays, for example when dealing with a prodecure that
    #  takes the first 2 arguments as input values and the 3 arg as an output then the arrays should be like:
    # 
    #  <pre>
    #    params = [VALUE1, VALUE2, null]
    #    outputs = [null, null, "VARCHAR"]
    #  </pre>
    # @overload callWithParams(sql,params,outputs,resultHandler)
    #   @param [String] sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
    #   @param [Array<String,Object>] params these are the parameters to fill the statement.
    #   @param [Array<String,Object>] outputs these are the outputs to fill the statement.
    #   @yield the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
    # @return [self]
    def call_with_params(*args)
      if args[0].class == String && args[1].class == Array && args[2].class == Array && true
        if (block_given?)
          @j_del.java_method(:callWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_array(args[1]),::Vertx::Util::Utils.to_json_array(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:callWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_array(args[1]),::Vertx::Util::Utils.to_json_array(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtSql::ResultSet))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling call_with_params(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
    #  statement with the given parameters
    # @overload updateWithParams(sql,params,resultHandler)
    #   @param [String] sql the SQL to execute. For example <code>INSERT INTO table ...</code>
    #   @param [Array<String,Object>] params these are the parameters to fill the statement.
    #   @yield the handler which is called once the operation completes.
    # @return [self]
    def update_with_params(*args)
      if args[0].class == String && args[1].class == Array && true
        if (block_given?)
          @j_del.java_method(:updateWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_array(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:updateWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_array(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtSql::UpdateResult))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling update_with_params(#{args[0]},#{args[1]})"
      end
    end
    #  Executes the given SQL <code>SELECT</code> statement which returns the results of the query.
    # @overload query(sql,resultHandler)
    #   @param [String] sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
    #   @yield the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
    # @return [self]
    def query(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:query, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:query, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtSql::ResultSet))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling query(#{args[0]})"
      end
    end
    #  Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
    #  getting a connection from the pool (this object) and return it back after the execution. Only the first result
    #  from the result set is returned.
    # @overload querySingle(sql,handler)
    #   @param [String] sql the statement to execute
    #   @yield the result handler
    # @return [self]
    def query_single(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:querySingle, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:querySingle, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling query_single(#{args[0]})"
      end
    end
    #  Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
    #  statement.
    # @overload update(sql,resultHandler)
    #   @param [String] sql the SQL to execute. For example <code>INSERT INTO table ...</code>
    #   @yield the handler which is called once the operation completes.
    # @return [self]
    def update(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:update, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:update, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtSql::UpdateResult))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling update(#{args[0]})"
      end
    end
    #  Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
    #  boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
    #  Only the first result from the result set is returned.
    # @overload querySingleWithParams(sql,arguments,handler)
    #   @param [String] sql the statement to execute
    #   @param [Array<String,Object>] arguments the arguments
    #   @yield the result handler
    # @return [self]
    def query_single_with_params(*args)
      if args[0].class == String && args[1].class == Array && true
        if (block_given?)
          @j_del.java_method(:querySingleWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_array(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:querySingleWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_array(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling query_single_with_params(#{args[0]},#{args[1]})"
      end
    end
    #  Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
    # @overload queryStreamWithParams(sql,params,handler)
    #   @param [String] sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
    #   @param [Array<String,Object>] params these are the parameters to fill the statement.
    #   @yield the handler which is called once the operation completes. It will return a <code>SQLRowStream</code>.
    # @return [self]
    def query_stream_with_params(*args)
      if args[0].class == String && args[1].class == Array && true
        if (block_given?)
          @j_del.java_method(:queryStreamWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_array(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSql::SQLRowStream) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:queryStreamWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_array(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSql::SQLRowStream) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxSql::SQLRowStream.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling query_stream_with_params(#{args[0]},#{args[1]})"
      end
    end
    #  Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
    # @overload queryStream(sql,handler)
    #   @param [String] sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
    #   @yield the handler which is called once the operation completes. It will return a <code>SQLRowStream</code>.
    # @return [self]
    def query_stream(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:queryStream, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSql::SQLRowStream) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:queryStream, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSql::SQLRowStream) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxSql::SQLRowStream.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling query_stream(#{args[0]})"
      end
    end
  end
  class SQLOperationsImpl
    include SQLOperations
    # @private
    # @param j_del [::VertxSql::SQLOperations] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxSql::SQLOperations] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == SQLOperations
    end
    def @@j_api_type.wrap(obj)
      SQLOperations.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtSql::SQLOperations.java_class
    end
  end
end
