require 'vertx-stomp/destination'
require 'vertx/vertx'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.stomp.DestinationFactory
module VertxStomp
  #  Interface implemented to customize the destination creation.
  class DestinationFactory
    # @private
    # @param j_del [::VertxStomp::DestinationFactory] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxStomp::DestinationFactory] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == DestinationFactory
    end
    def @@j_api_type.wrap(obj)
      DestinationFactory.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtStomp::DestinationFactory.java_class
    end
    #  Creates a destination for the given <em>address</em>.
    # @overload create(vertx,name)
    #   @param [::Vertx::Vertx] vertx the vert.x instance used by the STOMP server.
    #   @param [String] name the destination name.
    # @return [::VertxStomp::Destination] the destination, <code>null</code> to reject the creation.
    def create(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class]).call(args[0].j_del,args[1]),::VertxStomp::Destination)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
  end
end
