require 'vertx-unit/completion'
require 'vertx/promise'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.unit.Async
module VertxUnit
  #  An asynchronous exit point for a test.<p/>
  class Async < ::VertxUnit::Completion
    # @private
    # @param j_del [::VertxUnit::Async] the java delegate
    def initialize(j_del)
      super(j_del, nil)
      @j_del = j_del
    end
    # @private
    # @return [::VertxUnit::Async] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Async
    end
    def @@j_api_type.wrap(obj)
      Async.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtUnit::Async.java_class
    end
    #  Completion handler to receive a completion signal when this completions completes.
    # @overload handler(completionHandler)
    #   @yield the completion handler
    # @return [void]
    def handler
      if true
        if (block_given?)
          return @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handler()"
      end
    end
    #  Completes the future upon completion, otherwise fails it.
    # @overload resolve(future)
    #   @param [::Vertx::Promise] future the future to resolve
    # @return [void]
    def resolve(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:resolve, [Java::IoVertxCore::Promise.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resolve(#{args[0]})"
      end
    end
    # @overload count()
    # @return [Fixnum] the current count
    def count
      if !block_given?
        return @j_del.java_method(:count, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling count()"
      end
    end
    #  Count down the async.
    # @overload countDown()
    # @return [void]
    def count_down
      if !block_given?
        return @j_del.java_method(:countDown, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling count_down()"
      end
    end
    #  Signals the asynchronous operation is done, this method must be called with a count greater than <code>0</code>,
    #  otherwise it throws an <code>IllegalStateException</code> to signal the error.
    # @overload complete()
    # @return [void]
    def complete
      if !block_given?
        return @j_del.java_method(:complete, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling complete()"
      end
    end
  end
end
