require 'vertx/promise'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.unit.Completion
module VertxUnit
  #  A completion object that emits completion notifications either <i>succeeded</i> or <i>failed</i>.
  class Completion
    # @private
    # @param j_del [::VertxUnit::Completion] the java delegate
    def initialize(j_del, j_arg_T=nil)
      @j_del = j_del
      @j_arg_T = j_arg_T != nil ? j_arg_T : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::VertxUnit::Completion] the underlying java delegate
    def j_del
      @j_del
    end
    #  Completion handler to receive a completion signal when this completions completes.
    # @overload handler(completionHandler)
    #   @yield the completion handler
    # @return [void]
    def handler
      if true
        if (block_given?)
          return @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? @j_arg_T.wrap(ar.result) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? @j_arg_T.wrap(ar.result) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handler()"
      end
    end
    # @overload isFailed()
    # @return [true,false] true if the this completion is completed and failed
    def failed?
      if !block_given?
        return @j_del.java_method(:isFailed, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling failed?()"
      end
    end
    #  Completes the future upon completion, otherwise fails it.
    # @overload resolve(future)
    #   @param [::Vertx::Promise] future the future to resolve
    # @return [void]
    def resolve(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:resolve, [Java::IoVertxCore::Promise.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resolve(#{args[0]})"
      end
    end
    #  Cause the current thread to wait until this completion completes and succeeds with a configurable timeout.<p/>
    # 
    #  If completion times out or the current thread is interrupted or the suite fails, an exception will be thrown.
    # @overload awaitSuccess()
    # @overload awaitSuccess(timeoutMillis)
    #   @param [Fixnum] timeoutMillis the timeout in milliseconds
    # @return [void]
    def await_success(*args)
      if !block_given? && args[0] == nil
        return @j_del.java_method(:awaitSuccess, []).call()
      elsif args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:awaitSuccess, [Java::long.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling await_success(#{args[0]})"
      end
    end
    #  Cause the current thread to wait until this completion completes with a configurable timeout.<p/>
    # 
    #  If completion times out or the current thread is interrupted, an exception will be thrown.
    # @overload await()
    # @overload await(timeoutMillis)
    #   @param [Fixnum] timeoutMillis the timeout in milliseconds
    # @return [void]
    def await(*args)
      if !block_given? && args[0] == nil
        return @j_del.java_method(:await, []).call()
      elsif args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:await, [Java::long.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling await(#{args[0]})"
      end
    end
    # @overload isSucceeded()
    # @return [true,false] true if this completion is completed and succeeded
    def succeeded?
      if !block_given?
        return @j_del.java_method(:isSucceeded, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling succeeded?()"
      end
    end
    # @overload isCompleted()
    # @return [true,false] true if this completion is completed
    def completed?
      if !block_given?
        return @j_del.java_method(:isCompleted, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling completed?()"
      end
    end
  end
end
