require 'vertx-unit/async'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.unit.TestContext
module VertxUnit
  #  The test context is used for performing test assertions and manage the completion of the test. This context
  #  is provided by <i>vertx-unit</i> as argument of the test case.
  class TestContext
    # @private
    # @param j_del [::VertxUnit::TestContext] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxUnit::TestContext] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == TestContext
    end
    def @@j_api_type.wrap(obj)
      TestContext.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtUnit::TestContext.java_class
    end
    #  Asserts that the <code>expected</code> double argument is equals to the <code>actual</code> double argument
    #  within a positive delta. If the arguments do not satisfy this, an assertion error is thrown otherwise
    #  the execution continue.
    # @overload assertInRange(expected,actual,delta)
    #   @param [Float] expected the object the actual object is supposedly equals to
    #   @param [Float] actual the actual object to test
    #   @param [Float] delta the maximum delta
    # @overload assertInRange(expected,actual,delta,message)
    #   @param [Float] expected the object the actual object is supposedly equals to
    #   @param [Float] actual the actual object to test
    #   @param [Float] delta the maximum delta
    #   @param [String] message the failure message
    # @return [self]
    def assert_in_range(*args)
      if args[0].class == Float && args[1].class == Float && args[2].class == Float && !block_given? && args[3] == nil
        @j_del.java_method(:assertInRange, [Java::double.java_class,Java::double.java_class,Java::double.java_class]).call(::Vertx::Util::Utils.to_double(args[0]),::Vertx::Util::Utils.to_double(args[1]),::Vertx::Util::Utils.to_double(args[2]))
        return self
      elsif args[0].class == Float && args[1].class == Float && args[2].class == Float && args[3].class == String && !block_given?
        @j_del.java_method(:assertInRange, [Java::double.java_class,Java::double.java_class,Java::double.java_class,Java::java.lang.String.java_class]).call(::Vertx::Util::Utils.to_double(args[0]),::Vertx::Util::Utils.to_double(args[1]),::Vertx::Util::Utils.to_double(args[2]),args[3])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling assert_in_range(#{args[0]},#{args[1]},#{args[2]},#{args[3]})"
      end
    end
    #  Assert the specified <code>condition</code> is <code>false</code>. If the condition is <code>true</code>, an assertion error is thrown
    #  otherwise the execution continue.
    # @overload assertFalse(condition)
    #   @param [true,false] condition the condition to assert
    # @overload assertFalse(condition,message)
    #   @param [true,false] condition the condition to assert
    #   @param [String] message the failure message
    # @return [self]
    def assert_false(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given? && args[1] == nil
        @j_del.java_method(:assertFalse, [Java::boolean.java_class]).call(args[0])
        return self
      elsif (args[0].class == TrueClass || args[0].class == FalseClass) && args[1].class == String && !block_given?
        @j_del.java_method(:assertFalse, [Java::boolean.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling assert_false(#{args[0]},#{args[1]})"
      end
    end
    #  Creates and returns a new async handler, the returned handler controls the completion of the test.<p/>
    # 
    #  When the returned handler is called back with a succeeded result it invokes the <code>resultHandler</code> argument
    #  with the async result. The test completes after the result handler is invoked and does not fails.<p/>
    # 
    #  When the returned handler is called back with a failed result it fails the test with the cause of the failure.<p/>
    # 
    #  Note that the result handler can create other async objects during its invocation that would postpone
    #  the completion of the test case until those objects are resolved.
    # @overload asyncAssertSuccess()
    # @overload asyncAssertSuccess(resultHandler)
    #   @yield the result handler
    # @return [Proc] the async result handler
    def async_assert_success
      if !block_given?
        return ::Vertx::Util::Utils.to_async_result_handler_proc(@j_del.java_method(:asyncAssertSuccess, []).call()) { |val| ::Vertx::Util::Utils.to_object(val) }
      elsif true
        return ::Vertx::Util::Utils.to_async_result_handler_proc(@j_del.java_method(:asyncAssertSuccess, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_object(event)) unless !block_given? }))) { |val| ::Vertx::Util::Utils.to_object(val) }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling async_assert_success()"
      end
    end
    #  Assert the <code>expected</code> argument is equals to the <code>actual</code> argument. If the arguments are not equals
    #  an assertion error is thrown otherwise the execution continue.
    # @overload assertEquals(expected,actual)
    #   @param [Object] expected the object the actual object is supposedly equals to
    #   @param [Object] actual the actual object to test
    # @overload assertEquals(expected,actual,message)
    #   @param [Object] expected the object the actual object is supposedly equals to
    #   @param [Object] actual the actual object to test
    #   @param [String] message the failure message
    # @return [self]
    def assert_equals(*args)
      if ::Vertx::Util::unknown_type.accept?(args[0]) && ::Vertx::Util::unknown_type.accept?(args[1]) && !block_given? && args[2] == nil
        @j_del.java_method(:assertEquals, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(args[0]),::Vertx::Util::Utils.to_object(args[1]))
        return self
      elsif ::Vertx::Util::unknown_type.accept?(args[0]) && ::Vertx::Util::unknown_type.accept?(args[1]) && args[2].class == String && !block_given?
        @j_del.java_method(:assertEquals, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.String.java_class]).call(::Vertx::Util::Utils.to_object(args[0]),::Vertx::Util::Utils.to_object(args[1]),args[2])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling assert_equals(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Create and returns a new async object, the returned async controls the completion of the test.
    #  This async operation completes when the {::VertxUnit::Async#count_down} is called <code>count</code> times.<p/>
    #  If {::VertxUnit::Async#count_down} is called more than <code>count</code> times, an IllegalStateException is thrown.<p/>
    # 
    #  The test case will complete when all the async objects have their {::VertxUnit::Async#complete}
    #  method called at least once.<p/>
    # 
    #  This method shall be used for creating asynchronous exit points for the executed test.<p/>
    # @overload strictAsync(count)
    #   @param [Fixnum] count 
    # @return [::VertxUnit::Async] the async instance
    def strict_async(*args)
      if args[0].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:strictAsync, [Java::int.java_class]).call(args[0]),::VertxUnit::Async)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling strict_async(#{args[0]})"
      end
    end
    #  Remove some data from the context.
    # @overload remove(key)
    #   @param [String] key the key to remove
    # @return [Object] the removed object when it exists
    def remove(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:remove, [Java::java.lang.String.java_class]).call(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remove(#{args[0]})"
      end
    end
    #  Put some data in the context.
    #  <p>
    #  This can be used to share data between different tests and before/after phases.
    # @overload put(key,value)
    #   @param [String] key the key of the data
    #   @param [Object] value the data
    # @return [Object] the previous object when it exists
    def put(*args)
      if args[0].class == String && ::Vertx::Util::unknown_type.accept?(args[1]) && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:put, [Java::java.lang.String.java_class,Java::java.lang.Object.java_class]).call(args[0],::Vertx::Util::Utils.to_object(args[1])))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling put(#{args[0]},#{args[1]})"
      end
    end
    #  Create and returns a new async object, the returned async controls the completion of the test. This async operation
    #  completes when the {::VertxUnit::Async#count_down} is called <code>count</code> times.<p/>
    # 
    #  The test case will complete when all the async objects have their {::VertxUnit::Async#complete}
    #  method called at least once.<p/>
    # 
    #  This method shall be used for creating asynchronous exit points for the executed test.<p/>
    # @overload async()
    # @overload async(count)
    #   @param [Fixnum] count 
    # @return [::VertxUnit::Async] the async instance
    def async(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:async, []).call(),::VertxUnit::Async)
      elsif args[0].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:async, [Java::int.java_class]).call(args[0]),::VertxUnit::Async)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling async(#{args[0]})"
      end
    end
    #  Throw a failure with the specified failure <code>cause</code>.
    # @overload fail()
    # @overload fail(message)
    #   @param [String] message the failure message
    # @overload fail(cause)
    #   @param [Exception] cause the failure cause
    # @return [void]
    def fail(*args)
      if !block_given? && args[0] == nil
        return @j_del.java_method(:fail, []).call()
      elsif args[0].class == String && !block_given?
        return @j_del.java_method(:fail, [Java::java.lang.String.java_class]).call(args[0])
      elsif args[0].is_a?(Exception) && !block_given?
        return @j_del.java_method(:fail, [Java::JavaLang::Throwable.java_class]).call(::Vertx::Util::Utils.to_throwable(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling fail(#{args[0]})"
      end
    end
    #  Assert the <code>expected</code> argument is <code>null</code>. If the argument is not, an assertion error is thrown
    #  otherwise the execution continue.
    # @overload assertNull(expected)
    #   @param [Object] expected the argument being asserted to be null
    # @overload assertNull(expected,message)
    #   @param [Object] expected the argument being asserted to be null
    #   @param [String] message the failure message
    # @return [self]
    def assert_null(*args)
      if ::Vertx::Util::unknown_type.accept?(args[0]) && !block_given? && args[1] == nil
        @j_del.java_method(:assertNull, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(args[0]))
        return self
      elsif ::Vertx::Util::unknown_type.accept?(args[0]) && args[1].class == String && !block_given?
        @j_del.java_method(:assertNull, [Java::java.lang.Object.java_class,Java::java.lang.String.java_class]).call(::Vertx::Util::Utils.to_object(args[0]),args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling assert_null(#{args[0]},#{args[1]})"
      end
    end
    #  Assert the specified <code>condition</code> is <code>true</code>. If the condition is <code>false</code>, an assertion error is thrown
    #  otherwise the execution continue.
    # @overload assertTrue(condition)
    #   @param [true,false] condition the condition to assert
    # @overload assertTrue(condition,message)
    #   @param [true,false] condition the condition to assert
    #   @param [String] message the failure message
    # @return [self]
    def assert_true(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given? && args[1] == nil
        @j_del.java_method(:assertTrue, [Java::boolean.java_class]).call(args[0])
        return self
      elsif (args[0].class == TrueClass || args[0].class == FalseClass) && args[1].class == String && !block_given?
        @j_del.java_method(:assertTrue, [Java::boolean.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling assert_true(#{args[0]},#{args[1]})"
      end
    end
    #  Assert the <code>expected</code> argument is not <code>null</code>. If the argument is <code>null</code>, an assertion error is thrown
    #  otherwise the execution continue.
    # @overload assertNotNull(expected)
    #   @param [Object] expected the argument being asserted to be not null
    # @overload assertNotNull(expected,message)
    #   @param [Object] expected the argument being asserted to be not null
    #   @param [String] message the failure message
    # @return [self]
    def assert_not_null(*args)
      if ::Vertx::Util::unknown_type.accept?(args[0]) && !block_given? && args[1] == nil
        @j_del.java_method(:assertNotNull, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(args[0]))
        return self
      elsif ::Vertx::Util::unknown_type.accept?(args[0]) && args[1].class == String && !block_given?
        @j_del.java_method(:assertNotNull, [Java::java.lang.Object.java_class,Java::java.lang.String.java_class]).call(::Vertx::Util::Utils.to_object(args[0]),args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling assert_not_null(#{args[0]},#{args[1]})"
      end
    end
    #  Get some data from the context.
    # @overload get(key)
    #   @param [String] key the key of the data
    # @return [Object] the data
    def get(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:get, [Java::java.lang.String.java_class]).call(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get(#{args[0]})"
      end
    end
    #  Execute the provided handler, which may contain assertions, possibly from any third-party assertion framework.
    #  Any AssertionError thrown will be caught (and propagated) in order to fulfill potential expected async
    #  completeness.
    # @overload verify(block)
    #   @yield block of code to be executed
    # @return [self]
    def verify
      if true
        @j_del.java_method(:verify, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling verify()"
      end
    end
    #  Creates and returns a new async handler, the returned handler controls the completion of the test.<p/>
    # 
    #  When the returned handler is called back with a failed result it completes the async operation.<p/>
    # 
    #  When the returned handler is called back with a succeeded result it fails the test.<p/>
    # @overload asyncAssertFailure()
    # @overload asyncAssertFailure(causeHandler)
    #   @yield the cause handler
    # @return [Proc] the async result handler
    def async_assert_failure
      if !block_given?
        return ::Vertx::Util::Utils.to_async_result_handler_proc(@j_del.java_method(:asyncAssertFailure, []).call()) { |val| ::Vertx::Util::Utils.to_object(val) }
      elsif true
        return ::Vertx::Util::Utils.to_async_result_handler_proc(@j_del.java_method(:asyncAssertFailure, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))) { |val| ::Vertx::Util::Utils.to_object(val) }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling async_assert_failure()"
      end
    end
    # @overload exceptionHandler()
    # @return [Proc] an exception handler that will fail this context
    def exception_handler
      if !block_given?
        return ::Vertx::Util::Utils.to_handler_proc(@j_del.java_method(:exceptionHandler, []).call()) { |val| ::Vertx::Util::Utils.to_throwable(val) }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exception_handler()"
      end
    end
    #  Assert the <code>first</code> argument is not equals to the <code>second</code> argument. If the arguments are equals
    #  an assertion error is thrown otherwise the execution continue.
    # @overload assertNotEquals(first,second)
    #   @param [Object] first the first object to test
    #   @param [Object] second the second object to test
    # @overload assertNotEquals(first,second,message)
    #   @param [Object] first the first object to test
    #   @param [Object] second the second object to test
    #   @param [String] message the failure message
    # @return [self]
    def assert_not_equals(*args)
      if ::Vertx::Util::unknown_type.accept?(args[0]) && ::Vertx::Util::unknown_type.accept?(args[1]) && !block_given? && args[2] == nil
        @j_del.java_method(:assertNotEquals, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(args[0]),::Vertx::Util::Utils.to_object(args[1]))
        return self
      elsif ::Vertx::Util::unknown_type.accept?(args[0]) && ::Vertx::Util::unknown_type.accept?(args[1]) && args[2].class == String && !block_given?
        @j_del.java_method(:assertNotEquals, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.String.java_class]).call(::Vertx::Util::Utils.to_object(args[0]),::Vertx::Util::Utils.to_object(args[1]),args[2])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling assert_not_equals(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
  end
end
