require 'vertx-web-client/response_predicate'
require 'vertx-web-common/multipart_form'
require 'vertx-web-client/http_response'
require 'vertx/buffer'
require 'vertx-web-common/body_codec'
require 'vertx/multi_map'
require 'vertx/read_stream'
require 'vertx-web-client/response_predicate_result'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.client.HttpRequest
module VertxWebClient
  #  A client-side HTTP request.
  #  <p>
  #  Instances are created by an {::VertxWebClient::WebClient} instance, via one of the methods corresponding to the specific
  #  HTTP methods such as {::VertxWebClient::WebClient#get}, etc...
  #  <p>
  #  The request shall be configured prior sending, the request is immutable and when a mutator method
  #  is called, a new request is returned allowing to expose the request in a public API and apply further customization.
  #  <p>
  #  After the request has been configured, the methods
  #  <ul>
  #    <li>{::VertxWebClient::HttpRequest#send}</li>
  #    <li>{::VertxWebClient::HttpRequest#send_stream}</li>
  #    <li> ()}</li>
  #    <li>{::VertxWebClient::HttpRequest#send_form}</li>
  #  </ul>
  #  can be called.
  #  The <code>sendXXX</code> methods perform the actual request, they can be called multiple times to perform the same HTTP
  #  request at different points in time.
  #  <p>
  #  The handler is called back with
  #  <ul>
  #    <li>an {::VertxWebClient::HttpResponse} instance when the HTTP response has been received</li>
  #    <li>a failure when the HTTP request failed (like a connection error) or when the HTTP response could
  #    not be obtained (like connection or unmarshalling errors)</li>
  #  </ul>
  #  <p>
  #  Most of the time, this client will buffer the HTTP response fully unless a specific  is used
  #  such as .
  class HttpRequest
    # @private
    # @param j_del [::VertxWebClient::HttpRequest] the java delegate
    def initialize(j_del, j_arg_T=nil)
      @j_del = j_del
      @j_arg_T = j_arg_T != nil ? j_arg_T : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::VertxWebClient::HttpRequest] the underlying java delegate
    def j_del
      @j_del
    end
    #  Like {::VertxWebClient::HttpRequest#send} but with an HTTP request <code>body</code> stream.
    # @overload sendStream(body,handler)
    #   @param [::Vertx::ReadStream] body the body
    #   @yield 
    # @return [void]
    def send_stream(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:sendStream, [Java::IoVertxCoreStreams::ReadStream.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxWebClient::HttpResponse, nil) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:sendStream, [Java::IoVertxCoreStreams::ReadStream.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxWebClient::HttpResponse, nil) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxWebClient::HttpResponse.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling send_stream(#{args[0]})"
      end
    end
    #  Like {::VertxWebClient::HttpRequest#send} but with an HTTP request <code>body</code> object encoded as json and the content type
    #  set to <code>application/json</code>.
    # @overload sendJsonObject(body,handler)
    #   @param [Hash{String => Object}] body the body
    #   @yield 
    # @return [void]
    def send_json_object(*args)
      if args[0].class == Hash && true
        if (block_given?)
          return @j_del.java_method(:sendJsonObject, [Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxWebClient::HttpResponse, nil) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:sendJsonObject, [Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxWebClient::HttpResponse, nil) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxWebClient::HttpResponse.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling send_json_object(#{args[0]})"
      end
    end
    #  Allow or disallow multipart mixed encoding when sending  having files sharing the same
    #  file name.
    #  <br/>
    #  The default value is <code>true</code>.
    #  <br/>
    #  Set to <code>false</code> if you want to achieve the behavior for <a href="http://www.w3.org/TR/html5/forms.html#multipart-form-data">HTML5</a>.
    # @overload multipartMixed(allow)
    #   @param [true,false] allow <code>true</code> allows use of multipart mixed encoding
    # @return [::VertxWebClient::HttpRequest] a reference to this, so the API can be used fluently
    def multipart_mixed(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:multipartMixed, [Java::boolean.java_class]).call(args[0]),::VertxWebClient::HttpRequest, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling multipart_mixed(#{args[0]})"
      end
    end
    #  Return the current query parameters.
    # @overload queryParams()
    # @return [::Vertx::MultiMap] the current query parameters
    def query_params
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:queryParams, []).call(),::Vertx::MultiMap)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling query_params()"
      end
    end
    #  Like {::VertxWebClient::HttpRequest#send} but with an HTTP request <code>body</code> object encoded as json and the content type
    #  set to <code>application/json</code>.
    # @overload sendJson(body,handler)
    #   @param [Object] body the body
    #   @yield 
    # @return [void]
    def send_json(*args)
      if ::Vertx::Util::unknown_type.accept?(args[0]) && true
        if (block_given?)
          return @j_del.java_method(:sendJson, [Java::java.lang.Object.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_object(args[0]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxWebClient::HttpResponse, nil) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:sendJson, [Java::java.lang.Object.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_object(args[0]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxWebClient::HttpResponse, nil) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxWebClient::HttpResponse.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling send_json(#{args[0]})"
      end
    end
    #  Like {::VertxWebClient::HttpRequest#send} but with an HTTP request <code>body</code> buffer.
    # @overload sendBuffer(body,handler)
    #   @param [::Vertx::Buffer] body the body
    #   @yield 
    # @return [void]
    def send_buffer(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:sendBuffer, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxWebClient::HttpResponse, nil) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:sendBuffer, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxWebClient::HttpResponse, nil) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxWebClient::HttpResponse.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling send_buffer(#{args[0]})"
      end
    end
    #  Configure the request to use a virtual host <code>value</code>.
    #  <p/>
    #  Usually the header <i>host</i> (<i>:authority</i> pseudo header for HTTP/2) is set from the request host value
    #  since this host value resolves to the server IP address.
    #  <p/>
    #  Sometimes you need to set a host header for an address that does not resolve to the server IP address.
    #  The virtual host value overrides the value of the actual <i>host</i> header (<i>:authority</i> pseudo header
    #  for HTTP/2).
    #  <p/>
    #  The virtual host is also be used for SNI.
    # @overload virtualHost(value)
    #   @param [String] value 
    # @return [self]
    def virtual_host(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:virtualHost, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling virtual_host(#{args[0]})"
      end
    end
    # @overload ssl(value)
    #   @param [true,false] value 
    # @return [self]
    def ssl(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        @j_del.java_method(:ssl, [Java::JavaLang::Boolean.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling ssl(#{args[0]})"
      end
    end
    #  Configures the amount of time in milliseconds after which if the request does not return any data within the timeout
    #  period an TimeoutException fails the request.
    #  <p>
    #  Setting zero or a negative <code>value</code> disables the timeout.
    # @overload timeout(value)
    #   @param [Fixnum] value The quantity of time in milliseconds.
    # @return [self]
    def timeout(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:timeout, [Java::long.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling timeout(#{args[0]})"
      end
    end
    #  Configure the request to use a custom HTTP method
    # @overload rawMethod(method)
    #   @param [String] method 
    # @return [self]
    def raw_method(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:rawMethod, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling raw_method(#{args[0]})"
      end
    end
    #  Set wether or not to follow the directs for the request.
    # @overload followRedirects(value)
    #   @param [true,false] value true if redirections should be followed
    # @return [self]
    def follow_redirects(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        @j_del.java_method(:followRedirects, [Java::boolean.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling follow_redirects(#{args[0]})"
      end
    end
    #  Configure the request to use a new host <code>value</code>.
    # @overload host(value)
    #   @param [String] value 
    # @return [self]
    def host(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:host, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling host(#{args[0]})"
      end
    end
    #  Copy this request
    # @overload copy()
    # @return [::VertxWebClient::HttpRequest] a copy of this request
    def copy
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:copy, []).call(),::VertxWebClient::HttpRequest, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling copy()"
      end
    end
    # @overload headers()
    # @return [::Vertx::MultiMap] The HTTP headers
    def headers
      if !block_given?
        if @cached_headers != nil
          return @cached_headers
        end
        return @cached_headers = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:headers, []).call(),::Vertx::MultiMap)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling headers()"
      end
    end
    #  Set a query parameter to the request.
    # @overload setQueryParam(paramName,paramValue)
    #   @param [String] paramName the param name
    #   @param [String] paramValue the param value
    # @return [self]
    def set_query_param(*args)
      if args[0].class == String && args[1].class == String && !block_given?
        @j_del.java_method(:setQueryParam, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_query_param(#{args[0]},#{args[1]})"
      end
    end
    #  Configure the request to use a new method <code>value</code>.
    # @overload method(value)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] value 
    # @return [self]
    def method(*args)
      if args[0].class == Symbol && !block_given?
        @j_del.java_method(:method, [Java::IoVertxCoreHttp::HttpMethod.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling method(#{args[0]})"
      end
    end
    #  Configure the request to add multiple HTTP headers .
    # @overload putHeaders(headers)
    #   @param [::Vertx::MultiMap] headers The HTTP headers
    # @return [self]
    def put_headers(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:putHeaders, [Java::IoVertxCore::MultiMap.java_class]).call(args[0].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling put_headers(#{args[0]})"
      end
    end
    #  Like {::VertxWebClient::HttpRequest#send} but with an HTTP request <code>body</code> multimap encoded as form and the content type
    #  set to <code>multipart/form-data</code>. You may use this method to send attributes and upload files.
    # @overload sendMultipartForm(body,handler)
    #   @param [::VertxWebCommon::MultipartForm] body the body
    #   @yield 
    # @return [void]
    def send_multipart_form(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:sendMultipartForm, [Java::IoVertxExtWebMultipart::MultipartForm.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxWebClient::HttpResponse, nil) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:sendMultipartForm, [Java::IoVertxExtWebMultipart::MultipartForm.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxWebClient::HttpResponse, nil) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxWebClient::HttpResponse.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling send_multipart_form(#{args[0]})"
      end
    end
    #  Configure the request to perform basic access authentication.
    #  <p>
    #  In basic HTTP authentication, a request contains a header field of the form 'Authorization: Basic &#60;credentials&#62;',
    #  where credentials is the base64 encoding of id and password joined by a colon.
    #  </p>
    # @overload basicAuthentication(id,password)
    #   @param [String] id the id
    #   @param [String] password the password
    # @overload basicAuthentication(id,password)
    #   @param [::Vertx::Buffer] id the id
    #   @param [::Vertx::Buffer] password the password
    # @return [self]
    def basic_authentication(*args)
      if args[0].class == String && args[1].class == String && !block_given?
        @j_del.java_method(:basicAuthentication, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
        return self
      elsif args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:basicAuthentication, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCoreBuffer::Buffer.java_class]).call(args[0].j_del,args[1].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling basic_authentication(#{args[0]},#{args[1]})"
      end
    end
    #  Configure the request to use a new request URI <code>value</code>.
    #  <p>
    #  When the uri has query parameters, they are set in the {::VertxWebClient::HttpRequest#query_params} multimap, overwritting
    #  any parameters previously set.
    # @overload uri(value)
    #   @param [String] value 
    # @return [self]
    def uri(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:uri, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling uri(#{args[0]})"
      end
    end
    #  Add an expectation that the response is valid according to the provided <code>predicate</code>.
    #  <p>
    #  Multiple predicates can be added.
    # @overload expect(predicate)
    #   @yield the predicate
    # @overload expect(predicate)
    #   @param [::VertxWebClient::ResponsePredicate] predicate the predicate
    # @return [self]
    def expect(*args)
      if block_given? && args[0] == nil
        @j_del.java_method(:expect, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWebClient::HttpResponse, nil)).j_del unless !block_given? }))
        return self
      elsif args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:expect, [Java::IoVertxExtWebClientPredicate::ResponsePredicate.java_class]).call(args[0].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling expect(#{args[0]})"
      end
    end
    #  Configure the request to decode the response with the <code>responseCodec</code>.
    # @overload as(responseCodec)
    #   @param [::VertxWebCommon::BodyCodec] responseCodec the response codec
    # @return [::VertxWebClient::HttpRequest] a reference to this, so the API can be used fluently
    def as(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:as, [Java::IoVertxExtWebCodec::BodyCodec.java_class]).call(args[0].j_del),::VertxWebClient::HttpRequest, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling as(#{args[0]})"
      end
    end
    #  Configure the request to use a new port <code>value</code>.
    # @overload port(value)
    #   @param [Fixnum] value 
    # @return [self]
    def port(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:port, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling port(#{args[0]})"
      end
    end
    #  Add a query parameter to the request.
    # @overload addQueryParam(paramName,paramValue)
    #   @param [String] paramName the param name
    #   @param [String] paramValue the param value
    # @return [self]
    def add_query_param(*args)
      if args[0].class == String && args[1].class == String && !block_given?
        @j_del.java_method(:addQueryParam, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_query_param(#{args[0]},#{args[1]})"
      end
    end
    #  Like {::VertxWebClient::HttpRequest#send} but with an HTTP request <code>body</code> multimap encoded as form and the content type
    #  set to <code>application/x-www-form-urlencoded</code>.
    #  <p>
    #  When the content type header is previously set to <code>multipart/form-data</code> it will be used instead.
    # @overload sendForm(body,handler)
    #   @param [::Vertx::MultiMap] body the body
    #   @yield 
    # @return [void]
    def send_form(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:sendForm, [Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxWebClient::HttpResponse, nil) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:sendForm, [Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxWebClient::HttpResponse, nil) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxWebClient::HttpResponse.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling send_form(#{args[0]})"
      end
    end
    #  Configure the request to perform bearer token authentication.
    #  <p>
    #  In OAuth 2.0, a request contains a header field of the form 'Authorization: Bearer &#60;bearerToken&#62;',
    #  where bearerToken is the bearer token issued by an authorization server to access protected resources.
    #  </p>
    # @overload bearerTokenAuthentication(bearerToken)
    #   @param [String] bearerToken the bearer token
    # @return [self]
    def bearer_token_authentication(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:bearerTokenAuthentication, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling bearer_token_authentication(#{args[0]})"
      end
    end
    #  Configure the request to set a new HTTP header.
    # @overload putHeader(name,value)
    #   @param [String] name the header name
    #   @param [String] value the header value
    # @return [self]
    def put_header(*args)
      if args[0].class == String && args[1].class == String && !block_given?
        @j_del.java_method(:putHeader, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling put_header(#{args[0]},#{args[1]})"
      end
    end
    #  Send a request, the <code>handler</code> will receive the response as an {::VertxWebClient::HttpResponse}.
    # @overload send(handler)
    #   @yield 
    # @return [void]
    def send
      if true
        if (block_given?)
          return @j_del.java_method(:send, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxWebClient::HttpResponse, nil) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:send, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxWebClient::HttpResponse, nil) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxWebClient::HttpResponse.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling send()"
      end
    end
  end
end
