require 'vertx/buffer'
require 'vertx/vertx'
require 'vertx/http_client'
require 'vertx-web-client/http_request'
require 'vertx/socket_address'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.client.WebClient
module VertxWebClient
  #  An asynchronous HTTP / HTTP/2 client called <code>WebClient</code>.
  #  <p>
  #  The web client makes easy to do HTTP request/response interactions with a web server, and provides advanced
  #  features like:
  #  <ul>
  #    <li>Json body encoding / decoding</li>
  #    <li>request/response pumping</li>
  #    <li>error handling</li>
  #  </ul>
  #  <p>
  #  The web client does not deprecate the , it is actually based on it and therefore inherits
  #  its configuration and great features like pooling. The <code>HttpClient</code> should be used when fine grained control over the HTTP
  #  requests/response is necessary.
  class WebClient
    # @private
    # @param j_del [::VertxWebClient::WebClient] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWebClient::WebClient] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == WebClient
    end
    def @@j_api_type.wrap(obj)
      WebClient.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebClient::WebClient.java_class
    end
    #  Like {::VertxWebClient::WebClient#request} using the <code>serverAddress</code> parameter to connect to the
    #  server instead of the <code>port</code> and <code>host</code> parameters.
    #  <p>
    #  The request host header will still be created from the <code>port</code> and <code>host</code> parameters.
    #  <p>
    #  Use  to connect to a unix domain socket server.
    # @overload request(method,requestURI)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method
    #   @param [String] requestURI the relative URI
    # @overload request(method,options)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method
    #   @param [Hash{String => Object}] options the request options
    # @overload request(method,host,requestURI)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload request(method,serverAddress,requestURI)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method 
    #   @param [::Vertx::SocketAddress] serverAddress 
    #   @param [String] requestURI 
    # @overload request(method,serverAddress,options)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method 
    #   @param [::Vertx::SocketAddress] serverAddress 
    #   @param [Hash{String => Object}] options 
    # @overload request(method,port,host,requestURI)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload request(method,serverAddress,host,requestURI)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method 
    #   @param [::Vertx::SocketAddress] serverAddress 
    #   @param [String] host 
    #   @param [String] requestURI 
    # @overload request(method,serverAddress,port,host,requestURI)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method 
    #   @param [::Vertx::SocketAddress] serverAddress 
    #   @param [Fixnum] port 
    #   @param [String] host 
    #   @param [String] requestURI 
    # @return [::VertxWebClient::HttpRequest]
    def request(*args)
      if args[0].class == Symbol && args[1].class == String && !block_given? && args[2] == nil && args[3] == nil && args[4] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::java.lang.String.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      elsif args[0].class == Symbol && args[1].class == Hash && !block_given? && args[2] == nil && args[3] == nil && args[4] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::IoVertxCoreHttp::RequestOptions.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      elsif args[0].class == Symbol && args[1].class == String && args[2].class == String && !block_given? && args[3] == nil && args[4] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1],args[2]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      elsif args[0].class == Symbol && args[1].class.method_defined?(:j_del) && args[2].class == String && !block_given? && args[3] == nil && args[4] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::IoVertxCoreNet::SocketAddress.java_class,Java::java.lang.String.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1].j_del,args[2]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      elsif args[0].class == Symbol && args[1].class.method_defined?(:j_del) && args[2].class == Hash && !block_given? && args[3] == nil && args[4] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::IoVertxCoreNet::SocketAddress.java_class,Java::IoVertxCoreHttp::RequestOptions.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1].j_del,Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(args[2]))),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      elsif args[0].class == Symbol && args[1].class == Fixnum && args[2].class == String && args[3].class == String && !block_given? && args[4] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1],args[2],args[3]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      elsif args[0].class == Symbol && args[1].class.method_defined?(:j_del) && args[2].class == String && args[3].class == String && !block_given? && args[4] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::IoVertxCoreNet::SocketAddress.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1].j_del,args[2],args[3]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      elsif args[0].class == Symbol && args[1].class.method_defined?(:j_del) && args[2].class == Fixnum && args[3].class == String && args[4].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::IoVertxCoreNet::SocketAddress.java_class,Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1].j_del,args[2],args[3],args[4]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling request(#{args[0]},#{args[1]},#{args[2]},#{args[3]},#{args[4]})"
      end
    end
    #  Create an HTTP PUT request to send to the server using an absolute URI, specifying a response handler to receive
    #  the response
    # @overload putAbs(absoluteURI)
    #   @param [String] absoluteURI the absolute URI
    # @return [::VertxWebClient::HttpRequest] an HTTP client request object
    def put_abs(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:putAbs, [Java::java.lang.String.java_class]).call(args[0]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling put_abs(#{args[0]})"
      end
    end
    #  Create a request with a custom HTTP method to send to the server at the specified host and port.
    # @overload raw(customHttpMethod,requestURI)
    #   @param [String] customHttpMethod custom HTTP Method
    #   @param [String] requestURI the relative URI
    # @overload raw(customHttpMethod,host,requestURI)
    #   @param [String] customHttpMethod custom HTTP Method
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload raw(customHttpMethod,port,host,requestURI)
    #   @param [String] customHttpMethod custom HTTP Method
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @return [::VertxWebClient::HttpRequest] an HTTP client request object
    def raw(*args)
      if args[0].class == String && args[1].class == String && !block_given? && args[2] == nil && args[3] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:raw, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      elsif args[0].class == String && args[1].class == String && args[2].class == String && !block_given? && args[3] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:raw, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      elsif args[0].class == String && args[1].class == Fixnum && args[2].class == String && args[3].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:raw, [Java::java.lang.String.java_class,Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2],args[3]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling raw(#{args[0]},#{args[1]},#{args[2]},#{args[3]})"
      end
    end
    #  Create an HTTP DELETE request to send to the server at the specified host and port.
    # @overload delete(requestURI)
    #   @param [String] requestURI the relative URI
    # @overload delete(host,requestURI)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload delete(port,host,requestURI)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @return [::VertxWebClient::HttpRequest] an HTTP client request object
    def delete(*args)
      if args[0].class == String && !block_given? && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:delete, [Java::java.lang.String.java_class]).call(args[0]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      elsif args[0].class == String && args[1].class == String && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:delete, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      elsif args[0].class == Fixnum && args[1].class == String && args[2].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:delete, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling delete(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Create an HTTP PUT request to send to the server at the specified host and port.
    # @overload put(requestURI)
    #   @param [String] requestURI the relative URI
    # @overload put(host,requestURI)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload put(port,host,requestURI)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @return [::VertxWebClient::HttpRequest] an HTTP client request object
    def put(*args)
      if args[0].class == String && !block_given? && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:put, [Java::java.lang.String.java_class]).call(args[0]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      elsif args[0].class == String && args[1].class == String && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:put, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      elsif args[0].class == Fixnum && args[1].class == String && args[2].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:put, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling put(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Create an HTTP HEAD request to send to the server at the specified host and port.
    # @overload head(requestURI)
    #   @param [String] requestURI the relative URI
    # @overload head(host,requestURI)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload head(port,host,requestURI)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @return [::VertxWebClient::HttpRequest] an HTTP client request object
    def head(*args)
      if args[0].class == String && !block_given? && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:head, [Java::java.lang.String.java_class]).call(args[0]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      elsif args[0].class == String && args[1].class == String && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:head, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      elsif args[0].class == Fixnum && args[1].class == String && args[2].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:head, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling head(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Create an HTTP PATCH request to send to the server at the specified host and port.
    # @overload patch(requestURI)
    #   @param [String] requestURI the relative URI
    # @overload patch(host,requestURI)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload patch(port,host,requestURI)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @return [::VertxWebClient::HttpRequest] an HTTP client request object
    def patch(*args)
      if args[0].class == String && !block_given? && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:patch, [Java::java.lang.String.java_class]).call(args[0]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      elsif args[0].class == String && args[1].class == String && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:patch, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      elsif args[0].class == Fixnum && args[1].class == String && args[2].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:patch, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling patch(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Create an HTTP HEAD request to send to the server using an absolute URI, specifying a response handler to receive
    #  the response
    # @overload headAbs(absoluteURI)
    #   @param [String] absoluteURI the absolute URI
    # @return [::VertxWebClient::HttpRequest] an HTTP client request object
    def head_abs(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:headAbs, [Java::java.lang.String.java_class]).call(args[0]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling head_abs(#{args[0]})"
      end
    end
    #  Create an HTTP POST request to send to the server at the specified host and port.
    # @overload post(requestURI)
    #   @param [String] requestURI the relative URI
    # @overload post(host,requestURI)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload post(port,host,requestURI)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @return [::VertxWebClient::HttpRequest] an HTTP client request object
    def post(*args)
      if args[0].class == String && !block_given? && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:post, [Java::java.lang.String.java_class]).call(args[0]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      elsif args[0].class == String && args[1].class == String && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:post, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      elsif args[0].class == Fixnum && args[1].class == String && args[2].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:post, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling post(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Create an HTTP GET request to send to the server using an absolute URI, specifying a response handler to receive
    #  the response
    # @overload getAbs(absoluteURI)
    #   @param [String] absoluteURI the absolute URI
    # @return [::VertxWebClient::HttpRequest] an HTTP client request object
    def get_abs(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getAbs, [Java::java.lang.String.java_class]).call(args[0]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_abs(#{args[0]})"
      end
    end
    #  Like {::VertxWebClient::WebClient#request_abs} using the <code>serverAddress</code> parameter to connect to the
    #  server instead of the <code>absoluteURI</code> parameter.
    #  <p>
    #  The request host header will still be created from the <code>absoluteURI</code> parameter.
    #  <p>
    #  Use  to connect to a unix domain socket server.
    # @overload requestAbs(method,absoluteURI)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method
    #   @param [String] absoluteURI the absolute URI
    # @overload requestAbs(method,serverAddress,absoluteURI)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method 
    #   @param [::Vertx::SocketAddress] serverAddress 
    #   @param [String] absoluteURI 
    # @return [::VertxWebClient::HttpRequest]
    def request_abs(*args)
      if args[0].class == Symbol && args[1].class == String && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:requestAbs, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::java.lang.String.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      elsif args[0].class == Symbol && args[1].class.method_defined?(:j_del) && args[2].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:requestAbs, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::IoVertxCoreNet::SocketAddress.java_class,Java::java.lang.String.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1].j_del,args[2]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling request_abs(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Create an HTTP GET request to send to the server at the specified host and port.
    # @overload get(requestURI)
    #   @param [String] requestURI the relative URI
    # @overload get(host,requestURI)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload get(port,host,requestURI)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @return [::VertxWebClient::HttpRequest] an HTTP client request object
    def get(*args)
      if args[0].class == String && !block_given? && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:get, [Java::java.lang.String.java_class]).call(args[0]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      elsif args[0].class == String && args[1].class == String && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:get, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      elsif args[0].class == Fixnum && args[1].class == String && args[2].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:get, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Create an HTTP DELETE request to send to the server using an absolute URI, specifying a response handler to receive
    #  the response
    # @overload deleteAbs(absoluteURI)
    #   @param [String] absoluteURI the absolute URI
    # @return [::VertxWebClient::HttpRequest] an HTTP client request object
    def delete_abs(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:deleteAbs, [Java::java.lang.String.java_class]).call(args[0]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling delete_abs(#{args[0]})"
      end
    end
    #  Create a web client using the provided <code>vertx</code> instance.
    # @overload create(vertx)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    # @overload create(vertx,options)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    #   @param [Hash{String => Object}] options the Web Client options
    # @return [::VertxWebClient::WebClient] the created web client
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClient::WebClient.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxWebClient::WebClient)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClient::WebClient.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtWebClient::WebClientOptions.java_class]).call(args[0].j_del,Java::IoVertxExtWebClient::WebClientOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxWebClient::WebClient)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  Create a request with a custom HTTP method  to send to the server using an absolute URI, specifying a response handler to receive
    #  the response
    # @overload rawAbs(customHttpMethod,absoluteURI)
    #   @param [String] customHttpMethod custom HTTP Method
    #   @param [String] absoluteURI the absolute URI
    # @return [::VertxWebClient::HttpRequest] an HTTP client request object
    def raw_abs(*args)
      if args[0].class == String && args[1].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:rawAbs, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling raw_abs(#{args[0]},#{args[1]})"
      end
    end
    #  Create an HTTP POST request to send to the server using an absolute URI, specifying a response handler to receive
    #  the response
    # @overload postAbs(absoluteURI)
    #   @param [String] absoluteURI the absolute URI
    # @return [::VertxWebClient::HttpRequest] an HTTP client request object
    def post_abs(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:postAbs, [Java::java.lang.String.java_class]).call(args[0]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling post_abs(#{args[0]})"
      end
    end
    #  Close the client. Closing will close down any pooled connections.
    #  Clients should always be closed after use.
    # @overload close()
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Wrap an <code>httpClient</code> with a web client and default options.
    #  <p>
    #  Only the specific web client portion of the <code>options</code> is used, the {Hash{String => Object}}
    #  of the <code>httpClient</code> is reused.
    # @overload wrap(httpClient)
    #   @param [::Vertx::HttpClient] httpClient the  to wrap
    # @overload wrap(httpClient,options)
    #   @param [::Vertx::HttpClient] httpClient the  to wrap
    #   @param [Hash{String => Object}] options the Web Client options
    # @return [::VertxWebClient::WebClient] the web client
    def self.wrap(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClient::WebClient.java_method(:wrap, [Java::IoVertxCoreHttp::HttpClient.java_class]).call(args[0].j_del),::VertxWebClient::WebClient)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClient::WebClient.java_method(:wrap, [Java::IoVertxCoreHttp::HttpClient.java_class,Java::IoVertxExtWebClient::WebClientOptions.java_class]).call(args[0].j_del,Java::IoVertxExtWebClient::WebClientOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxWebClient::WebClient)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling wrap(#{args[0]},#{args[1]})"
      end
    end
    #  Create an HTTP PATCH request to send to the server using an absolute URI, specifying a response handler to receive
    #  the response
    # @overload patchAbs(absoluteURI)
    #   @param [String] absoluteURI the absolute URI
    # @return [::VertxWebClient::HttpRequest] an HTTP client request object
    def patch_abs(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:patchAbs, [Java::java.lang.String.java_class]).call(args[0]),::VertxWebClient::HttpRequest,::Vertx::Buffer.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling patch_abs(#{args[0]})"
      end
    end
  end
end
