require 'vertx/server_web_socket'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.handler.graphql.ApolloWSMessage
module VertxWebGraphql
  #  A message recevied over Apollo's <code>subscriptions-transport-ws</code> transport.
  class ApolloWSMessage
    # @private
    # @param j_del [::VertxWebGraphql::ApolloWSMessage] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWebGraphql::ApolloWSMessage] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == ApolloWSMessage
    end
    def @@j_api_type.wrap(obj)
      ApolloWSMessage.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebHandlerGraphql::ApolloWSMessage.java_class
    end
    # @overload serverWebSocket()
    # @return [::Vertx::ServerWebSocket] the websocket that received the message
    def server_web_socket
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:serverWebSocket, []).call(),::Vertx::ServerWebSocket)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling server_web_socket()"
      end
    end
    # @overload type()
    # @return [:CONNECTION_INIT,:CONNECTION_TERMINATE,:START,:STOP,:CONNECTION_ACK,:CONNECTION_ERROR,:CONNECTION_KEEP_ALIVE,:DATA,:ERROR,:COMPLETE] the message type
    def type
      if !block_given?
        return @j_del.java_method(:type, []).call().name.intern
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling type()"
      end
    end
    # @overload content()
    # @return [Hash{String => Object}] the message content
    def content
      if !block_given?
        return @j_del.java_method(:content, []).call() != nil ? JSON.parse(@j_del.java_method(:content, []).call().encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling content()"
      end
    end
  end
end
