require 'vertx-auth-htdigest/htdigest_auth'
require 'vertx-web/auth_handler'
require 'vertx-auth-common/user'
require 'vertx/vertx'
require 'vertx-web/routing_context'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.handler.DigestAuthHandler
module VertxWeb
  #  An auth handler that provides HTTP Basic Authentication support.
  class DigestAuthHandler
    include ::VertxWeb::AuthHandler
    # @private
    # @param j_del [::VertxWeb::DigestAuthHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::DigestAuthHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == DigestAuthHandler
    end
    def @@j_api_type.wrap(obj)
      DigestAuthHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebHandler::DigestAuthHandler.java_class
    end
    #  Parses the credentials from the request into a JsonObject. The implementation should
    #  be able to extract the required info for the auth provider in the format the provider
    #  expects.
    # @overload parseCredentials(context,handler)
    #   @param [::VertxWeb::RoutingContext] context the routing context
    #   @yield the handler to be called once the information is available.
    # @return [void]
    def parse_credentials(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:parseCredentials, [Java::IoVertxExtWeb::RoutingContext.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:parseCredentials, [Java::IoVertxExtWeb::RoutingContext.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling parse_credentials(#{args[0]})"
      end
    end
    #  Add a set of required authorities for this auth handler
    # @overload addAuthorities(authorities)
    #   @param [Set<String>] authorities the set of authorities
    # @return [self]
    def add_authorities(*args)
      if args[0].class == Set && !block_given?
        @j_del.java_method(:addAuthorities, [Java::JavaUtil::Set.java_class]).call(Java::JavaUtil::LinkedHashSet.new(args[0].map { |element| element }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_authorities(#{args[0]})"
      end
    end
    #  Create a digest auth handler, specifying the expire timeout for nonces.
    # @overload create(vertx,authProvider)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    #   @param [::VertxAuthHtdigest::HtdigestAuth] authProvider the auth provider to use
    # @overload create(vertx,authProvider,nonceExpireTimeout)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    #   @param [::VertxAuthHtdigest::HtdigestAuth] authProvider the auth service to use
    #   @param [Fixnum] nonceExpireTimeout the nonce expire timeout in milliseconds.
    # @return [::VertxWeb::DigestAuthHandler] the auth handler
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::DigestAuthHandler.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtAuthHtdigest::HtdigestAuth.java_class]).call(args[0].j_del,args[1].j_del),::VertxWeb::DigestAuthHandler)
      elsif args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && args[2].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::DigestAuthHandler.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtAuthHtdigest::HtdigestAuth.java_class,Java::long.java_class]).call(args[0].j_del,args[1].j_del,args[2]),::VertxWeb::DigestAuthHandler)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Add a required authority for this auth handler
    # @overload addAuthority(authority)
    #   @param [String] authority the authority
    # @return [self]
    def add_authority(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:addAuthority, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_authority(#{args[0]})"
      end
    end
    #  Something has happened, so handle it.
    # @overload handle(event)
    #   @param [::VertxWeb::RoutingContext] event the event to handle
    # @return [void]
    def handle(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handle(#{args[0]})"
      end
    end
    #  Authorizes the given user against all added authorities.
    # @overload authorize(user,handler)
    #   @param [::VertxAuthCommon::User] user a user.
    #   @yield the handler for the result.
    # @return [void]
    def authorize(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:authorize, [Java::IoVertxExtAuth::User.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:authorize, [Java::IoVertxExtAuth::User.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling authorize(#{args[0]})"
      end
    end
    #  The default nonce expire timeout to use in milliseconds.
    def self.DEFAULT_NONCE_EXPIRE_TIMEOUT
      Java::IoVertxExtWebHandler::DigestAuthHandler.DEFAULT_NONCE_EXPIRE_TIMEOUT
    end
  end
end
