require 'vertx-web/routing_context'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.handler.MethodOverrideHandler
module VertxWeb
  class MethodOverrideHandler
    # @private
    # @param j_del [::VertxWeb::MethodOverrideHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::MethodOverrideHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MethodOverrideHandler
    end
    def @@j_api_type.wrap(obj)
      MethodOverrideHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebHandler::MethodOverrideHandler.java_class
    end
    #  Create a X-HTTP-METHOD-OVERRIDE handler
    # @overload create()
    # @overload create(useSafeDowngrade)
    #   @param [true,false] useSafeDowngrade if set to true, the method overriding will not happen if the overridden method is more idempotent or safer than the overriding method.
    # @return [::VertxWeb::MethodOverrideHandler] the X-HTTP-METHOD-OVERRIDE handler
    def self.create(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::MethodOverrideHandler.java_method(:create, []).call(),::VertxWeb::MethodOverrideHandler)
      elsif (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::MethodOverrideHandler.java_method(:create, [Java::boolean.java_class]).call(args[0]),::VertxWeb::MethodOverrideHandler)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]})"
      end
    end
    #  Something has happened, so handle it.
    # @overload handle(event)
    #   @param [::VertxWeb::RoutingContext] event the event to handle
    # @return [void]
    def handle(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handle(#{args[0]})"
      end
    end
  end
end
