require 'vertx-web/routing_context'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.handler.ResponseTimeHandler
module VertxWeb
  #  Handler which adds a header `x-response-time` in the response of matching requests containing the time taken
  #  in ms to process the request.
  class ResponseTimeHandler
    # @private
    # @param j_del [::VertxWeb::ResponseTimeHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::ResponseTimeHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == ResponseTimeHandler
    end
    def @@j_api_type.wrap(obj)
      ResponseTimeHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebHandler::ResponseTimeHandler.java_class
    end
    #  Create a handler
    # @overload create()
    # @return [::VertxWeb::ResponseTimeHandler] the handler
    def self.create
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::ResponseTimeHandler.java_method(:create, []).call(),::VertxWeb::ResponseTimeHandler)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create()"
      end
    end
    #  Something has happened, so handle it.
    # @overload handle(event)
    #   @param [::VertxWeb::RoutingContext] event the event to handle
    # @return [void]
    def handle(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handle(#{args[0]})"
      end
    end
  end
end
