require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.buffer.Buffer
module Vertx
  #  Most data is shuffled around inside Vert.x using buffers.
  #  <p>
  #  A buffer is a sequence of zero or more bytes that can read from or written to and which expands automatically as
  #  necessary to accommodate any bytes written to it. You can perhaps think of a buffer as smart byte array.
  #  <p>
  #  Please consult the documentation for more information on buffers.
  class Buffer
    # @private
    # @param j_del [::Vertx::Buffer] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::Buffer] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Buffer
    end
    def @@j_api_type.wrap(obj)
      Buffer.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreBuffer::Buffer.java_class
    end
    #  Appends the specified <code>double</code> to the end of the Buffer. The buffer will expand as necessary to accommodate any bytes written.<p>
    #  Returns a reference to <code>this</code> so multiple operations can be appended together.
    # @overload appendDouble(d)
    #   @param [Float] d 
    # @return [self]
    def append_double(*args)
      if args[0].class == Float && !block_given?
        @j_del.java_method(:appendDouble, [Java::double.java_class]).call(::Vertx::Util::Utils.to_double(args[0]))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling append_double(#{args[0]})"
      end
    end
    #  Appends the specified <code>long</code> to the end of the Buffer in the Little Endian Byte Order. The buffer will expand as necessary to accommodate any bytes written.<p>
    #  Returns a reference to <code>this</code> so multiple operations can be appended together.
    # @overload appendLongLE(l)
    #   @param [Fixnum] l 
    # @return [self]
    def append_long_le(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:appendLongLE, [Java::long.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling append_long_le(#{args[0]})"
      end
    end
    #  Sets the unsigned <code>short</code> at position <code>pos</code> in the Buffer to the value <code>s</code> in the Little Endian Byte Order.<p>
    #  The buffer will expand as necessary to accommodate any value written.
    # @overload setUnsignedShortLE(pos,s)
    #   @param [Fixnum] pos 
    #   @param [Fixnum] s 
    # @return [self]
    def set_unsigned_short_le(*args)
      if args[0].class == Fixnum && args[1].class == Fixnum && !block_given?
        @j_del.java_method(:setUnsignedShortLE, [Java::int.java_class,Java::int.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_unsigned_short_le(#{args[0]},#{args[1]})"
      end
    end
    #  Returns the <code>byte</code> at position <code>pos</code> in the Buffer.
    # @overload getByte(pos)
    #   @param [Fixnum] pos 
    # @return [Fixnum]
    def get_byte(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getByte, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_byte(#{args[0]})"
      end
    end
    #  Sets the unsigned <code>int</code> at position <code>pos</code> in the Buffer to the value <code>i</code>.<p>
    #  The buffer will expand as necessary to accommodate any value written.
    # @overload setUnsignedInt(pos,i)
    #   @param [Fixnum] pos 
    #   @param [Fixnum] i 
    # @return [self]
    def set_unsigned_int(*args)
      if args[0].class == Fixnum && args[1].class == Fixnum && !block_given?
        @j_del.java_method(:setUnsignedInt, [Java::int.java_class,Java::long.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_unsigned_int(#{args[0]},#{args[1]})"
      end
    end
    #  Sets the unsigned <code>short</code> at position <code>pos</code> in the Buffer to the value <code>s</code>.<p>
    #  The buffer will expand as necessary to accommodate any value written.
    # @overload setUnsignedShort(pos,s)
    #   @param [Fixnum] pos 
    #   @param [Fixnum] s 
    # @return [self]
    def set_unsigned_short(*args)
      if args[0].class == Fixnum && args[1].class == Fixnum && !block_given?
        @j_del.java_method(:setUnsignedShort, [Java::int.java_class,Java::int.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_unsigned_short(#{args[0]},#{args[1]})"
      end
    end
    #  Appends the specified <code>Buffer</code> starting at the <code>offset</code> using <code>len</code> to the end of this Buffer. The buffer will expand as necessary to accommodate
    #  any bytes written.<p>
    #  Returns a reference to <code>this</code> so multiple operations can be appended together.
    # @overload appendBuffer(buff)
    #   @param [::Vertx::Buffer] buff 
    # @overload appendBuffer(buff,offset,len)
    #   @param [::Vertx::Buffer] buff 
    #   @param [Fixnum] offset 
    #   @param [Fixnum] len 
    # @return [self]
    def append_buffer(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil && args[2] == nil
        @j_del.java_method(:appendBuffer, [Java::IoVertxCoreBuffer::Buffer.java_class]).call(args[0].j_del)
        return self
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Fixnum && args[2].class == Fixnum && !block_given?
        @j_del.java_method(:appendBuffer, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::int.java_class,Java::int.java_class]).call(args[0].j_del,args[1],args[2])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling append_buffer(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Sets the <code>short</code> at position <code>pos</code> in the Buffer to the value <code>s</code>.<p>
    #  The buffer will expand as necessary to accommodate any value written.
    # @overload setShort(pos,s)
    #   @param [Fixnum] pos 
    #   @param [Fixnum] s 
    # @return [self]
    def set_short(*args)
      if args[0].class == Fixnum && args[1].class == Fixnum && !block_given?
        @j_del.java_method(:setShort, [Java::int.java_class,Java::short.java_class]).call(args[0],::Vertx::Util::Utils.to_short(args[1]))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_short(#{args[0]},#{args[1]})"
      end
    end
    #  Sets the <code>double</code> at position <code>pos</code> in the Buffer to the value <code>d</code>.<p>
    #  The buffer will expand as necessary to accommodate any value written.
    # @overload setDouble(pos,d)
    #   @param [Fixnum] pos 
    #   @param [Float] d 
    # @return [self]
    def set_double(*args)
      if args[0].class == Fixnum && args[1].class == Float && !block_given?
        @j_del.java_method(:setDouble, [Java::int.java_class,Java::double.java_class]).call(args[0],::Vertx::Util::Utils.to_double(args[1]))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_double(#{args[0]},#{args[1]})"
      end
    end
    #  Sets the <code>long</code> at position <code>pos</code> in the Buffer to the value <code>l</code> in the Little Endian Byte Order.<p>
    #  The buffer will expand as necessary to accommodate any value written.
    # @overload setLongLE(pos,l)
    #   @param [Fixnum] pos 
    #   @param [Fixnum] l 
    # @return [self]
    def set_long_le(*args)
      if args[0].class == Fixnum && args[1].class == Fixnum && !block_given?
        @j_del.java_method(:setLongLE, [Java::int.java_class,Java::long.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_long_le(#{args[0]},#{args[1]})"
      end
    end
    #  Appends the specified unsigned <code>byte</code> to the end of the Buffer. The buffer will expand as necessary to accommodate any bytes written.<p>
    #  Returns a reference to <code>this</code> so multiple operations can be appended together.
    # @overload appendUnsignedByte(b)
    #   @param [Fixnum] b 
    # @return [self]
    def append_unsigned_byte(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:appendUnsignedByte, [Java::short.java_class]).call(::Vertx::Util::Utils.to_short(args[0]))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling append_unsigned_byte(#{args[0]})"
      end
    end
    #  Returns the unsigned <code>int</code> at position <code>pos</code> in the Buffer, as a <code>long</code> in Little Endian Byte Order.
    # @overload getUnsignedIntLE(pos)
    #   @param [Fixnum] pos 
    # @return [Fixnum]
    def get_unsigned_int_le(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getUnsignedIntLE, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_unsigned_int_le(#{args[0]})"
      end
    end
    #  Returns a slice of this buffer. Modifying the content
    #  of the returned buffer or this buffer affects each other's content
    #  while they maintain separate indexes and marks.
    # @overload slice()
    # @overload slice(start,end)
    #   @param [Fixnum] start 
    #   @param [Fixnum] _end 
    # @return [::Vertx::Buffer]
    def slice(*args)
      if !block_given? && args[0] == nil && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:slice, []).call(),::Vertx::Buffer)
      elsif args[0].class == Fixnum && args[1].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:slice, [Java::int.java_class,Java::int.java_class]).call(args[0],args[1]),::Vertx::Buffer)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling slice(#{args[0]},#{args[1]})"
      end
    end
    #  Gets a 24-bit medium integer at the specified absolute <code>index</code> in this buffer in the Little Endian Byte Order.
    # @overload getMediumLE(pos)
    #   @param [Fixnum] pos 
    # @return [Fixnum]
    def get_medium_le(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getMediumLE, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_medium_le(#{args[0]})"
      end
    end
    #  Create a new buffer from a string and using the specified encoding.
    #  The string will be encoded into the buffer using the specified encoding.
    # @overload buffer()
    # @overload buffer(initialSizeHint)
    #   @param [Fixnum] initialSizeHint the hint, in bytes
    # @overload buffer(string)
    #   @param [String] string the string
    # @overload buffer(string,enc)
    #   @param [String] string the string
    #   @param [String] enc 
    # @return [::Vertx::Buffer] the buffer
    def self.buffer(*args)
      if !block_given? && args[0] == nil && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreBuffer::Buffer.java_method(:buffer, []).call(),::Vertx::Buffer)
      elsif args[0].class == Fixnum && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreBuffer::Buffer.java_method(:buffer, [Java::int.java_class]).call(args[0]),::Vertx::Buffer)
      elsif args[0].class == String && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreBuffer::Buffer.java_method(:buffer, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::Buffer)
      elsif args[0].class == String && args[1].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreBuffer::Buffer.java_method(:buffer, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1]),::Vertx::Buffer)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling buffer(#{args[0]},#{args[1]})"
      end
    end
    #  Returns the unsigned <code>int</code> at position <code>pos</code> in the Buffer, as a <code>long</code>.
    # @overload getUnsignedInt(pos)
    #   @param [Fixnum] pos 
    # @return [Fixnum]
    def get_unsigned_int(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getUnsignedInt, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_unsigned_int(#{args[0]})"
      end
    end
    #  Appends the specified <code>String</code> to the end of the Buffer with the encoding as specified by <code>enc</code>.<p>
    #  The buffer will expand as necessary to accommodate any bytes written.<p>
    #  Returns a reference to <code>this</code> so multiple operations can be appended together.<p>
    # @overload appendString(str)
    #   @param [String] str 
    # @overload appendString(str,enc)
    #   @param [String] str 
    #   @param [String] enc 
    # @return [self]
    def append_string(*args)
      if args[0].class == String && !block_given? && args[1] == nil
        @j_del.java_method(:appendString, [Java::java.lang.String.java_class]).call(args[0])
        return self
      elsif args[0].class == String && args[1].class == String && !block_given?
        @j_del.java_method(:appendString, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling append_string(#{args[0]},#{args[1]})"
      end
    end
    #  Appends the specified 24bit <code>int</code> to the end of the Buffer in the Little Endian Byte Order. The buffer will expand as necessary to accommodate any bytes written.<p>
    #  Returns a reference to <code>this</code> so multiple operations can be appended together.
    # @overload appendMediumLE(i)
    #   @param [Fixnum] i 
    # @return [self]
    def append_medium_le(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:appendMediumLE, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling append_medium_le(#{args[0]})"
      end
    end
    #  Returns the unsigned <code>short</code> at position <code>pos</code> in the Buffer, as an <code>int</code>.
    # @overload getUnsignedShort(pos)
    #   @param [Fixnum] pos 
    # @return [Fixnum]
    def get_unsigned_short(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getUnsignedShort, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_unsigned_short(#{args[0]})"
      end
    end
    #  Returns a Json array representation of the Buffer.
    # @overload toJsonArray()
    # @return [Array<String,Object>]
    def to_json_array
      if !block_given?
        return @j_del.java_method(:toJsonArray, []).call() != nil ? JSON.parse(@j_del.java_method(:toJsonArray, []).call().encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling to_json_array()"
      end
    end
    #  Sets the <code>int</code> at position <code>pos</code> in the Buffer to the value <code>i</code>.<p>
    #  The buffer will expand as necessary to accommodate any value written.
    # @overload setInt(pos,i)
    #   @param [Fixnum] pos 
    #   @param [Fixnum] i 
    # @return [self]
    def set_int(*args)
      if args[0].class == Fixnum && args[1].class == Fixnum && !block_given?
        @j_del.java_method(:setInt, [Java::int.java_class,Java::int.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_int(#{args[0]},#{args[1]})"
      end
    end
    #  Gets an unsigned 16-bit short integer at the specified absolute <code>index</code> in this buffer in Little Endian Byte Order.
    # @overload getUnsignedShortLE(pos)
    #   @param [Fixnum] pos 
    # @return [Fixnum]
    def get_unsigned_short_le(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getUnsignedShortLE, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_unsigned_short_le(#{args[0]})"
      end
    end
    #  Appends the specified <code>byte</code> to the end of the Buffer. The buffer will expand as necessary to accommodate any bytes written.<p>
    #  Returns a reference to <code>this</code> so multiple operations can be appended together.
    # @overload appendByte(b)
    #   @param [Fixnum] b 
    # @return [self]
    def append_byte(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:appendByte, [Java::byte.java_class]).call(::Vertx::Util::Utils.to_byte(args[0]))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling append_byte(#{args[0]})"
      end
    end
    #  Returns the <code>int</code> at position <code>pos</code> in the Buffer.
    # @overload getInt(pos)
    #   @param [Fixnum] pos 
    # @return [Fixnum]
    def get_int(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getInt, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_int(#{args[0]})"
      end
    end
    #  Sets the bytes at position <code>pos</code> in the Buffer to the value of <code>str</code> encoded in encoding <code>enc</code>.<p>
    #  The buffer will expand as necessary to accommodate any value written.
    # @overload setString(pos,str)
    #   @param [Fixnum] pos 
    #   @param [String] str 
    # @overload setString(pos,str,enc)
    #   @param [Fixnum] pos 
    #   @param [String] str 
    #   @param [String] enc 
    # @return [self]
    def set_string(*args)
      if args[0].class == Fixnum && args[1].class == String && !block_given? && args[2] == nil
        @j_del.java_method(:setString, [Java::int.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
        return self
      elsif args[0].class == Fixnum && args[1].class == String && args[2].class == String && !block_given?
        @j_del.java_method(:setString, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_string(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Sets the <code>long</code> at position <code>pos</code> in the Buffer to the value <code>l</code>.<p>
    #  The buffer will expand as necessary to accommodate any value written.
    # @overload setLong(pos,l)
    #   @param [Fixnum] pos 
    #   @param [Fixnum] l 
    # @return [self]
    def set_long(*args)
      if args[0].class == Fixnum && args[1].class == Fixnum && !block_given?
        @j_del.java_method(:setLong, [Java::int.java_class,Java::long.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_long(#{args[0]},#{args[1]})"
      end
    end
    #  Returns a Json representation of the Buffer.
    # @overload toJson()
    # @return [Object] a JSON element which can be a , , String, ...etc if the buffer contains an array, object, string, ...etc
    def to_json
      if !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:toJson, []).call())
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling to_json()"
      end
    end
    #  Sets the unsigned <code>int</code> at position <code>pos</code> in the Buffer to the value <code>i</code> in the Little Endian Byte Order.<p>
    #  The buffer will expand as necessary to accommodate any value written.
    # @overload setUnsignedIntLE(pos,i)
    #   @param [Fixnum] pos 
    #   @param [Fixnum] i 
    # @return [self]
    def set_unsigned_int_le(*args)
      if args[0].class == Fixnum && args[1].class == Fixnum && !block_given?
        @j_del.java_method(:setUnsignedIntLE, [Java::int.java_class,Java::long.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_unsigned_int_le(#{args[0]},#{args[1]})"
      end
    end
    #  Appends the specified <code>int</code> to the end of the Buffer. The buffer will expand as necessary to accommodate any bytes written.<p>
    #  Returns a reference to <code>this</code> so multiple operations can be appended together.
    # @overload appendInt(i)
    #   @param [Fixnum] i 
    # @return [self]
    def append_int(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:appendInt, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling append_int(#{args[0]})"
      end
    end
    #  Returns a Json object representation of the Buffer.
    # @overload toJsonObject()
    # @return [Hash{String => Object}]
    def to_json_object
      if !block_given?
        return @j_del.java_method(:toJsonObject, []).call() != nil ? JSON.parse(@j_del.java_method(:toJsonObject, []).call().encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling to_json_object()"
      end
    end
    #  Gets a 16-bit short integer at the specified absolute <code>index</code> in this buffer in Little Endian Byte Order.
    # @overload getShortLE(pos)
    #   @param [Fixnum] pos 
    # @return [Fixnum]
    def get_short_le(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getShortLE, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_short_le(#{args[0]})"
      end
    end
    #  Gets a 24-bit medium integer at the specified absolute <code>index</code> in this buffer.
    # @overload getMedium(pos)
    #   @param [Fixnum] pos 
    # @return [Fixnum]
    def get_medium(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getMedium, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_medium(#{args[0]})"
      end
    end
    #  Sets the <code>int</code> at position <code>pos</code> in the Buffer to the value <code>i</code> in the Little Endian Byte Order.<p>
    #  The buffer will expand as necessary to accommodate any value written.
    # @overload setIntLE(pos,i)
    #   @param [Fixnum] pos 
    #   @param [Fixnum] i 
    # @return [self]
    def set_int_le(*args)
      if args[0].class == Fixnum && args[1].class == Fixnum && !block_given?
        @j_del.java_method(:setIntLE, [Java::int.java_class,Java::int.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_int_le(#{args[0]},#{args[1]})"
      end
    end
    #  Appends the specified <code>long</code> to the end of the Buffer. The buffer will expand as necessary to accommodate any bytes written.<p>
    #  Returns a reference to <code>this</code> so multiple operations can be appended together.
    # @overload appendLong(l)
    #   @param [Fixnum] l 
    # @return [self]
    def append_long(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:appendLong, [Java::long.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling append_long(#{args[0]})"
      end
    end
    #  Sets the <code>byte</code> at position <code>pos</code> in the Buffer to the value <code>b</code>.<p>
    #  The buffer will expand as necessary to accommodate any value written.
    # @overload setByte(pos,b)
    #   @param [Fixnum] pos 
    #   @param [Fixnum] b 
    # @return [self]
    def set_byte(*args)
      if args[0].class == Fixnum && args[1].class == Fixnum && !block_given?
        @j_del.java_method(:setByte, [Java::int.java_class,Java::byte.java_class]).call(args[0],::Vertx::Util::Utils.to_byte(args[1]))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_byte(#{args[0]},#{args[1]})"
      end
    end
    #  Returns a copy of a sub-sequence the Buffer as a {::Vertx::Buffer} starting at position <code>start</code>
    #  and ending at position <code>end - 1</code>
    # @overload getBuffer(start,end)
    #   @param [Fixnum] start 
    #   @param [Fixnum] _end 
    # @return [::Vertx::Buffer]
    def get_buffer(*args)
      if args[0].class == Fixnum && args[1].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getBuffer, [Java::int.java_class,Java::int.java_class]).call(args[0],args[1]),::Vertx::Buffer)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_buffer(#{args[0]},#{args[1]})"
      end
    end
    #  Sets the <code>short</code> at position <code>pos</code> in the Buffer to the value <code>s</code> in the Little Endian Byte Order.<p>
    #  The buffer will expand as necessary to accommodate any value written.
    # @overload setShortLE(pos,s)
    #   @param [Fixnum] pos 
    #   @param [Fixnum] s 
    # @return [self]
    def set_short_le(*args)
      if args[0].class == Fixnum && args[1].class == Fixnum && !block_given?
        @j_del.java_method(:setShortLE, [Java::int.java_class,Java::short.java_class]).call(args[0],::Vertx::Util::Utils.to_short(args[1]))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_short_le(#{args[0]},#{args[1]})"
      end
    end
    #  Returns the <code>double</code> at position <code>pos</code> in the Buffer.
    # @overload getDouble(pos)
    #   @param [Fixnum] pos 
    # @return [Float]
    def get_double(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getDouble, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_double(#{args[0]})"
      end
    end
    #  Appends the specified <code>short</code> to the end of the Buffer in the Little Endian Byte Order.The buffer will expand as necessary to accommodate any bytes written.<p>
    #  Returns a reference to <code>this</code> so multiple operations can be appended together.
    # @overload appendShortLE(s)
    #   @param [Fixnum] s 
    # @return [self]
    def append_short_le(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:appendShortLE, [Java::short.java_class]).call(::Vertx::Util::Utils.to_short(args[0]))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling append_short_le(#{args[0]})"
      end
    end
    #  Appends the specified unsigned <code>int</code> to the end of the Buffer. The buffer will expand as necessary to accommodate any bytes written.<p>
    #  Returns a reference to <code>this</code> so multiple operations can be appended together.
    # @overload appendUnsignedInt(i)
    #   @param [Fixnum] i 
    # @return [self]
    def append_unsigned_int(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:appendUnsignedInt, [Java::long.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling append_unsigned_int(#{args[0]})"
      end
    end
    #  Returns the <code>float</code> at position <code>pos</code> in the Buffer.
    # @overload getFloat(pos)
    #   @param [Fixnum] pos 
    # @return [Float]
    def get_float(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getFloat, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_float(#{args[0]})"
      end
    end
    #  Appends the specified <code>float</code> to the end of the Buffer. The buffer will expand as necessary to accommodate any bytes written.<p>
    #  Returns a reference to <code>this</code> so multiple operations can be appended together.
    # @overload appendFloat(f)
    #   @param [Float] f 
    # @return [self]
    def append_float(*args)
      if args[0].class == Float && !block_given?
        @j_del.java_method(:appendFloat, [Java::float.java_class]).call(::Vertx::Util::Utils.to_float(args[0]))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling append_float(#{args[0]})"
      end
    end
    #  Gets a 64-bit long integer at the specified absolute <code>index</code> in this buffer in Little Endian Byte Order.
    # @overload getLongLE(pos)
    #   @param [Fixnum] pos 
    # @return [Fixnum]
    def get_long_le(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getLongLE, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_long_le(#{args[0]})"
      end
    end
    #  Returns a copy of the entire Buffer.
    # @overload copy()
    # @return [::Vertx::Buffer]
    def copy
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:copy, []).call(),::Vertx::Buffer)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling copy()"
      end
    end
    #  Sets the 24bit <code>int</code> at position <code>pos</code> in the Buffer to the value <code>i</code>. in the Little Endian Byte Order<p>
    #  The buffer will expand as necessary to accommodate any value written.
    # @overload setMediumLE(pos,i)
    #   @param [Fixnum] pos 
    #   @param [Fixnum] i 
    # @return [self]
    def set_medium_le(*args)
      if args[0].class == Fixnum && args[1].class == Fixnum && !block_given?
        @j_del.java_method(:setMediumLE, [Java::int.java_class,Java::int.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_medium_le(#{args[0]},#{args[1]})"
      end
    end
    #  Sets the unsigned <code>byte</code> at position <code>pos</code> in the Buffer to the value <code>b</code>.<p>
    #  The buffer will expand as necessary to accommodate any value written.
    # @overload setUnsignedByte(pos,b)
    #   @param [Fixnum] pos 
    #   @param [Fixnum] b 
    # @return [self]
    def set_unsigned_byte(*args)
      if args[0].class == Fixnum && args[1].class == Fixnum && !block_given?
        @j_del.java_method(:setUnsignedByte, [Java::int.java_class,Java::short.java_class]).call(args[0],::Vertx::Util::Utils.to_short(args[1]))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_unsigned_byte(#{args[0]},#{args[1]})"
      end
    end
    #  Sets the <code>float</code> at position <code>pos</code> in the Buffer to the value <code>f</code>.<p>
    #  The buffer will expand as necessary to accommodate any value written.
    # @overload setFloat(pos,f)
    #   @param [Fixnum] pos 
    #   @param [Float] f 
    # @return [self]
    def set_float(*args)
      if args[0].class == Fixnum && args[1].class == Float && !block_given?
        @j_del.java_method(:setFloat, [Java::int.java_class,Java::float.java_class]).call(args[0],::Vertx::Util::Utils.to_float(args[1]))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_float(#{args[0]},#{args[1]})"
      end
    end
    #  Appends the specified unsigned <code>int</code> to the end of the Buffer in the Little Endian Byte Order. The buffer will expand as necessary to accommodate any bytes written.<p>
    #  Returns a reference to <code>this</code> so multiple operations can be appended together.
    # @overload appendUnsignedIntLE(i)
    #   @param [Fixnum] i 
    # @return [self]
    def append_unsigned_int_le(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:appendUnsignedIntLE, [Java::long.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling append_unsigned_int_le(#{args[0]})"
      end
    end
    #  Sets the bytes at position <code>pos</code> in the Buffer to the bytes represented by the <code>Buffer b</code> on the given <code>offset</code> and <code>len</code>.<p>
    #  The buffer will expand as necessary to accommodate any value written.
    # @overload setBuffer(pos,b)
    #   @param [Fixnum] pos 
    #   @param [::Vertx::Buffer] b 
    # @overload setBuffer(pos,b,offset,len)
    #   @param [Fixnum] pos 
    #   @param [::Vertx::Buffer] b 
    #   @param [Fixnum] offset 
    #   @param [Fixnum] len 
    # @return [self]
    def set_buffer(*args)
      if args[0].class == Fixnum && args[1].class.method_defined?(:j_del) && !block_given? && args[2] == nil && args[3] == nil
        @j_del.java_method(:setBuffer, [Java::int.java_class,Java::IoVertxCoreBuffer::Buffer.java_class]).call(args[0],args[1].j_del)
        return self
      elsif args[0].class == Fixnum && args[1].class.method_defined?(:j_del) && args[2].class == Fixnum && args[3].class == Fixnum && !block_given?
        @j_del.java_method(:setBuffer, [Java::int.java_class,Java::IoVertxCoreBuffer::Buffer.java_class,Java::int.java_class,Java::int.java_class]).call(args[0],args[1].j_del,args[2],args[3])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_buffer(#{args[0]},#{args[1]},#{args[2]},#{args[3]})"
      end
    end
    #  Returns the <code>short</code> at position <code>pos</code> in the Buffer.
    # @overload getShort(pos)
    #   @param [Fixnum] pos 
    # @return [Fixnum]
    def get_short(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getShort, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_short(#{args[0]})"
      end
    end
    #  Appends the specified <code>short</code> to the end of the Buffer.The buffer will expand as necessary to accommodate any bytes written.<p>
    #  Returns a reference to <code>this</code> so multiple operations can be appended together.
    # @overload appendShort(s)
    #   @param [Fixnum] s 
    # @return [self]
    def append_short(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:appendShort, [Java::short.java_class]).call(::Vertx::Util::Utils.to_short(args[0]))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling append_short(#{args[0]})"
      end
    end
    #  Returns the length of the buffer, measured in bytes.
    #  All positions are indexed from zero.
    # @overload length()
    # @return [Fixnum]
    def length
      if !block_given?
        return @j_del.java_method(:length, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling length()"
      end
    end
    #  Returns a copy of a sub-sequence the Buffer as a <code>String</code> starting at position <code>start</code>
    #  and ending at position <code>end - 1</code> interpreted as a String in the specified encoding
    # @overload getString(start,end)
    #   @param [Fixnum] start 
    #   @param [Fixnum] _end 
    # @overload getString(start,end,enc)
    #   @param [Fixnum] start 
    #   @param [Fixnum] _end 
    #   @param [String] enc 
    # @return [String]
    def get_string(*args)
      if args[0].class == Fixnum && args[1].class == Fixnum && !block_given? && args[2] == nil
        return @j_del.java_method(:getString, [Java::int.java_class,Java::int.java_class]).call(args[0],args[1])
      elsif args[0].class == Fixnum && args[1].class == Fixnum && args[2].class == String && !block_given?
        return @j_del.java_method(:getString, [Java::int.java_class,Java::int.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_string(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Gets a 32-bit integer at the specified absolute <code>index</code> in this buffer with Little Endian Byte Order.
    # @overload getIntLE(pos)
    #   @param [Fixnum] pos 
    # @return [Fixnum]
    def get_int_le(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getIntLE, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_int_le(#{args[0]})"
      end
    end
    #  Returns the unsigned <code>byte</code> at position <code>pos</code> in the Buffer, as a <code>short</code>.
    # @overload getUnsignedByte(pos)
    #   @param [Fixnum] pos 
    # @return [Fixnum]
    def get_unsigned_byte(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getUnsignedByte, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_unsigned_byte(#{args[0]})"
      end
    end
    #  Appends the specified unsigned <code>short</code> to the end of the Buffer in the Little Endian Byte Order.The buffer will expand as necessary to accommodate any bytes written.<p>
    #  Returns a reference to <code>this</code> so multiple operations can be appended together.
    # @overload appendUnsignedShortLE(s)
    #   @param [Fixnum] s 
    # @return [self]
    def append_unsigned_short_le(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:appendUnsignedShortLE, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling append_unsigned_short_le(#{args[0]})"
      end
    end
    #  Appends the specified unsigned <code>short</code> to the end of the Buffer.The buffer will expand as necessary to accommodate any bytes written.<p>
    #  Returns a reference to <code>this</code> so multiple operations can be appended together.
    # @overload appendUnsignedShort(s)
    #   @param [Fixnum] s 
    # @return [self]
    def append_unsigned_short(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:appendUnsignedShort, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling append_unsigned_short(#{args[0]})"
      end
    end
    #  Returns the <code>long</code> at position <code>pos</code> in the Buffer.
    # @overload getLong(pos)
    #   @param [Fixnum] pos 
    # @return [Fixnum]
    def get_long(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getLong, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_long(#{args[0]})"
      end
    end
    #  Appends the specified <code>int</code> to the end of the Buffer in the Little Endian Byte Order. The buffer will expand as necessary to accommodate any bytes written.<p>
    #  Returns a reference to <code>this</code> so multiple operations can be appended together.
    # @overload appendIntLE(i)
    #   @param [Fixnum] i 
    # @return [self]
    def append_int_le(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:appendIntLE, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling append_int_le(#{args[0]})"
      end
    end
    #  Gets an unsigned 24-bit medium integer at the specified absolute <code>index</code> in this buffer in Little Endian Byte Order.
    # @overload getUnsignedMediumLE(pos)
    #   @param [Fixnum] pos 
    # @return [Fixnum]
    def get_unsigned_medium_le(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getUnsignedMediumLE, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_unsigned_medium_le(#{args[0]})"
      end
    end
    #  Gets an unsigned 24-bit medium integer at the specified absolute <code>index</code> in this buffer.
    # @overload getUnsignedMedium(pos)
    #   @param [Fixnum] pos 
    # @return [Fixnum]
    def get_unsigned_medium(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getUnsignedMedium, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_unsigned_medium(#{args[0]})"
      end
    end
    #  Returns a <code>String</code> representation of the Buffer with the encoding specified by <code>enc</code>
    # @overload toString()
    # @overload toString(enc)
    #   @param [String] enc 
    # @return [String]
    def to_string(*args)
      if !block_given? && args[0] == nil
        return @j_del.java_method(:toString, []).call()
      elsif args[0].class == String && !block_given?
        return @j_del.java_method(:toString, [Java::java.lang.String.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling to_string(#{args[0]})"
      end
    end
    #  Appends the specified 24bit <code>int</code> to the end of the Buffer. The buffer will expand as necessary to accommodate any bytes written.<p>
    #  Returns a reference to <code>this</code> so multiple operations can be appended together.
    # @overload appendMedium(i)
    #   @param [Fixnum] i 
    # @return [self]
    def append_medium(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:appendMedium, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling append_medium(#{args[0]})"
      end
    end
    #  Sets the 24bit <code>int</code> at position <code>pos</code> in the Buffer to the value <code>i</code>.<p>
    #  The buffer will expand as necessary to accommodate any value written.
    # @overload setMedium(pos,i)
    #   @param [Fixnum] pos 
    #   @param [Fixnum] i 
    # @return [self]
    def set_medium(*args)
      if args[0].class == Fixnum && args[1].class == Fixnum && !block_given?
        @j_del.java_method(:setMedium, [Java::int.java_class,Java::int.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_medium(#{args[0]},#{args[1]})"
      end
    end
  end
end
