require 'vertx/promise'
require 'vertx/vertx'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.Context
module Vertx
  #  The execution context of a {Proc} execution.
  #  <p>
  #  When Vert.x provides an event to a handler or calls the start or stop methods of a {Nil},
  #  the execution is associated with a <code>Context</code>.
  #  <p>
  #  Usually a context is an *event-loop context* and is tied to a specific event loop thread. So executions for that
  #  context always occur on that exact same event loop thread.
  #  <p>
  #  In the case of worker verticles and running inline blocking code a worker context will be associated with the execution
  #  which will use a thread from the worker thread pool.
  #  <p>
  #  When a handler is set by a thread associated with a specific context, the Vert.x will guarantee that when that handler
  #  is executed, that execution will be associated with the same context.
  #  <p>
  #  If a handler is set by a thread not associated with a context (i.e. a non Vert.x thread). Then a new context will
  #  be created for that handler.
  #  <p>
  #  In other words, a context is propagated.
  #  <p>
  #  This means that when a verticle is deployed, any handlers it sets will be associated with the same context - the context
  #  of the verticle.
  #  <p>
  #  This means (in the case of a standard verticle) that the verticle code will always be executed with the exact same
  #  thread, so you don't have to worry about multi-threaded acccess to the verticle state and you can code your application
  #  as single threaded.
  #  <p>
  #  This class also allows arbitrary data to be {::Vertx::Context#put} and {::Vertx::Context#get} on the context so it can be shared easily
  #  amongst different handlers of, for example, a verticle instance.
  #  <p>
  #  This class also provides {::Vertx::Context#run_on_context} which allows an action to be executed asynchronously using the same context.
  class Context
    # @private
    # @param j_del [::Vertx::Context] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::Context] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Context
    end
    def @@j_api_type.wrap(obj)
      Context.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCore::Context.java_class
    end
    # @overload owner()
    # @return [::Vertx::Vertx] The Vertx instance that created the context
    def owner
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:owner, []).call(),::Vertx::Vertx)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling owner()"
      end
    end
    #  The process args
    # @overload processArgs()
    # @return [Array<String>]
    def process_args
      if !block_given?
        return @j_del.java_method(:processArgs, []).call().to_a.map { |elt| elt }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling process_args()"
      end
    end
    # @overload getInstanceCount()
    # @return [Fixnum] the number of instances of the verticle that were deployed in the deployment (if any) related to this context
    def get_instance_count
      if !block_given?
        return @j_del.java_method(:getInstanceCount, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_instance_count()"
      end
    end
    #  Is the current context a worker context?
    #  <p>
    #  NOTE! when running blocking code using {::Vertx::Vertx#execute_blocking} from a
    #  standard (not worker) verticle, the context will still an event loop context and this 
    #  will return false.
    # @overload isWorkerContext()
    # @return [true,false] true if the current context is a worker context, false otherwise
    def worker_context?
      if !block_given?
        return @j_del.java_method(:isWorkerContext, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling worker_context?()"
      end
    end
    #  Is the current thread a worker thread?
    #  <p>
    #  NOTE! This is not always the same as calling {::Vertx::Context#is_worker_context}. If you are running blocking code
    #  from an event loop context, then this will return true but {::Vertx::Context#is_worker_context} will return false.
    # @overload isOnWorkerThread()
    # @return [true,false] true if current thread is a worker thread, false otherwise
    def self.on_worker_thread?
      if !block_given?
        return Java::IoVertxCore::Context.java_method(:isOnWorkerThread, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling on_worker_thread?()"
      end
    end
    #  Put some local data in the context.
    #  <p>
    #  This can be used to share data between different handlers that share a context
    # @overload putLocal(key,value)
    #   @param [String] key the key of the data
    #   @param [Object] value the data
    # @return [void]
    def put_local(*args)
      if args[0].class == String && ::Vertx::Util::unknown_type.accept?(args[1]) && !block_given?
        return @j_del.java_method(:putLocal, [Java::java.lang.String.java_class,Java::java.lang.Object.java_class]).call(args[0],::Vertx::Util::Utils.to_object(args[1]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling put_local(#{args[0]},#{args[1]})"
      end
    end
    #  Is the current thread a Vert.x thread? That's either a worker thread or an event loop thread
    # @overload isOnVertxThread()
    # @return [true,false] true if current thread is a Vert.x thread, false otherwise
    def self.on_vertx_thread?
      if !block_given?
        return Java::IoVertxCore::Context.java_method(:isOnVertxThread, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling on_vertx_thread?()"
      end
    end
    #  Remove some data from the context.
    # @overload remove(key)
    #   @param [String] key the key to remove
    # @return [true,false] true if removed successfully, false otherwise
    def remove?(*args)
      if args[0].class == String && !block_given?
        return @j_del.java_method(:remove, [Java::java.lang.String.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remove?(#{args[0]})"
      end
    end
    #  Put some data in the context.
    #  <p>
    #  This can be used to share data between different handlers that share a context
    # @overload put(key,value)
    #   @param [String] key the key of the data
    #   @param [Object] value the data
    # @return [void]
    def put(*args)
      if args[0].class == String && ::Vertx::Util::unknown_type.accept?(args[1]) && !block_given?
        return @j_del.java_method(:put, [Java::java.lang.String.java_class,Java::java.lang.Object.java_class]).call(args[0],::Vertx::Util::Utils.to_object(args[1]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling put(#{args[0]},#{args[1]})"
      end
    end
    #  Remove some local data from the context.
    # @overload removeLocal(key)
    #   @param [String] key the key to remove
    # @return [true,false] true if removed successfully, false otherwise
    def remove_local?(*args)
      if args[0].class == String && !block_given?
        return @j_del.java_method(:removeLocal, [Java::java.lang.String.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remove_local?(#{args[0]})"
      end
    end
    #  Get some local data from the context.
    # @overload getLocal(key)
    #   @param [String] key the key of the data
    # @return [Object] the data
    def get_local(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:getLocal, [Java::java.lang.String.java_class]).call(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_local(#{args[0]})"
      end
    end
    #  Get some data from the context.
    # @overload get(key)
    #   @param [String] key the key of the data
    # @return [Object] the data
    def get(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:get, [Java::java.lang.String.java_class]).call(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get(#{args[0]})"
      end
    end
    #  If the context is associated with a Verticle deployment, this returns the deployment ID of that deployment.
    # @overload deploymentID()
    # @return [String] the deployment ID of the deployment or null if not a Verticle deployment
    def deployment_id
      if !block_given?
        return @j_del.java_method(:deploymentID, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling deployment_id()"
      end
    end
    #  Is the current context an event loop context?
    #  <p>
    #  NOTE! when running blocking code using {::Vertx::Vertx#execute_blocking} from a
    #  standard (not worker) verticle, the context will still an event loop context and this 
    #  will return true.
    # @overload isEventLoopContext()
    # @return [true,false] true if false otherwise
    def event_loop_context?
      if !block_given?
        return @j_del.java_method(:isEventLoopContext, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling event_loop_context?()"
      end
    end
    #  Run the specified action asynchronously on the same context, some time after the current execution has completed.
    # @overload runOnContext(action)
    #   @yield the action to run
    # @return [void]
    def run_on_context
      if true
        return @j_del.java_method(:runOnContext, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling run_on_context()"
      end
    end
    #  Is the current thread an event thread?
    #  <p>
    #  NOTE! This is not always the same as calling {::Vertx::Context#is_event_loop_context}. If you are running blocking code
    #  from an event loop context, then this will return false but {::Vertx::Context#is_event_loop_context} will return true.
    # @overload isOnEventLoopThread()
    # @return [true,false] true if current thread is an event thread, false otherwise
    def self.on_event_loop_thread?
      if !block_given?
        return Java::IoVertxCore::Context.java_method(:isOnEventLoopThread, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling on_event_loop_thread?()"
      end
    end
    #  Safely execute some blocking code.
    #  <p>
    #  Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
    #  <p>
    #  When the code is complete the handler <code>resultHandler</code> will be called with the result on the original context
    #  (e.g. on the original event loop of the caller).
    #  <p>
    #  A <code>Future</code> instance is passed into <code>blockingCodeHandler</code>. When the blocking code successfully completes,
    #  the handler should call the {::Vertx::Promise#complete} or {::Vertx::Promise#complete} method, or the {::Vertx::Promise#fail}
    #  method if it failed.
    #  <p>
    #  The blocking code should block for a reasonable amount of time (i.e no more than a few seconds). Long blocking operations
    #  or polling operations (i.e a thread that spin in a loop polling events in a blocking fashion) are precluded.
    #  <p>
    #  When the blocking operation lasts more than the 10 seconds, a message will be printed on the console by the
    #  blocked thread checker.
    #  <p>
    #  Long blocking operations should use a dedicated thread managed by the application, which can interact with
    #  verticles using the event-bus or {::Vertx::Context#run_on_context}
    # @overload executeBlocking(blockingCodeHandler,resultHandler)
    #   @param [Proc] blockingCodeHandler handler representing the blocking code to run
    #   @yield handler that will be called when the blocking code is complete
    # @overload executeBlocking(blockingCodeHandler,ordered,resultHandler)
    #   @param [Proc] blockingCodeHandler handler representing the blocking code to run
    #   @param [true,false] ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
    #   @yield handler that will be called when the blocking code is complete
    # @return [void]
    def execute_blocking(*args)
      if args[0].class == Proc && true && args[1] == nil
        if (block_given?)
          return @j_del.java_method(:executeBlocking, [Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| args[0].call(::Vertx::Util::Utils.safe_create(event,::Vertx::Promise, nil)) unless args[0] == nil }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.from_object(ar.result) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:executeBlocking, [Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| args[0].call(::Vertx::Util::Utils.safe_create(event,::Vertx::Promise, nil)) unless args[0] == nil }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.from_object(ar.result) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == Proc && (args[1].class == TrueClass || args[1].class == FalseClass) && true
        if (block_given?)
          return @j_del.java_method(:executeBlocking, [Java::IoVertxCore::Handler.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| args[0].call(::Vertx::Util::Utils.safe_create(event,::Vertx::Promise, nil)) unless args[0] == nil }),args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.from_object(ar.result) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:executeBlocking, [Java::IoVertxCore::Handler.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| args[0].call(::Vertx::Util::Utils.safe_create(event,::Vertx::Promise, nil)) unless args[0] == nil }),args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.from_object(ar.result) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling execute_blocking(#{args[0]},#{args[1]})"
      end
    end
    #  Set an exception handler called when the context runs an action throwing an uncaught throwable.<p/>
    # 
    #  When this handler is called, {::Vertx::Vertx#current_context} will return this context.
    # @overload exceptionHandler(handler)
    #   @yield the exception handler
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exception_handler()"
      end
    end
    #  If the context is associated with a Verticle deployment, this returns the configuration that was specified when
    #  the verticle was deployed.
    # @overload config()
    # @return [Hash{String => Object}] the configuration of the deployment or null if not a Verticle deployment
    def config
      if !block_given?
        return @j_del.java_method(:config, []).call() != nil ? JSON.parse(@j_del.java_method(:config, []).call().encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling config()"
      end
    end
  end
end
