require 'vertx/async_file'
require 'vertx/buffer'
require 'vertx/future'
require 'vertx/file_system_props'
require 'vertx/file_props'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.file.FileSystem
module Vertx
  #  Contains a broad set of operations for manipulating files on the file system.
  #  <p>
  #  A (potential) blocking and non blocking version of each operation is provided.
  #  <p>
  #  The non blocking versions take a handler which is called when the operation completes or an error occurs.
  #  <p>
  #  The blocking versions are named <code>xxxBlocking</code> and return the results, or throw exceptions directly.
  #  In many cases, depending on the operating system and file system some of the potentially blocking operations
  #  can return quickly, which is why we provide them, but it's highly recommended that you test how long they take to
  #  return in your particular application before using them on an event loop.
  #  <p>
  #  Please consult the documentation for more information on file system support.
  class FileSystem
    # @private
    # @param j_del [::Vertx::FileSystem] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::FileSystem] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == FileSystem
    end
    def @@j_api_type.wrap(obj)
      FileSystem.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreFile::FileSystem.java_class
    end
    #  Blocking version of {::Vertx::FileSystem#create_temp_directory}
    # @overload createTempDirectoryBlocking(prefix)
    #   @param [String] prefix 
    # @overload createTempDirectoryBlocking(prefix,perms)
    #   @param [String] prefix 
    #   @param [String] perms 
    # @overload createTempDirectoryBlocking(dir,prefix,perms)
    #   @param [String] dir 
    #   @param [String] prefix 
    #   @param [String] perms 
    # @return [String]
    def create_temp_directory_blocking(*args)
      if args[0].class == String && !block_given? && args[1] == nil && args[2] == nil
        return @j_del.java_method(:createTempDirectoryBlocking, [Java::java.lang.String.java_class]).call(args[0])
      elsif args[0].class == String && args[1].class == String && !block_given? && args[2] == nil
        return @j_del.java_method(:createTempDirectoryBlocking, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
      elsif args[0].class == String && args[1].class == String && args[2].class == String && !block_given?
        return @j_del.java_method(:createTempDirectoryBlocking, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_temp_directory_blocking(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Blocking version of {::Vertx::FileSystem#delete}
    # @overload deleteBlocking(path)
    #   @param [String] path 
    # @return [self]
    def delete_blocking(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:deleteBlocking, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling delete_blocking(#{args[0]})"
      end
    end
    #  Blocking version of {::Vertx::FileSystem#read_symlink}
    # @overload readSymlinkBlocking(link)
    #   @param [String] link 
    # @return [String]
    def read_symlink_blocking(*args)
      if args[0].class == String && !block_given?
        return @j_del.java_method(:readSymlinkBlocking, [Java::java.lang.String.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling read_symlink_blocking(#{args[0]})"
      end
    end
    #  Creates an empty file with the specified <code>path</code> and permissions <code>perms</code>, asynchronously.
    # @overload createFile(path,handler)
    #   @param [String] path path to the file
    #   @yield the handler that will be called on completion
    # @overload createFile(path,perms,handler)
    #   @param [String] path path to the file
    #   @param [String] perms the permissions string
    #   @yield the handler that will be called on completion
    # @return [self]
    def create_file(*args)
      if args[0].class == String && true && args[1] == nil
        if (block_given?)
          @j_del.java_method(:createFile, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createFile, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && args[1].class == String && true
        if (block_given?)
          @j_del.java_method(:createFile, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createFile, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_file(#{args[0]},#{args[1]})"
      end
    end
    #  Truncate the file represented by <code>path</code> to length <code>len</code> in bytes, asynchronously.
    #  <p>
    #  The operation will fail if the file does not exist or <code>len</code> is less than <code>zero</code>.
    # @overload truncate(path,len,handler)
    #   @param [String] path the path to the file
    #   @param [Fixnum] len the length to truncate it to
    #   @yield the handler that will be called on completion
    # @return [self]
    def truncate(*args)
      if args[0].class == String && args[1].class == Fixnum && true
        if (block_given?)
          @j_del.java_method(:truncate, [Java::java.lang.String.java_class,Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:truncate, [Java::java.lang.String.java_class,Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling truncate(#{args[0]},#{args[1]})"
      end
    end
    #  Blocking version of {::Vertx::FileSystem#fs_props}
    # @overload fsPropsBlocking(path)
    #   @param [String] path 
    # @return [::Vertx::FileSystemProps]
    def fs_props_blocking(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:fsPropsBlocking, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::FileSystemProps)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling fs_props_blocking(#{args[0]})"
      end
    end
    #  Blocking version of {::Vertx::FileSystem#copy_recursive}
    # @overload copyRecursiveBlocking(from,to,recursive)
    #   @param [String] from 
    #   @param [String] to 
    #   @param [true,false] recursive 
    # @return [self]
    def copy_recursive_blocking(*args)
      if args[0].class == String && args[1].class == String && (args[2].class == TrueClass || args[2].class == FalseClass) && !block_given?
        @j_del.java_method(:copyRecursiveBlocking, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::boolean.java_class]).call(args[0],args[1],args[2])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling copy_recursive_blocking(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Create the directory represented by <code>path</code>, asynchronously.
    #  <p>
    #  The new directory will be created with permissions as specified by <code>perms</code>.
    #  <p>
    #  The permission String takes the form rwxr-x--- as specified
    #  in <a href="http://download.oracle.com/javase/7/docs/api/java/nio/file/attribute/PosixFilePermissions.html">here</a>.
    #  <p>
    #  The operation will fail if the directory already exists.
    # @overload mkdir(path,handler)
    #   @param [String] path path to the file
    #   @yield the handler that will be called on completion
    # @overload mkdir(path,perms,handler)
    #   @param [String] path path to the file
    #   @param [String] perms the permissions string
    #   @yield the handler that will be called on completion
    # @return [self]
    def mkdir(*args)
      if args[0].class == String && true && args[1] == nil
        if (block_given?)
          @j_del.java_method(:mkdir, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:mkdir, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && args[1].class == String && true
        if (block_given?)
          @j_del.java_method(:mkdir, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:mkdir, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling mkdir(#{args[0]},#{args[1]})"
      end
    end
    #  Blocking version of {::Vertx::FileSystem#lprops}
    # @overload lpropsBlocking(path)
    #   @param [String] path 
    # @return [::Vertx::FileProps]
    def lprops_blocking(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:lpropsBlocking, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::FileProps)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling lprops_blocking(#{args[0]})"
      end
    end
    #  Blocking version of 
    # 
    # @overload chownBlocking(path,user,group)
    #   @param [String] path 
    #   @param [String] user 
    #   @param [String] group 
    # @return [self]
    def chown_blocking(*args)
      if args[0].class == String && args[1].class == String && args[2].class == String && !block_given?
        @j_del.java_method(:chownBlocking, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling chown_blocking(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Change the ownership on the file represented by <code>path</code> to <code>user</code> and {code group}, asynchronously.
    # @overload chown(path,user,group,handler)
    #   @param [String] path the path to the file
    #   @param [String] user the user name, <code>null</code> will not change the user name
    #   @param [String] group the user group, <code>null</code> will not change the user group name
    #   @yield the handler that will be called on completion
    # @return [self]
    def chown(*args)
      if args[0].class == String && args[1].class == String && args[2].class == String && true
        if (block_given?)
          @j_del.java_method(:chown, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:chown, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling chown(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Blocking version of {::Vertx::FileSystem#unlink}
    # @overload unlinkBlocking(link)
    #   @param [String] link 
    # @return [self]
    def unlink_blocking(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:unlinkBlocking, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling unlink_blocking(#{args[0]})"
      end
    end
    #  Creates a new file in the directory provided by the path <code>dir</code>, using the given
    #  prefix and suffix to generate its name, asynchronously.
    #  <p>
    #  The new directory will be created with permissions as specified by <code>perms</code>.
    #  </p>
    #  The permission String takes the form rwxr-x--- as specified
    #  in <a href="http://download.oracle.com/javase/7/docs/api/java/nio/file/attribute/PosixFilePermissions.html">here</a>.
    # 
    #  <p>
    #  As with the <code>File.createTempFile</code> methods, this method is only
    #  part of a temporary-file facility.A #addShutdownHook shutdown-hook,
    #  or the deleteOnExit mechanism may be used to delete the directory automatically.
    #  </p>
    # @overload createTempFile(prefix,suffix,handler)
    #   @param [String] prefix the prefix string to be used in generating the directory's name; may be <code>null</code>
    #   @param [String] suffix the suffix string to be used in generating the file's name; may be <code>null</code>, in which case "<code>.tmp</code>" is used
    #   @yield the handler that will be called on completion
    # @overload createTempFile(prefix,suffix,perms,handler)
    #   @param [String] prefix the prefix string to be used in generating the directory's name; may be <code>null</code>
    #   @param [String] suffix the suffix string to be used in generating the file's name; may be <code>null</code>, in which case "<code>.tmp</code>" is used
    #   @param [String] perms 
    #   @yield the handler that will be called on completion
    # @overload createTempFile(dir,prefix,suffix,perms,handler)
    #   @param [String] dir the path to directory in which to create the directory
    #   @param [String] prefix the prefix string to be used in generating the directory's name; may be <code>null</code>
    #   @param [String] suffix the suffix string to be used in generating the file's name; may be <code>null</code>, in which case "<code>.tmp</code>" is used
    #   @param [String] perms the permissions string
    #   @yield the handler that will be called on completion
    # @return [self]
    def create_temp_file(*args)
      if args[0].class == String && args[1].class == String && true && args[2] == nil && args[3] == nil
        if (block_given?)
          @j_del.java_method(:createTempFile, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createTempFile, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && args[1].class == String && args[2].class == String && true && args[3] == nil
        if (block_given?)
          @j_del.java_method(:createTempFile, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createTempFile, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && args[1].class == String && args[2].class == String && args[3].class == String && true
        if (block_given?)
          @j_del.java_method(:createTempFile, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],args[3],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createTempFile, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],args[3],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_temp_file(#{args[0]},#{args[1]},#{args[2]},#{args[3]})"
      end
    end
    #  Blocking version of {::Vertx::FileSystem#open}
    # @overload openBlocking(path,options)
    #   @param [String] path 
    #   @param [Hash{String => Object}] options 
    # @return [::Vertx::AsyncFile]
    def open_blocking(*args)
      if args[0].class == String && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:openBlocking, [Java::java.lang.String.java_class,Java::IoVertxCoreFile::OpenOptions.java_class]).call(args[0],Java::IoVertxCoreFile::OpenOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::Vertx::AsyncFile)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling open_blocking(#{args[0]},#{args[1]})"
      end
    end
    #  Obtain properties for the link represented by <code>path</code>, asynchronously.
    #  <p>
    #  The link will not be followed.
    # @overload lprops(path,handler)
    #   @param [String] path the path to the file
    #   @yield the handler that will be called on completion
    # @return [self]
    def lprops(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:lprops, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::FileProps) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:lprops, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::FileProps) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::FileProps.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling lprops(#{args[0]})"
      end
    end
    #  Obtain properties for the file represented by <code>path</code>, asynchronously.
    #  <p>
    #  If the file is a link, the link will be followed.
    # @overload props(path,handler)
    #   @param [String] path the path to the file
    #   @yield the handler that will be called on completion
    # @return [self]
    def props(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:props, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::FileProps) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:props, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::FileProps) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::FileProps.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling props(#{args[0]})"
      end
    end
    #  Blocking version of {::Vertx::FileSystem#mkdir}
    # @overload mkdirBlocking(path)
    #   @param [String] path 
    # @overload mkdirBlocking(path,perms)
    #   @param [String] path 
    #   @param [String] perms 
    # @return [self]
    def mkdir_blocking(*args)
      if args[0].class == String && !block_given? && args[1] == nil
        @j_del.java_method(:mkdirBlocking, [Java::java.lang.String.java_class]).call(args[0])
        return self
      elsif args[0].class == String && args[1].class == String && !block_given?
        @j_del.java_method(:mkdirBlocking, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling mkdir_blocking(#{args[0]},#{args[1]})"
      end
    end
    #  Returns properties of the file-system being used by the specified <code>path</code>, asynchronously.
    # @overload fsProps(path,handler)
    #   @param [String] path path to anywhere on the filesystem
    #   @yield the handler that will be called on completion
    # @return [self]
    def fs_props(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:fsProps, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::FileSystemProps) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:fsProps, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::FileSystemProps) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::FileSystemProps.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling fs_props(#{args[0]})"
      end
    end
    #  Create the directory represented by <code>path</code> and any non existent parents, asynchronously.
    #  <p>
    #  The new directory will be created with permissions as specified by <code>perms</code>.
    #  <p>
    #  The permission String takes the form rwxr-x--- as specified
    #  in <a href="http://download.oracle.com/javase/7/docs/api/java/nio/file/attribute/PosixFilePermissions.html">here</a>.
    #  <p>
    #  The operation will fail if the <code>path</code> already exists but is not a directory.
    # @overload mkdirs(path,handler)
    #   @param [String] path path to the file
    #   @yield the handler that will be called on completion
    # @overload mkdirs(path,perms,handler)
    #   @param [String] path path to the file
    #   @param [String] perms the permissions string
    #   @yield the handler that will be called on completion
    # @return [self]
    def mkdirs(*args)
      if args[0].class == String && true && args[1] == nil
        if (block_given?)
          @j_del.java_method(:mkdirs, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:mkdirs, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && args[1].class == String && true
        if (block_given?)
          @j_del.java_method(:mkdirs, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:mkdirs, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling mkdirs(#{args[0]},#{args[1]})"
      end
    end
    #  Blocking version of {::Vertx::FileSystem#read_dir}
    # @overload readDirBlocking(path)
    #   @param [String] path 
    # @overload readDirBlocking(path,filter)
    #   @param [String] path 
    #   @param [String] filter 
    # @return [Array<String>]
    def read_dir_blocking(*args)
      if args[0].class == String && !block_given? && args[1] == nil
        return @j_del.java_method(:readDirBlocking, [Java::java.lang.String.java_class]).call(args[0]).to_a.map { |elt| elt }
      elsif args[0].class == String && args[1].class == String && !block_given?
        return @j_del.java_method(:readDirBlocking, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1]).to_a.map { |elt| elt }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling read_dir_blocking(#{args[0]},#{args[1]})"
      end
    end
    #  Blocking version of {::Vertx::FileSystem#link}
    # @overload symlinkBlocking(link,existing)
    #   @param [String] link 
    #   @param [String] existing 
    # @return [self]
    def symlink_blocking(*args)
      if args[0].class == String && args[1].class == String && !block_given?
        @j_del.java_method(:symlinkBlocking, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling symlink_blocking(#{args[0]},#{args[1]})"
      end
    end
    #  Blocking version of {::Vertx::FileSystem#move}
    # @overload moveBlocking(from,to)
    #   @param [String] from 
    #   @param [String] to 
    # @return [self]
    def move_blocking(*args)
      if args[0].class == String && args[1].class == String && !block_given?
        @j_del.java_method(:moveBlocking, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling move_blocking(#{args[0]},#{args[1]})"
      end
    end
    #  Blocking version of {::Vertx::FileSystem#create_temp_file}
    # @overload createTempFileBlocking(prefix,suffix)
    #   @param [String] prefix 
    #   @param [String] suffix 
    # @overload createTempFileBlocking(prefix,suffix,perms)
    #   @param [String] prefix 
    #   @param [String] suffix 
    #   @param [String] perms 
    # @overload createTempFileBlocking(dir,prefix,suffix,perms)
    #   @param [String] dir 
    #   @param [String] prefix 
    #   @param [String] suffix 
    #   @param [String] perms 
    # @return [String]
    def create_temp_file_blocking(*args)
      if args[0].class == String && args[1].class == String && !block_given? && args[2] == nil && args[3] == nil
        return @j_del.java_method(:createTempFileBlocking, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
      elsif args[0].class == String && args[1].class == String && args[2].class == String && !block_given? && args[3] == nil
        return @j_del.java_method(:createTempFileBlocking, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2])
      elsif args[0].class == String && args[1].class == String && args[2].class == String && args[3].class == String && !block_given?
        return @j_del.java_method(:createTempFileBlocking, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2],args[3])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_temp_file_blocking(#{args[0]},#{args[1]},#{args[2]},#{args[3]})"
      end
    end
    #  Create a hard link on the file system from <code>link</code> to <code>existing</code>, asynchronously.
    # @overload link(link,existing,handler)
    #   @param [String] link the link
    #   @param [String] existing the link destination
    #   @yield the handler that will be called on completion
    # @return [self]
    def link(*args)
      if args[0].class == String && args[1].class == String && true
        if (block_given?)
          @j_del.java_method(:link, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:link, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling link(#{args[0]},#{args[1]})"
      end
    end
    #  Returns the path representing the file that the symbolic link specified by <code>link</code> points to, asynchronously.
    # @overload readSymlink(link,handler)
    #   @param [String] link the link
    #   @yield the handler that will be called on completion
    # @return [self]
    def read_symlink(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:readSymlink, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:readSymlink, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling read_symlink(#{args[0]})"
      end
    end
    #  Deletes the file represented by the specified <code>path</code>, asynchronously.
    # @overload delete(path,handler)
    #   @param [String] path path to the file
    #   @yield the handler that will be called on completion
    # @return [self]
    def delete(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:delete, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:delete, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling delete(#{args[0]})"
      end
    end
    #  Blocking version of {::Vertx::FileSystem#read_file}
    # @overload readFileBlocking(path)
    #   @param [String] path 
    # @return [::Vertx::Buffer]
    def read_file_blocking(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:readFileBlocking, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::Buffer)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling read_file_blocking(#{args[0]})"
      end
    end
    #  Blocking version of {::Vertx::FileSystem#chmod_recursive}
    # @overload chmodRecursiveBlocking(path,perms,dirPerms)
    #   @param [String] path 
    #   @param [String] perms 
    #   @param [String] dirPerms 
    # @return [self]
    def chmod_recursive_blocking(*args)
      if args[0].class == String && args[1].class == String && args[2].class == String && !block_given?
        @j_del.java_method(:chmodRecursiveBlocking, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling chmod_recursive_blocking(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Create a symbolic link on the file system from <code>link</code> to <code>existing</code>, asynchronously.
    # @overload symlink(link,existing,handler)
    #   @param [String] link the link
    #   @param [String] existing the link destination
    #   @yield the handler that will be called on completion
    # @return [self]
    def symlink(*args)
      if args[0].class == String && args[1].class == String && true
        if (block_given?)
          @j_del.java_method(:symlink, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:symlink, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling symlink(#{args[0]},#{args[1]})"
      end
    end
    #  Copy a file from the path <code>from</code> to path <code>to</code>, asynchronously.
    #  <p>
    #  If <code>recursive</code> is <code>true</code> and <code>from</code> represents a directory, then the directory and its contents
    #  will be copied recursively to the destination <code>to</code>.
    #  <p>
    #  The copy will fail if the destination if the destination already exists.
    # @overload copyRecursive(from,to,recursive,handler)
    #   @param [String] from the path to copy from
    #   @param [String] to the path to copy to
    #   @param [true,false] recursive 
    #   @yield the handler that will be called on completion
    # @return [self]
    def copy_recursive(*args)
      if args[0].class == String && args[1].class == String && (args[2].class == TrueClass || args[2].class == FalseClass) && true
        if (block_given?)
          @j_del.java_method(:copyRecursive, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:copyRecursive, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling copy_recursive(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Change the permissions on the file represented by <code>path</code> to <code>perms</code>, asynchronously.
    #  <p>
    #  The permission String takes the form rwxr-x--- as
    #  specified <a href="http://download.oracle.com/javase/7/docs/api/java/nio/file/attribute/PosixFilePermissions.html">here</a>.
    # @overload chmod(path,perms,handler)
    #   @param [String] path the path to the file
    #   @param [String] perms the permissions string
    #   @yield the handler that will be called on completion
    # @return [self]
    def chmod(*args)
      if args[0].class == String && args[1].class == String && true
        if (block_given?)
          @j_del.java_method(:chmod, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:chmod, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling chmod(#{args[0]},#{args[1]})"
      end
    end
    #  Blocking version of {::Vertx::FileSystem#chmod(String, String, Handler)}
    # @overload chmodBlocking(path,perms)
    #   @param [String] path 
    #   @param [String] perms 
    # @return [self]
    def chmod_blocking(*args)
      if args[0].class == String && args[1].class == String && !block_given?
        @j_del.java_method(:chmodBlocking, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling chmod_blocking(#{args[0]},#{args[1]})"
      end
    end
    #  Deletes the file represented by the specified <code>path</code>, asynchronously.
    #  <p>
    #  If the path represents a directory and <code>recursive = true</code> then the directory and its contents will be
    #  deleted recursively.
    # @overload deleteRecursive(path,recursive,handler)
    #   @param [String] path path to the file
    #   @param [true,false] recursive delete recursively?
    #   @yield the handler that will be called on completion
    # @return [self]
    def delete_recursive(*args)
      if args[0].class == String && (args[1].class == TrueClass || args[1].class == FalseClass) && true
        if (block_given?)
          @j_del.java_method(:deleteRecursive, [Java::java.lang.String.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:deleteRecursive, [Java::java.lang.String.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling delete_recursive(#{args[0]},#{args[1]})"
      end
    end
    #  Copy a file from the path <code>from</code> to path <code>to</code>, asynchronously.
    # @overload copy(from,to,handler)
    #   @param [String] from the path to copy from
    #   @param [String] to the path to copy to
    #   @yield the handler that will be called on completion
    # @overload copy(from,to,options,handler)
    #   @param [String] from the path to copy from
    #   @param [String] to the path to copy to
    #   @param [Hash{String => Object}] options options describing how the file should be copied
    #   @yield the handler that will be called on completion
    # @return [self]
    def copy(*args)
      if args[0].class == String && args[1].class == String && true && args[2] == nil
        if (block_given?)
          @j_del.java_method(:copy, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:copy, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && args[1].class == String && args[2].class == Hash && true
        if (block_given?)
          @j_del.java_method(:copy, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreFile::CopyOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],Java::IoVertxCoreFile::CopyOptions.new(::Vertx::Util::Utils.to_json_object(args[2])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:copy, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreFile::CopyOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],Java::IoVertxCoreFile::CopyOptions.new(::Vertx::Util::Utils.to_json_object(args[2])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling copy(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Creates the file, and writes the specified <code>Buffer data</code> to the file represented by the path <code>path</code>,
    #  asynchronously.
    # @overload writeFile(path,data,handler)
    #   @param [String] path path to the file
    #   @param [::Vertx::Buffer] data 
    #   @yield the handler that will be called on completion
    # @return [self]
    def write_file(*args)
      if args[0].class == String && args[1].class.method_defined?(:j_del) && true
        if (block_given?)
          @j_del.java_method(:writeFile, [Java::java.lang.String.java_class,Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:writeFile, [Java::java.lang.String.java_class,Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write_file(#{args[0]},#{args[1]})"
      end
    end
    #  Change the permissions on the file represented by <code>path</code> to <code>perms</code>, asynchronously.<p>
    #  The permission String takes the form rwxr-x--- as
    #  specified in {<a href="http://download.oracle.com/javase/7/docs/api/java/nio/file/attribute/PosixFilePermissions.html">here</a>}.
    #  <p>
    #  If the file is directory then all contents will also have their permissions changed recursively. Any directory permissions will
    #  be set to <code>dirPerms</code>, whilst any normal file permissions will be set to <code>perms</code>.
    # @overload chmodRecursive(path,perms,dirPerms,handler)
    #   @param [String] path the path to the file
    #   @param [String] perms the permissions string
    #   @param [String] dirPerms the directory permissions
    #   @yield the handler that will be called on completion
    # @return [self]
    def chmod_recursive(*args)
      if args[0].class == String && args[1].class == String && args[2].class == String && true
        if (block_given?)
          @j_del.java_method(:chmodRecursive, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:chmodRecursive, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling chmod_recursive(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Blocking version of {::Vertx::FileSystem#copy}
    # @overload copyBlocking(from,to)
    #   @param [String] from 
    #   @param [String] to 
    # @return [self]
    def copy_blocking(*args)
      if args[0].class == String && args[1].class == String && !block_given?
        @j_del.java_method(:copyBlocking, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling copy_blocking(#{args[0]},#{args[1]})"
      end
    end
    #  Blocking version of {::Vertx::FileSystem#delete_recursive}
    # @overload deleteRecursiveBlocking(path,recursive)
    #   @param [String] path 
    #   @param [true,false] recursive 
    # @return [self]
    def delete_recursive_blocking(*args)
      if args[0].class == String && (args[1].class == TrueClass || args[1].class == FalseClass) && !block_given?
        @j_del.java_method(:deleteRecursiveBlocking, [Java::java.lang.String.java_class,Java::boolean.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling delete_recursive_blocking(#{args[0]},#{args[1]})"
      end
    end
    #  Move a file from the path <code>from</code> to path <code>to</code>, asynchronously.
    # @overload move(from,to,handler)
    #   @param [String] from the path to copy from
    #   @param [String] to the path to copy to
    #   @yield the handler that will be called on completion
    # @overload move(from,to,options,handler)
    #   @param [String] from the path to copy from
    #   @param [String] to the path to copy to
    #   @param [Hash{String => Object}] options options describing how the file should be copied
    #   @yield the handler that will be called on completion
    # @return [self]
    def move(*args)
      if args[0].class == String && args[1].class == String && true && args[2] == nil
        if (block_given?)
          @j_del.java_method(:move, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:move, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && args[1].class == String && args[2].class == Hash && true
        if (block_given?)
          @j_del.java_method(:move, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreFile::CopyOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],Java::IoVertxCoreFile::CopyOptions.new(::Vertx::Util::Utils.to_json_object(args[2])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:move, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreFile::CopyOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],Java::IoVertxCoreFile::CopyOptions.new(::Vertx::Util::Utils.to_json_object(args[2])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling move(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Creates a new directory in the directory provided by the path <code>path</code>, using the given
    #  prefix to generate its name, asynchronously.
    #  <p>
    #  The new directory will be created with permissions as specified by <code>perms</code>.
    #  </p>
    #  The permission String takes the form rwxr-x--- as specified
    #  in <a href="http://download.oracle.com/javase/7/docs/api/java/nio/file/attribute/PosixFilePermissions.html">here</a>.
    # 
    #  <p>
    #  As with the <code>File.createTempFile</code> methods, this method is only
    #  part of a temporary-file facility.A #addShutdownHook shutdown-hook,
    #  or the deleteOnExit mechanism may be used to delete the directory automatically.
    #  </p>
    # @overload createTempDirectory(prefix,handler)
    #   @param [String] prefix the prefix string to be used in generating the directory's name; may be <code>null</code>
    #   @yield the handler that will be called on completion
    # @overload createTempDirectory(prefix,perms,handler)
    #   @param [String] prefix the prefix string to be used in generating the directory's name; may be <code>null</code>
    #   @param [String] perms the permissions string
    #   @yield the handler that will be called on completion
    # @overload createTempDirectory(dir,prefix,perms,handler)
    #   @param [String] dir the path to directory in which to create the directory
    #   @param [String] prefix the prefix string to be used in generating the directory's name; may be <code>null</code>
    #   @param [String] perms the permissions string
    #   @yield the handler that will be called on completion
    # @return [self]
    def create_temp_directory(*args)
      if args[0].class == String && true && args[1] == nil && args[2] == nil
        if (block_given?)
          @j_del.java_method(:createTempDirectory, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createTempDirectory, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && args[1].class == String && true && args[2] == nil
        if (block_given?)
          @j_del.java_method(:createTempDirectory, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createTempDirectory, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && args[1].class == String && args[2].class == String && true
        if (block_given?)
          @j_del.java_method(:createTempDirectory, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createTempDirectory, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_temp_directory(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Blocking version of {::Vertx::FileSystem#create_file}
    # @overload createFileBlocking(path)
    #   @param [String] path 
    # @overload createFileBlocking(path,perms)
    #   @param [String] path 
    #   @param [String] perms 
    # @return [self]
    def create_file_blocking(*args)
      if args[0].class == String && !block_given? && args[1] == nil
        @j_del.java_method(:createFileBlocking, [Java::java.lang.String.java_class]).call(args[0])
        return self
      elsif args[0].class == String && args[1].class == String && !block_given?
        @j_del.java_method(:createFileBlocking, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_file_blocking(#{args[0]},#{args[1]})"
      end
    end
    #  Blocking version of {::Vertx::FileSystem#write_file}
    # @overload writeFileBlocking(path,data)
    #   @param [String] path 
    #   @param [::Vertx::Buffer] data 
    # @return [self]
    def write_file_blocking(*args)
      if args[0].class == String && args[1].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:writeFileBlocking, [Java::java.lang.String.java_class,Java::IoVertxCoreBuffer::Buffer.java_class]).call(args[0],args[1].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write_file_blocking(#{args[0]},#{args[1]})"
      end
    end
    #  Blocking version of {::Vertx::FileSystem#link}
    # @overload linkBlocking(link,existing)
    #   @param [String] link 
    #   @param [String] existing 
    # @return [self]
    def link_blocking(*args)
      if args[0].class == String && args[1].class == String && !block_given?
        @j_del.java_method(:linkBlocking, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling link_blocking(#{args[0]},#{args[1]})"
      end
    end
    #  Blocking version of {::Vertx::FileSystem#truncate}
    # @overload truncateBlocking(path,len)
    #   @param [String] path 
    #   @param [Fixnum] len 
    # @return [self]
    def truncate_blocking(*args)
      if args[0].class == String && args[1].class == Fixnum && !block_given?
        @j_del.java_method(:truncateBlocking, [Java::java.lang.String.java_class,Java::long.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling truncate_blocking(#{args[0]},#{args[1]})"
      end
    end
    #  Blocking version of {::Vertx::FileSystem#mkdirs}
    # @overload mkdirsBlocking(path)
    #   @param [String] path 
    # @overload mkdirsBlocking(path,perms)
    #   @param [String] path 
    #   @param [String] perms 
    # @return [self]
    def mkdirs_blocking(*args)
      if args[0].class == String && !block_given? && args[1] == nil
        @j_del.java_method(:mkdirsBlocking, [Java::java.lang.String.java_class]).call(args[0])
        return self
      elsif args[0].class == String && args[1].class == String && !block_given?
        @j_del.java_method(:mkdirsBlocking, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling mkdirs_blocking(#{args[0]},#{args[1]})"
      end
    end
    #  Blocking version of {::Vertx::FileSystem#props}
    # @overload propsBlocking(path)
    #   @param [String] path 
    # @return [::Vertx::FileProps]
    def props_blocking(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:propsBlocking, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::FileProps)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling props_blocking(#{args[0]})"
      end
    end
    #  Read the contents of the directory specified by <code>path</code>, asynchronously.
    #  <p>
    #  The parameter <code>filter</code> is a regular expression. If <code>filter</code> is specified then only the paths that
    #  match  @{filter}will be returned.
    #  <p>
    #  The result is an array of String representing the paths of the files inside the directory.
    # @overload readDir(path,handler)
    #   @param [String] path path to the file
    #   @yield the handler that will be called on completion
    # @overload readDir(path,filter,handler)
    #   @param [String] path path to the directory
    #   @param [String] filter the filter expression
    #   @yield the handler that will be called on completion
    # @return [self]
    def read_dir(*args)
      if args[0].class == String && true && args[1] == nil
        if (block_given?)
          @j_del.java_method(:readDir, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:readDir, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && args[1].class == String && true
        if (block_given?)
          @j_del.java_method(:readDir, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:readDir, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling read_dir(#{args[0]},#{args[1]})"
      end
    end
    #  Unlinks the link on the file system represented by the path <code>link</code>, asynchronously.
    # @overload unlink(link,handler)
    #   @param [String] link the link
    #   @yield the handler that will be called on completion
    # @return [self]
    def unlink(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:unlink, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:unlink, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling unlink(#{args[0]})"
      end
    end
    #  Blocking version of {::Vertx::FileSystem#exists}
    # @overload existsBlocking(path)
    #   @param [String] path 
    # @return [true,false]
    def exists_blocking?(*args)
      if args[0].class == String && !block_given?
        return @j_del.java_method(:existsBlocking, [Java::java.lang.String.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exists_blocking?(#{args[0]})"
      end
    end
    #  Reads the entire file as represented by the path <code>path</code> as a , asynchronously.
    #  <p>
    #  Do not use this method to read very large files or you risk running out of available RAM.
    # @overload readFile(path,handler)
    #   @param [String] path path to the file
    #   @yield the handler that will be called on completion
    # @return [self]
    def read_file(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:readFile, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Buffer) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:readFile, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Buffer) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Buffer.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling read_file(#{args[0]})"
      end
    end
    #  Determines whether the file as specified by the path <code>path</code> exists, asynchronously.
    # @overload exists(path,handler)
    #   @param [String] path path to the file
    #   @yield the handler that will be called on completion
    # @return [self]
    def exists(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:exists, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:exists, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exists(#{args[0]})"
      end
    end
    #  Open the file represented by <code>path</code>, asynchronously.
    #  <p>
    #  The file is opened for both reading and writing. If the file does not already exist it will be created.
    # @overload open(path,options,handler)
    #   @param [String] path path to the file
    #   @param [Hash{String => Object}] options options describing how the file should be opened
    #   @yield 
    # @return [self]
    def open(*args)
      if args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:open, [Java::java.lang.String.java_class,Java::IoVertxCoreFile::OpenOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxCoreFile::OpenOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::AsyncFile) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:open, [Java::java.lang.String.java_class,Java::IoVertxCoreFile::OpenOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxCoreFile::OpenOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::AsyncFile) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::AsyncFile.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling open(#{args[0]},#{args[1]})"
      end
    end
  end
end
