require 'vertx/http_client_request'
require 'vertx/http_client_response'
require 'vertx/measured'
require 'vertx/multi_map'
require 'vertx/web_socket'
require 'vertx/http_connection'
require 'vertx/future'
require 'vertx/socket_address'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.http.HttpClient
module Vertx
  #  An asynchronous HTTP client.
  #  <p>
  #  It allows you to make requests to HTTP servers, and a single client can make requests to any server.
  #  <p>
  #  It also allows you to open WebSockets to servers.
  #  <p>
  #  The client can also pool HTTP connections.
  #  <p>
  #  For pooling to occur, keep-alive must be true on the {Hash{String => Object}} (default is true).
  #  In this case connections will be pooled and re-used if there are pending HTTP requests waiting to get a connection,
  #  otherwise they will be closed.
  #  <p>
  #  This gives the benefits of keep alive when the client is loaded but means we don't keep connections hanging around
  #  unnecessarily when there would be no benefits anyway.
  #  <p>
  #  The client also supports pipe-lining of requests. Pipe-lining means another request is sent on the same connection
  #  before the response from the preceding one has returned. Pipe-lining is not appropriate for all requests.
  #  <p>
  #  To enable pipe-lining, it must be enabled on the {Hash{String => Object}} (default is false).
  #  <p>
  #  When pipe-lining is enabled the connection will be automatically closed when all in-flight responses have returned
  #  and there are no outstanding pending requests to write.
  #  <p>
  #  The client is designed to be reused between requests.
  class HttpClient
    include ::Vertx::Measured
    # @private
    # @param j_del [::Vertx::HttpClient] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::HttpClient] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == HttpClient
    end
    def @@j_api_type.wrap(obj)
      HttpClient.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreHttp::HttpClient.java_class
    end
    #  Whether the metrics are enabled for this measured object
    # @overload isMetricsEnabled()
    # @return [true,false] <code>true</code> if metrics are enabled
    def metrics_enabled?
      if !block_given?
        return @j_del.java_method(:isMetricsEnabled, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling metrics_enabled?()"
      end
    end
    #  Like {::Vertx::HttpClient#request} using the <code>serverAddress</code> parameter to connect to the
    #  server instead of the <code>absoluteURI</code> parameter.
    #  <p>
    #  The request host header will still be created from the <code>host</code> and <code>port</code> parameters.
    #  <p>
    #  Use  to connect to a unix domain socket server.
    # @overload request(method,options)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method
    #   @param [Hash{String => Object}] options the request options
    # @overload request(method,requestURI)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method
    #   @param [String] requestURI the relative URI
    # @overload request(method,serverAddress,options)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method 
    #   @param [::Vertx::SocketAddress] serverAddress 
    #   @param [Hash{String => Object}] options 
    # @overload request(method,host,requestURI)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload request(method,options,responseHandler)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method
    #   @param [Hash{String => Object}] options the request options
    #   @yield 
    # @overload request(method,requestURI,responseHandler)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload request(method,port,host,requestURI)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload request(method,serverAddress,options,responseHandler)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method 
    #   @param [::Vertx::SocketAddress] serverAddress 
    #   @param [Hash{String => Object}] options 
    #   @yield 
    # @overload request(method,host,requestURI,responseHandler)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload request(method,serverAddress,port,host,requestURI)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method 
    #   @param [::Vertx::SocketAddress] serverAddress 
    #   @param [Fixnum] port 
    #   @param [String] host 
    #   @param [String] requestURI 
    # @overload request(method,port,host,requestURI,responseHandler)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload request(method,serverAddress,port,host,requestURI,responseHandler)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method 
    #   @param [::Vertx::SocketAddress] serverAddress 
    #   @param [Fixnum] port 
    #   @param [String] host 
    #   @param [String] requestURI 
    #   @yield 
    # @return [::Vertx::HttpClientRequest]
    def request(*args)
      if args[0].class == Symbol && args[1].class == Hash && !block_given? && args[2] == nil && args[3] == nil && args[4] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::IoVertxCoreHttp::RequestOptions.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::Vertx::HttpClientRequest)
      elsif args[0].class == Symbol && args[1].class == String && !block_given? && args[2] == nil && args[3] == nil && args[4] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::java.lang.String.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1]),::Vertx::HttpClientRequest)
      elsif args[0].class == Symbol && args[1].class.method_defined?(:j_del) && args[2].class == Hash && !block_given? && args[3] == nil && args[4] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::IoVertxCoreNet::SocketAddress.java_class,Java::IoVertxCoreHttp::RequestOptions.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1].j_del,Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(args[2]))),::Vertx::HttpClientRequest)
      elsif args[0].class == Symbol && args[1].class == String && args[2].class == String && !block_given? && args[3] == nil && args[4] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1],args[2]),::Vertx::HttpClientRequest)
      elsif args[0].class == Symbol && args[1].class == Hash && true && args[2] == nil && args[3] == nil && args[4] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      elsif args[0].class == Symbol && args[1].class == String && true && args[2] == nil && args[3] == nil && args[4] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      elsif args[0].class == Symbol && args[1].class == Fixnum && args[2].class == String && args[3].class == String && !block_given? && args[4] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1],args[2],args[3]),::Vertx::HttpClientRequest)
      elsif args[0].class == Symbol && args[1].class.method_defined?(:j_del) && args[2].class == Hash && true && args[3] == nil && args[4] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::IoVertxCoreNet::SocketAddress.java_class,Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1].j_del,Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(args[2])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      elsif args[0].class == Symbol && args[1].class == String && args[2].class == String && true && args[3] == nil && args[4] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      elsif args[0].class == Symbol && args[1].class.method_defined?(:j_del) && args[2].class == Fixnum && args[3].class == String && args[4].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::IoVertxCoreNet::SocketAddress.java_class,Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1].j_del,args[2],args[3],args[4]),::Vertx::HttpClientRequest)
      elsif args[0].class == Symbol && args[1].class == Fixnum && args[2].class == String && args[3].class == String && true && args[4] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1],args[2],args[3],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      elsif args[0].class == Symbol && args[1].class.method_defined?(:j_del) && args[2].class == Fixnum && args[3].class == String && args[4].class == String && true
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::IoVertxCoreNet::SocketAddress.java_class,Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1].j_del,args[2],args[3],args[4],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling request(#{args[0]},#{args[1]},#{args[2]},#{args[3]},#{args[4]})"
      end
    end
    #  Create an HTTP PUT request to send to the server using an absolute URI, specifying a response handler to receive
    #  the response
    # @overload putAbs(absoluteURI)
    #   @param [String] absoluteURI the absolute URI
    # @overload putAbs(absoluteURI,responseHandler)
    #   @param [String] absoluteURI the absolute URI
    #   @yield the response handler
    # @return [::Vertx::HttpClientRequest] an HTTP client request object
    def put_abs(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:putAbs, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::HttpClientRequest)
      elsif args[0].class == String && true
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:putAbs, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling put_abs(#{args[0]})"
      end
    end
    #  Sends an HTTP GET request to the server at the specified host and port, specifying a response handler to receive
    #  the response
    # @overload getNow(options,responseHandler)
    #   @param [Hash{String => Object}] options the request options
    #   @yield the response handler
    # @overload getNow(requestURI,responseHandler)
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload getNow(host,requestURI,responseHandler)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload getNow(port,host,requestURI,responseHandler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @return [self]
    def get_now(*args)
      if args[0].class == Hash && true && args[1] == nil && args[2] == nil
        if (block_given?)
          @j_del.java_method(:getNow, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:getNow, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::HttpClientResponse.j_api_type)
        end
      elsif args[0].class == String && true && args[1] == nil && args[2] == nil
        if (block_given?)
          @j_del.java_method(:getNow, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:getNow, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::HttpClientResponse.j_api_type)
        end
      elsif args[0].class == String && args[1].class == String && true && args[2] == nil
        if (block_given?)
          @j_del.java_method(:getNow, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:getNow, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::HttpClientResponse.j_api_type)
        end
      elsif args[0].class == Fixnum && args[1].class == String && args[2].class == String && true
        if (block_given?)
          @j_del.java_method(:getNow, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:getNow, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::HttpClientResponse.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_now(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Connect a WebSocket with the specified absolute url, with the specified headers, using
    #  the specified version of WebSockets, and the specified websocket sub protocols.
    # @overload webSocketAbs(url,headers,version,subProtocols,handler)
    #   @param [String] url the absolute url
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [:V00,:V07,:V08,:V13] version the websocket version
    #   @param [Array<String>] subProtocols the subprotocols to use
    #   @yield handler that will be called if websocket connection fails
    # @return [void]
    def web_socket_abs(*args)
      if args[0].class == String && args[1].class.method_defined?(:j_del) && args[2].class == Symbol && args[3].class == Array && true
        if (block_given?)
          return @j_del.java_method(:webSocketAbs, [Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(args[2].to_s),args[3].map { |element| element },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::WebSocket) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:webSocketAbs, [Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(args[2].to_s),args[3].map { |element| element },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::WebSocket) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::WebSocket.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling web_socket_abs(#{args[0]},#{args[1]},#{args[2]},#{args[3]})"
      end
    end
    #  Create an HTTP DELETE request to send to the server at the specified host and port, specifying a response handler to receive
    #  the response
    # @overload delete(options)
    #   @param [Hash{String => Object}] options the request options
    # @overload delete(requestURI)
    #   @param [String] requestURI the relative URI
    # @overload delete(host,requestURI)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload delete(options,responseHandler)
    #   @param [Hash{String => Object}] options the request options
    #   @yield the response handler
    # @overload delete(requestURI,responseHandler)
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload delete(port,host,requestURI)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload delete(host,requestURI,responseHandler)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload delete(port,host,requestURI,responseHandler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @return [::Vertx::HttpClientRequest] an HTTP client request object
    def delete(*args)
      if args[0].class == Hash && !block_given? && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:delete, [Java::IoVertxCoreHttp::RequestOptions.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(args[0]))),::Vertx::HttpClientRequest)
      elsif args[0].class == String && !block_given? && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:delete, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::HttpClientRequest)
      elsif args[0].class == String && args[1].class == String && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:delete, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1]),::Vertx::HttpClientRequest)
      elsif args[0].class == Hash && true && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:delete, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      elsif args[0].class == String && true && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:delete, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      elsif args[0].class == Fixnum && args[1].class == String && args[2].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:delete, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2]),::Vertx::HttpClientRequest)
      elsif args[0].class == String && args[1].class == String && true && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:delete, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      elsif args[0].class == Fixnum && args[1].class == String && args[2].class == String && true
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:delete, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling delete(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Create an HTTP PUT request to send to the server at the specified host and port, specifying a response handler to receive
    #  the response
    # @overload put(options)
    #   @param [Hash{String => Object}] options the request options
    # @overload put(requestURI)
    #   @param [String] requestURI the relative URI
    # @overload put(host,requestURI)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload put(options,responseHandler)
    #   @param [Hash{String => Object}] options the request options
    #   @yield the response handler
    # @overload put(requestURI,responseHandler)
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload put(port,host,requestURI)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload put(host,requestURI,responseHandler)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload put(port,host,requestURI,responseHandler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @return [::Vertx::HttpClientRequest] an HTTP client request object
    def put(*args)
      if args[0].class == Hash && !block_given? && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:put, [Java::IoVertxCoreHttp::RequestOptions.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(args[0]))),::Vertx::HttpClientRequest)
      elsif args[0].class == String && !block_given? && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:put, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::HttpClientRequest)
      elsif args[0].class == String && args[1].class == String && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:put, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1]),::Vertx::HttpClientRequest)
      elsif args[0].class == Hash && true && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:put, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      elsif args[0].class == String && true && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:put, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      elsif args[0].class == Fixnum && args[1].class == String && args[2].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:put, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2]),::Vertx::HttpClientRequest)
      elsif args[0].class == String && args[1].class == String && true && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:put, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      elsif args[0].class == Fixnum && args[1].class == String && args[2].class == String && true
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:put, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling put(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Create an HTTP HEAD request to send to the server at the specified host and port, specifying a response handler to receive
    #  the response
    # @overload head(options)
    #   @param [Hash{String => Object}] options the request options
    # @overload head(requestURI)
    #   @param [String] requestURI the relative URI
    # @overload head(host,requestURI)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload head(options,responseHandler)
    #   @param [Hash{String => Object}] options the request options
    #   @yield the response handler
    # @overload head(requestURI,responseHandler)
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload head(port,host,requestURI)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload head(host,requestURI,responseHandler)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload head(port,host,requestURI,responseHandler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @return [::Vertx::HttpClientRequest] an HTTP client request object
    def head(*args)
      if args[0].class == Hash && !block_given? && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:head, [Java::IoVertxCoreHttp::RequestOptions.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(args[0]))),::Vertx::HttpClientRequest)
      elsif args[0].class == String && !block_given? && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:head, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::HttpClientRequest)
      elsif args[0].class == String && args[1].class == String && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:head, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1]),::Vertx::HttpClientRequest)
      elsif args[0].class == Hash && true && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:head, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      elsif args[0].class == String && true && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:head, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      elsif args[0].class == Fixnum && args[1].class == String && args[2].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:head, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2]),::Vertx::HttpClientRequest)
      elsif args[0].class == String && args[1].class == String && true && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:head, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      elsif args[0].class == Fixnum && args[1].class == String && args[2].class == String && true
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:head, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling head(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Connect a WebSocket to the specified port, host and relative request URI
    # @overload webSocket(requestURI,handler)
    #   @param [String] requestURI the relative URI
    #   @yield handler that will be called with the websocket when connected
    # @overload webSocket(options,handler)
    #   @param [Hash{String => Object}] options the request options
    #   @yield 
    # @overload webSocket(host,requestURI,handler)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield handler that will be called with the websocket when connected
    # @overload webSocket(port,host,requestURI,handler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield handler that will be called with the websocket when connected
    # @return [void]
    def web_socket(*args)
      if args[0].class == String && true && args[1] == nil && args[2] == nil
        if (block_given?)
          return @j_del.java_method(:webSocket, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::WebSocket) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:webSocket, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::WebSocket) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::WebSocket.j_api_type)
        end
      elsif args[0].class == Hash && true && args[1] == nil && args[2] == nil
        if (block_given?)
          return @j_del.java_method(:webSocket, [Java::IoVertxCoreHttp::WebSocketConnectOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::WebSocketConnectOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::WebSocket) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:webSocket, [Java::IoVertxCoreHttp::WebSocketConnectOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::WebSocketConnectOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::WebSocket) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::WebSocket.j_api_type)
        end
      elsif args[0].class == String && args[1].class == String && true && args[2] == nil
        if (block_given?)
          return @j_del.java_method(:webSocket, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::WebSocket) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:webSocket, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::WebSocket) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::WebSocket.j_api_type)
        end
      elsif args[0].class == Fixnum && args[1].class == String && args[2].class == String && true
        if (block_given?)
          return @j_del.java_method(:webSocket, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::WebSocket) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:webSocket, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::WebSocket) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::WebSocket.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling web_socket(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Sends an HTTP HEAD request to the server at the specified host and port, specifying a response handler to receive
    #  the response
    # @overload headNow(options,responseHandler)
    #   @param [Hash{String => Object}] options the request options
    #   @yield the response handler
    # @overload headNow(requestURI,responseHandler)
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload headNow(host,requestURI,responseHandler)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload headNow(port,host,requestURI,responseHandler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @return [self]
    def head_now(*args)
      if args[0].class == Hash && true && args[1] == nil && args[2] == nil
        if (block_given?)
          @j_del.java_method(:headNow, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:headNow, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::HttpClientResponse.j_api_type)
        end
      elsif args[0].class == String && true && args[1] == nil && args[2] == nil
        if (block_given?)
          @j_del.java_method(:headNow, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:headNow, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::HttpClientResponse.j_api_type)
        end
      elsif args[0].class == String && args[1].class == String && true && args[2] == nil
        if (block_given?)
          @j_del.java_method(:headNow, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:headNow, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::HttpClientResponse.j_api_type)
        end
      elsif args[0].class == Fixnum && args[1].class == String && args[2].class == String && true
        if (block_given?)
          @j_del.java_method(:headNow, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:headNow, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::HttpClientResponse.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling head_now(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Sends an HTTP OPTIONS request to the server at the specified host and port, specifying a response handler to receive
    #  the response
    # @overload optionsNow(options,responseHandler)
    #   @param [Hash{String => Object}] options the request options
    #   @yield the response handler
    # @overload optionsNow(requestURI,responseHandler)
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload optionsNow(host,requestURI,responseHandler)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload optionsNow(port,host,requestURI,responseHandler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @return [self]
    def options_now(*args)
      if args[0].class == Hash && true && args[1] == nil && args[2] == nil
        if (block_given?)
          @j_del.java_method(:optionsNow, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:optionsNow, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::HttpClientResponse.j_api_type)
        end
      elsif args[0].class == String && true && args[1] == nil && args[2] == nil
        if (block_given?)
          @j_del.java_method(:optionsNow, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:optionsNow, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::HttpClientResponse.j_api_type)
        end
      elsif args[0].class == String && args[1].class == String && true && args[2] == nil
        if (block_given?)
          @j_del.java_method(:optionsNow, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:optionsNow, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::HttpClientResponse.j_api_type)
        end
      elsif args[0].class == Fixnum && args[1].class == String && args[2].class == String && true
        if (block_given?)
          @j_del.java_method(:optionsNow, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:optionsNow, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::HttpClientResponse.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling options_now(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Create an HTTP HEAD request to send to the server using an absolute URI, specifying a response handler to receive
    #  the response
    # @overload headAbs(absoluteURI)
    #   @param [String] absoluteURI the absolute URI
    # @overload headAbs(absoluteURI,responseHandler)
    #   @param [String] absoluteURI the absolute URI
    #   @yield the response handler
    # @return [::Vertx::HttpClientRequest] an HTTP client request object
    def head_abs(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:headAbs, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::HttpClientRequest)
      elsif args[0].class == String && true
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:headAbs, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling head_abs(#{args[0]})"
      end
    end
    #  Create an HTTP POST request to send to the server at the specified host and port, specifying a response handler to receive
    #  the response
    # @overload post(options)
    #   @param [Hash{String => Object}] options the request options
    # @overload post(requestURI)
    #   @param [String] requestURI the relative URI
    # @overload post(host,requestURI)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload post(options,responseHandler)
    #   @param [Hash{String => Object}] options the request options
    #   @yield the response handler
    # @overload post(requestURI,responseHandler)
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload post(port,host,requestURI)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload post(host,requestURI,responseHandler)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload post(port,host,requestURI,responseHandler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @return [::Vertx::HttpClientRequest] an HTTP client request object
    def post(*args)
      if args[0].class == Hash && !block_given? && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:post, [Java::IoVertxCoreHttp::RequestOptions.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(args[0]))),::Vertx::HttpClientRequest)
      elsif args[0].class == String && !block_given? && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:post, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::HttpClientRequest)
      elsif args[0].class == String && args[1].class == String && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:post, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1]),::Vertx::HttpClientRequest)
      elsif args[0].class == Hash && true && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:post, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      elsif args[0].class == String && true && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:post, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      elsif args[0].class == Fixnum && args[1].class == String && args[2].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:post, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2]),::Vertx::HttpClientRequest)
      elsif args[0].class == String && args[1].class == String && true && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:post, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      elsif args[0].class == Fixnum && args[1].class == String && args[2].class == String && true
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:post, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling post(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Create an HTTP GET request to send to the server using an absolute URI, specifying a response handler to receive
    #  the response
    # @overload getAbs(absoluteURI)
    #   @param [String] absoluteURI the absolute URI
    # @overload getAbs(absoluteURI,responseHandler)
    #   @param [String] absoluteURI the absolute URI
    #   @yield the response handler
    # @return [::Vertx::HttpClientRequest] an HTTP client request object
    def get_abs(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getAbs, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::HttpClientRequest)
      elsif args[0].class == String && true
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getAbs, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_abs(#{args[0]})"
      end
    end
    #  Set a connection handler for the client. This handler is called when a new connection is established.
    # @overload connectionHandler(handler)
    #   @yield 
    # @return [self]
    def connection_handler
      if true
        @j_del.java_method(:connectionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpConnection)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling connection_handler()"
      end
    end
    #  Like {::Vertx::HttpClient#request_abs} using the <code>serverAddress</code> parameter to connect to the
    #  server instead of the <code>absoluteURI</code> parameter.
    #  <p>
    #  The request host header will still be created from the <code>absoluteURI</code> parameter.
    #  <p>
    #  Use  to connect to a unix domain socket server.
    # @overload requestAbs(method,absoluteURI)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method
    #   @param [String] absoluteURI the absolute URI
    # @overload requestAbs(method,serverAddress,absoluteURI)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method 
    #   @param [::Vertx::SocketAddress] serverAddress 
    #   @param [String] absoluteURI 
    # @overload requestAbs(method,absoluteURI,responseHandler)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method
    #   @param [String] absoluteURI the absolute URI
    #   @yield the response handler
    # @overload requestAbs(method,serverAddress,absoluteURI,responseHandler)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method 
    #   @param [::Vertx::SocketAddress] serverAddress 
    #   @param [String] absoluteURI 
    #   @yield 
    # @return [::Vertx::HttpClientRequest]
    def request_abs(*args)
      if args[0].class == Symbol && args[1].class == String && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:requestAbs, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::java.lang.String.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1]),::Vertx::HttpClientRequest)
      elsif args[0].class == Symbol && args[1].class.method_defined?(:j_del) && args[2].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:requestAbs, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::IoVertxCoreNet::SocketAddress.java_class,Java::java.lang.String.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1].j_del,args[2]),::Vertx::HttpClientRequest)
      elsif args[0].class == Symbol && args[1].class == String && true && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:requestAbs, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      elsif args[0].class == Symbol && args[1].class.method_defined?(:j_del) && args[2].class == String && true
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:requestAbs, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::IoVertxCoreNet::SocketAddress.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1].j_del,args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling request_abs(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Create an HTTP GET request to send to the server at the specified host and port, specifying a response handler to receive
    #  the response
    # @overload get(options)
    #   @param [Hash{String => Object}] options the request options
    # @overload get(requestURI)
    #   @param [String] requestURI the relative URI
    # @overload get(host,requestURI)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload get(options,responseHandler)
    #   @param [Hash{String => Object}] options the request options
    #   @yield the response handler
    # @overload get(requestURI,responseHandler)
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload get(port,host,requestURI)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload get(host,requestURI,responseHandler)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload get(port,host,requestURI,responseHandler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @return [::Vertx::HttpClientRequest] an HTTP client request object
    def get(*args)
      if args[0].class == Hash && !block_given? && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:get, [Java::IoVertxCoreHttp::RequestOptions.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(args[0]))),::Vertx::HttpClientRequest)
      elsif args[0].class == String && !block_given? && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:get, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::HttpClientRequest)
      elsif args[0].class == String && args[1].class == String && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:get, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1]),::Vertx::HttpClientRequest)
      elsif args[0].class == Hash && true && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:get, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      elsif args[0].class == String && true && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:get, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      elsif args[0].class == Fixnum && args[1].class == String && args[2].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:get, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2]),::Vertx::HttpClientRequest)
      elsif args[0].class == String && args[1].class == String && true && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:get, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      elsif args[0].class == Fixnum && args[1].class == String && args[2].class == String && true
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:get, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Create an HTTP OPTIONS request to send to the server using an absolute URI, specifying a response handler to receive
    #  the response
    # @overload optionsAbs(absoluteURI)
    #   @param [String] absoluteURI the absolute URI
    # @overload optionsAbs(absoluteURI,responseHandler)
    #   @param [String] absoluteURI the absolute URI
    #   @yield the response handler
    # @return [::Vertx::HttpClientRequest] an HTTP client request object
    def options_abs(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:optionsAbs, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::HttpClientRequest)
      elsif args[0].class == String && true
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:optionsAbs, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling options_abs(#{args[0]})"
      end
    end
    #  Create an HTTP OPTIONS request to send to the server at the specified host and port, specifying a response handler to receive
    #  the response
    # @overload options(options)
    #   @param [Hash{String => Object}] options the request options
    # @overload options(requestURI)
    #   @param [String] requestURI the relative URI
    # @overload options(host,requestURI)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload options(options,responseHandler)
    #   @param [Hash{String => Object}] options the request options
    #   @yield the response handler
    # @overload options(requestURI,responseHandler)
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload options(port,host,requestURI)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload options(host,requestURI,responseHandler)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload options(port,host,requestURI,responseHandler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @return [::Vertx::HttpClientRequest] an HTTP client request object
    def options(*args)
      if args[0].class == Hash && !block_given? && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:options, [Java::IoVertxCoreHttp::RequestOptions.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(args[0]))),::Vertx::HttpClientRequest)
      elsif args[0].class == String && !block_given? && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:options, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::HttpClientRequest)
      elsif args[0].class == String && args[1].class == String && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:options, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1]),::Vertx::HttpClientRequest)
      elsif args[0].class == Hash && true && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:options, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      elsif args[0].class == String && true && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:options, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      elsif args[0].class == Fixnum && args[1].class == String && args[2].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:options, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2]),::Vertx::HttpClientRequest)
      elsif args[0].class == String && args[1].class == String && true && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:options, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      elsif args[0].class == Fixnum && args[1].class == String && args[2].class == String && true
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:options, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling options(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Create an HTTP DELETE request to send to the server using an absolute URI, specifying a response handler to receive
    #  the response
    # @overload deleteAbs(absoluteURI)
    #   @param [String] absoluteURI the absolute URI
    # @overload deleteAbs(absoluteURI,responseHandler)
    #   @param [String] absoluteURI the absolute URI
    #   @yield the response handler
    # @return [::Vertx::HttpClientRequest] an HTTP client request object
    def delete_abs(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:deleteAbs, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::HttpClientRequest)
      elsif args[0].class == String && true
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:deleteAbs, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling delete_abs(#{args[0]})"
      end
    end
    #  Set a redirect handler for the http client.
    #  <p>
    #  The redirect handler is called when a <code>3xx</code> response is received and the request is configured to
    #  follow redirects with {::Vertx::HttpClientRequest#set_follow_redirects}.
    #  <p>
    #  The redirect handler is passed the {::Vertx::HttpClientResponse}, it can return an {::Vertx::HttpClientRequest} or <code>null</code>.
    #  <ul>
    #    <li>when null is returned, the original response is processed by the original request response handler</li>
    #    <li>when a new <code>Future<HttpClientRequest></code> is returned, the client will send this new request</li>
    #  </ul>
    #  The new request will get a copy of the previous request headers unless headers are set. In this case,
    #  the client assumes that the redirect handler exclusively managers the headers of the new request.
    #  <p>
    #  The handler must return a <code>Future<HttpClientRequest></code> unsent so the client can further configure it and send it.
    # @overload redirectHandler(handler)
    #   @yield the new redirect handler
    # @return [self]
    def redirect_handler(*args)
      if block_given? && args[0] == nil
        @j_del.java_method(:redirectHandler, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)).j_del unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling redirect_handler(#{args[0]})"
      end
    end
    #  Create an HTTP POST request to send to the server using an absolute URI, specifying a response handler to receive
    #  the response
    # @overload postAbs(absoluteURI)
    #   @param [String] absoluteURI the absolute URI
    # @overload postAbs(absoluteURI,responseHandler)
    #   @param [String] absoluteURI the absolute URI
    #   @yield the response handler
    # @return [::Vertx::HttpClientRequest] an HTTP client request object
    def post_abs(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:postAbs, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::HttpClientRequest)
      elsif args[0].class == String && true
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:postAbs, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise),::Vertx::HttpClientRequest)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling post_abs(#{args[0]})"
      end
    end
    #  Close the client. Closing will close down any pooled connections.
    #  Clients should always be closed after use.
    # @overload close()
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
  end
end
