require 'vertx/pipe'
require 'vertx/buffer'
require 'vertx/write_stream'
require 'vertx/read_stream'
require 'vertx/future'
require 'vertx/json_event'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.parsetools.JsonParser
module Vertx
  #  A parser class which allows to incrementally parse json elements and emit json parse events instead of parsing a json
  #  element fully. This parser is convenient for parsing large json structures.
  #  <p/>
  #  The parser also parses concatenated json streams or line delimited json streams.
  #  <p/>
  #  The parser can also parse entire object or array when it is convenient, for instance a very large array
  #  of small objects can be parsed efficiently by handling array <i>start</i>/<i>end</i> and <i>object</i>
  #  events.
  #  <p/>
  #  Whenever the parser fails to parse or process the stream, the {::Vertx::JsonParser#exception_handler} is called with
  #  the cause of the failure and the current handling stops. After such event, the parser should not handle data
  #  anymore.
  class JsonParser
    include ::Vertx::ReadStream
    # @private
    # @param j_del [::Vertx::JsonParser] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::JsonParser] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == JsonParser
    end
    def @@j_api_type.wrap(obj)
      JsonParser.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreParsetools::JsonParser.java_class
    end
    # @overload resume()
    # @return [self]
    def resume
      if !block_given?
        @j_del.java_method(:resume, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resume()"
      end
    end
    # @overload handler(handler)
    #   @yield 
    # @return [self]
    def handler
      if true
        @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::JsonEvent)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handler()"
      end
    end
    #  Something has happened, so handle it.
    # @overload handle(event)
    #   @param [::Vertx::Buffer] event the event to handle
    # @return [void]
    def handle(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxCoreBuffer::Buffer.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handle(#{args[0]})"
      end
    end
    #  Create a new <code>JsonParser</code> instance.
    # @overload newParser()
    # @overload newParser(stream)
    #   @param [::Vertx::ReadStream] stream 
    # @return [::Vertx::JsonParser]
    def self.new_parser(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreParsetools::JsonParser.java_method(:newParser, []).call(),::Vertx::JsonParser)
      elsif args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreParsetools::JsonParser.java_method(:newParser, [Java::IoVertxCoreStreams::ReadStream.java_class]).call(args[0].j_del),::Vertx::JsonParser)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling new_parser(#{args[0]})"
      end
    end
    # @overload pause()
    # @return [self]
    def pause
      if !block_given?
        @j_del.java_method(:pause, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pause()"
      end
    end
    #  Flip the parser to emit a stream of events for each new json array.
    # @overload arrayEventMode()
    # @return [self]
    def array_event_mode
      if !block_given?
        @j_del.java_method(:arrayEventMode, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling array_event_mode()"
      end
    end
    #  Flip the parser to emit a single value event for each new json object.
    #  </p>
    #  Json object currently streamed won't be affected.
    # @overload objectValueMode()
    # @return [self]
    def object_value_mode
      if !block_given?
        @j_del.java_method(:objectValueMode, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling object_value_mode()"
      end
    end
    #  Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
    #  <p>
    #  Elements emitted by this stream will be written to the write stream until this stream ends or fails.
    #  <p>
    #  Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
    #  called with the result.
    # @overload pipeTo(dst,handler)
    #   @param [::Vertx::WriteStream] dst the destination write stream
    #   @yield 
    # @return [void]
    def pipe_to(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pipe_to(#{args[0]})"
      end
    end
    # @overload endHandler(endHandler)
    #   @yield 
    # @return [self]
    def end_handler
      if true
        @j_del.java_method(:endHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling end_handler()"
      end
    end
    # @overload fetch(amount)
    #   @param [Fixnum] amount 
    # @return [self]
    def fetch(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:fetch, [Java::long.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling fetch(#{args[0]})"
      end
    end
    #  Flip the parser to emit a stream of events for each new json object.
    # @overload objectEventMode()
    # @return [self]
    def object_event_mode
      if !block_given?
        @j_del.java_method(:objectEventMode, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling object_event_mode()"
      end
    end
    #  End the stream, this must be called after all the json stream has been processed.
    # @overload end()
    # @return [void]
    def end
      if !block_given?
        return @j_del.java_method(:end, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling end()"
      end
    end
    #  Pause this stream and return a  to transfer the elements of this stream to a destination .
    #  <p/>
    #  The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
    # @overload pipe()
    # @return [::Vertx::Pipe] a pipe
    def pipe
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:pipe, []).call(),::Vertx::Pipe,::Vertx::JsonEvent.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pipe()"
      end
    end
    #  Flip the parser to emit a single value event for each new json array.
    #  </p>
    #  Json array currently streamed won't be affected.
    # @overload arrayValueMode()
    # @return [self]
    def array_value_mode
      if !block_given?
        @j_del.java_method(:arrayValueMode, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling array_value_mode()"
      end
    end
    # @overload exceptionHandler(handler)
    #   @yield 
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exception_handler()"
      end
    end
    #  Handle a <code>Buffer</code>, pretty much like calling {Proc#handle}.
    # @overload write(buffer)
    #   @param [::Vertx::Buffer] buffer 
    # @return [self]
    def write(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:write, [Java::IoVertxCoreBuffer::Buffer.java_class]).call(args[0].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write(#{args[0]})"
      end
    end
  end
end
