require 'vertx/measured'
require 'vertx/read_stream'
require 'vertx/future'
require 'vertx/net_socket'
require 'vertx/socket_address'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.net.NetServer
module Vertx
  #  Represents a TCP server
  class NetServer
    include ::Vertx::Measured
    # @private
    # @param j_del [::Vertx::NetServer] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::NetServer] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == NetServer
    end
    def @@j_api_type.wrap(obj)
      NetServer.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreNet::NetServer.java_class
    end
    #  Whether the metrics are enabled for this measured object
    # @overload isMetricsEnabled()
    # @return [true,false] <code>true</code> if metrics are enabled
    def metrics_enabled?
      if !block_given?
        return @j_del.java_method(:isMetricsEnabled, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling metrics_enabled?()"
      end
    end
    #  The actual port the server is listening on. This is useful if you bound the server specifying 0 as port number
    #  signifying an ephemeral port
    # @overload actualPort()
    # @return [Fixnum] the actual port the server is listening on.
    def actual_port
      if !block_given?
        return @j_del.java_method(:actualPort, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling actual_port()"
      end
    end
    #  Supply a connect handler for this server. The server can only have at most one connect handler at any one time.
    #  As the server accepts TCP or SSL connections it creates an instance of {::Vertx::NetSocket} and passes it to the
    #  connect handler.
    # @overload connectHandler(handler)
    #   @yield 
    # @return [::Vertx::NetServer] a reference to this, so the API can be used fluently
    def connect_handler
      if true
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:connectHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::NetSocket)) unless !block_given? })),::Vertx::NetServer)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling connect_handler()"
      end
    end
    #  Return the connect stream for this server. The server can only have at most one handler at any one time.
    #  As the server accepts TCP or SSL connections it creates an instance of {::Vertx::NetSocket} and passes it to the
    #  connect stream .
    # @overload connectStream()
    # @return [::Vertx::ReadStream] the connect stream
    def connect_stream
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:connectStream, []).call(),::Vertx::ReadStreamImpl,::Vertx::NetSocket.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling connect_stream()"
      end
    end
    #  Like {::Vertx::NetServer#close} but supplying a handler that will be notified when close is complete.
    # @overload close(completionHandler)
    #   @yield the handler
    # @return [void]
    def close
      if true
        if (block_given?)
          return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Like {::Vertx::NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
    # @overload listen(listenHandler)
    #   @yield handler that will be notified when listening or failed
    # @overload listen(port,listenHandler)
    #   @param [Fixnum] port the port to listen on
    #   @yield handler that will be notified when listening or failed
    # @overload listen(localAddress,listenHandler)
    #   @param [::Vertx::SocketAddress] localAddress the local address to listen on
    #   @yield handler that will be notified when listening or failed
    # @overload listen(port,host,listenHandler)
    #   @param [Fixnum] port the port to listen on
    #   @param [String] host the host to listen on
    #   @yield handler that will be notified when listening or failed
    # @return [self]
    def listen(*args)
      if true && args[0] == nil && args[1] == nil
        if (block_given?)
          @j_del.java_method(:listen, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::NetServer) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:listen, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::NetServer) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::NetServer.j_api_type)
        end
      elsif args[0].class == Fixnum && true && args[1] == nil
        if (block_given?)
          @j_del.java_method(:listen, [Java::int.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::NetServer) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:listen, [Java::int.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::NetServer) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::NetServer.j_api_type)
        end
      elsif args[0].class.method_defined?(:j_del) && true && args[1] == nil
        if (block_given?)
          @j_del.java_method(:listen, [Java::IoVertxCoreNet::SocketAddress.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::NetServer) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:listen, [Java::IoVertxCoreNet::SocketAddress.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::NetServer) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::NetServer.j_api_type)
        end
      elsif args[0].class == Fixnum && args[1].class == String && true
        if (block_given?)
          @j_del.java_method(:listen, [Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::NetServer) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:listen, [Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::NetServer) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::NetServer.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling listen(#{args[0]},#{args[1]})"
      end
    end
  end
end
