require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.net.SocketAddress
module Vertx
  #  The address of a socket, an inet socket address or a domain socket address.
  #  <p/>
  #  Use {::Vertx::SocketAddress#inet_socket_address} to create an inet socket address and {::Vertx::SocketAddress#domain_socket_address}
  #  to create a domain socket address
  class SocketAddress
    # @private
    # @param j_del [::Vertx::SocketAddress] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::SocketAddress] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == SocketAddress
    end
    def @@j_api_type.wrap(obj)
      SocketAddress.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreNet::SocketAddress.java_class
    end
    # @overload path()
    # @return [String] the address path or <code>null</code> for a inet socket
    def path
      if !block_given?
        return @j_del.java_method(:path, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling path()"
      end
    end
    # @overload port()
    # @return [Fixnum] the address port or <code>-1</code> for a domain socket
    def port
      if !block_given?
        return @j_del.java_method(:port, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling port()"
      end
    end
    # @overload host()
    # @return [String] the address host or <code>null</code> for a domain socket
    def host
      if !block_given?
        return @j_del.java_method(:host, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling host()"
      end
    end
    #  Create a inet socket address, <code>host</code> must be non <code>null</code> and <code>port</code> must be between <code>0</code>
    #  and <code>65536</code>.
    # @overload inetSocketAddress(port,host)
    #   @param [Fixnum] port the address port
    #   @param [String] host the address host
    # @return [::Vertx::SocketAddress] the created socket address
    def self.inet_socket_address(*args)
      if args[0].class == Fixnum && args[1].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreNet::SocketAddress.java_method(:inetSocketAddress, [Java::int.java_class,Java::java.lang.String.java_class]).call(args[0],args[1]),::Vertx::SocketAddress)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling inet_socket_address(#{args[0]},#{args[1]})"
      end
    end
    #  Create a domain socket address.
    # @overload domainSocketAddress(path)
    #   @param [String] path the address path
    # @return [::Vertx::SocketAddress] the created socket address
    def self.domain_socket_address(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreNet::SocketAddress.java_method(:domainSocketAddress, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::SocketAddress)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling domain_socket_address(#{args[0]})"
      end
    end
  end
end
