require 'vertx/pipe'
require 'vertx/web_socket_base'
require 'vertx/buffer'
require 'vertx/write_stream'
require 'vertx/multi_map'
require 'vertx/future'
require 'vertx/web_socket_frame'
require 'vertx/socket_address'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.http.WebSocket
module Vertx
  #  Represents a client-side WebSocket.
  class WebSocket
    include ::Vertx::WebSocketBase
    # @private
    # @param j_del [::Vertx::WebSocket] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::WebSocket] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == WebSocket
    end
    def @@j_api_type.wrap(obj)
      WebSocket.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreHttp::WebSocket.java_class
    end
    # @overload handler(handler)
    #   @yield 
    # @return [self]
    def handler
      if true
        @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Buffer)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handler()"
      end
    end
    #  When a <code>WebSocket</code> is created it automatically registers an event handler with the event bus - the ID of that
    #  handler is given by this method.
    #  <p>
    #  Given this ID, a different event loop can send a binary frame to that event handler using the event bus and
    #  that buffer will be received by this instance in its own event loop and written to the underlying connection. This
    #  allows you to write data to other WebSockets which are owned by different event loops.
    # @overload binaryHandlerID()
    # @return [String] the binary handler id
    def binary_handler_id
      if !block_given?
        return @j_del.java_method(:binaryHandlerID, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling binary_handler_id()"
      end
    end
    #  Returns the status code received when the WebSocket was closed by the other side, otherwise <code>null</code>.
    # @overload closeStatusCode()
    # @return [Fixnum]
    def close_status_code
      if !block_given?
        return @j_del.java_method(:closeStatusCode, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close_status_code()"
      end
    end
    #  Set a text message handler on the connection. This handler will be called similar to the
    #  , but the buffer will be converted to a String first
    # @overload textMessageHandler(handler)
    #   @yield the handler
    # @return [self]
    def text_message_handler
      if true
        @j_del.java_method(:textMessageHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling text_message_handler()"
      end
    end
    # @overload writeFinalBinaryFrame(data,handler)
    #   @param [::Vertx::Buffer] data 
    #   @yield 
    # @return [self]
    def write_final_binary_frame(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          @j_del.java_method(:writeFinalBinaryFrame, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:writeFinalBinaryFrame, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write_final_binary_frame(#{args[0]})"
      end
    end
    #  This will return <code>true</code> if there are more bytes in the write queue than the value set using {::Vertx::WebSocket#set_write_queue_max_size}
    # @overload writeQueueFull()
    # @return [true,false] true if write queue is full
    def write_queue_full?
      if !block_given?
        return @j_del.java_method(:writeQueueFull, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write_queue_full?()"
      end
    end
    #  When a <code>WebSocket</code> is created it automatically registers an event handler with the eventbus, the ID of that
    #  handler is given by <code>textHandlerID</code>.
    #  <p>
    #  Given this ID, a different event loop can send a text frame to that event handler using the event bus and
    #  that buffer will be received by this instance in its own event loop and written to the underlying connection. This
    #  allows you to write data to other WebSockets which are owned by different event loops.
    # @overload textHandlerID()
    # @return [String]
    def text_handler_id
      if !block_given?
        return @j_del.java_method(:textHandlerID, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling text_handler_id()"
      end
    end
    # @overload setWriteQueueMaxSize(maxSize)
    #   @param [Fixnum] maxSize 
    # @return [self]
    def set_write_queue_max_size(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:setWriteQueueMaxSize, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_write_queue_max_size(#{args[0]})"
      end
    end
    # @overload writeTextMessage(text,handler)
    #   @param [String] text 
    #   @yield 
    # @return [self]
    def write_text_message(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:writeTextMessage, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:writeTextMessage, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write_text_message(#{args[0]})"
      end
    end
    #  Set a binary message handler on the connection. This handler serves a similar purpose to {::Vertx::WebSocket#handler}
    #  except that if a message comes into the socket in multiple frames, the data from the frames will be aggregated
    #  into a single buffer before calling the handler (using {::Vertx::WebSocketFrame#is_final} to find the boundaries).
    # @overload binaryMessageHandler(handler)
    #   @yield the handler
    # @return [self]
    def binary_message_handler
      if true
        @j_del.java_method(:binaryMessageHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Buffer)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling binary_message_handler()"
      end
    end
    #  Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
    #  <p>
    #  Elements emitted by this stream will be written to the write stream until this stream ends or fails.
    #  <p>
    #  Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
    #  called with the result.
    # @overload pipeTo(dst,handler)
    #   @param [::Vertx::WriteStream] dst the destination write stream
    #   @yield 
    # @return [void]
    def pipe_to(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pipe_to(#{args[0]})"
      end
    end
    # @overload drainHandler(handler)
    #   @yield 
    # @return [self]
    def drain_handler
      if true
        @j_del.java_method(:drainHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling drain_handler()"
      end
    end
    #  Set a pong frame handler on the connection.  This handler will be invoked every time a pong frame is received
    #  on the server, and can be used by both clients and servers since the RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a> and <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> do not
    #  specify whether the client or server sends a ping.
    #  <p>
    #  Pong frames may be at most 125 bytes (octets).
    #  <p>
    #  There is no ping handler since ping frames should immediately be responded to with a pong frame with identical content
    #  <p>
    #  Pong frames may be received unsolicited.
    # @overload pongHandler(handler)
    #   @yield the handler
    # @return [self]
    def pong_handler
      if true
        @j_del.java_method(:pongHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Buffer)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pong_handler()"
      end
    end
    # @overload writeBinaryMessage(data,handler)
    #   @param [::Vertx::Buffer] data 
    #   @yield 
    # @return [self]
    def write_binary_message(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          @j_del.java_method(:writeBinaryMessage, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:writeBinaryMessage, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write_binary_message(#{args[0]})"
      end
    end
    #  Writes a ping frame to the connection. This will be written in a single frame. Ping frames may be at most 125 bytes (octets).
    #  <p>
    #  This method should not be used to write application data and should only be used for implementing a keep alive or
    #  to ensure the client is still responsive, see RFC 6455 Section <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
    #  <p>
    #  There is no handler for ping frames because RFC 6455  clearly
    #  states that the only response to a ping frame is a pong frame with identical contents.
    # @overload writePing(data,handler)
    #   @param [::Vertx::Buffer] data the data to write, may be at most 125 bytes
    #   @yield called when the ping frame has been successfully written
    # @return [self]
    def write_ping(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          @j_del.java_method(:writePing, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:writePing, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write_ping(#{args[0]})"
      end
    end
    #  Pause this stream and return a  to transfer the elements of this stream to a destination .
    #  <p/>
    #  The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
    # @overload pipe()
    # @return [::Vertx::Pipe] a pipe
    def pipe
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:pipe, []).call(),::Vertx::Pipe,::Vertx::Buffer.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pipe()"
      end
    end
    #  Same as  but with an <code>handler</code> called when the operation completes
    # @overload end(handler)
    #   @yield 
    # @overload end(data,handler)
    #   @param [::Vertx::Buffer] data 
    #   @yield 
    # @return [void]
    def end(*args)
      if true && args[0] == nil
        if (block_given?)
          return @j_del.java_method(:end, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:end, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:end, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:end, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling end(#{args[0]})"
      end
    end
    #  Writes a pong frame to the connection. This will be written in a single frame. Pong frames may be at most 125 bytes (octets).
    #  <p>
    #  This method should not be used to write application data and should only be used for implementing a keep alive or
    #  to ensure the client is still responsive, see RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
    #  <p>
    #  There is no need to manually write a pong frame, as the server and client both handle responding to a ping from with a pong from
    #  automatically and this is exposed to users. RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> states that pongs may be sent unsolicited in order
    #  to implement a one way heartbeat.
    # @overload writePong(data,handler)
    #   @param [::Vertx::Buffer] data the data to write, may be at most 125 bytes
    #   @yield called when the pong frame has been successfully written
    # @return [self]
    def write_pong(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          @j_del.java_method(:writePong, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:writePong, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write_pong(#{args[0]})"
      end
    end
    #  Returns the reason message received when the WebSocket was closed by the other side, otherwise <code>null</code>.
    # @overload closeReason()
    # @return [String]
    def close_reason
      if !block_given?
        return @j_del.java_method(:closeReason, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close_reason()"
      end
    end
    #  Returns the WebSocket sub protocol selected by the WebSocket handshake.
    #  <p/>
    #  On the server, the value will be <code>null</code> when the handler receives the websocket callback as the
    #  handshake will not be completed yet.
    # @overload subProtocol()
    # @return [String]
    def sub_protocol
      if !block_given?
        return @j_del.java_method(:subProtocol, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling sub_protocol()"
      end
    end
    #  Same as  but with an <code>handler</code> called when the operation completes
    # @overload close(handler)
    #   @yield 
    # @overload close(statusCode,handler)
    #   @param [Fixnum] statusCode 
    #   @yield 
    # @overload close(statusCode,reason,handler)
    #   @param [Fixnum] statusCode 
    #   @param [String] reason 
    #   @yield 
    # @return [void]
    def close(*args)
      if true && args[0] == nil && args[1] == nil
        if (block_given?)
          return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == Fixnum && true && args[1] == nil
        if (block_given?)
          return @j_del.java_method(:close, [Java::short.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_short(args[0]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:close, [Java::short.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_short(args[0]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == Fixnum && args[1].class == String && true
        if (block_given?)
          return @j_del.java_method(:close, [Java::short.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_short(args[0]),args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:close, [Java::short.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_short(args[0]),args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close(#{args[0]},#{args[1]})"
      end
    end
    #  Same as  but with an <code>handler</code> called when the operation completes
    # @overload write(data,handler)
    #   @param [::Vertx::Buffer] data 
    #   @yield 
    # @return [void]
    def write(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:write, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:write, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write(#{args[0]})"
      end
    end
    # @overload remoteAddress()
    # @return [::Vertx::SocketAddress] the remote address for this socket
    def remote_address
      if !block_given?
        if @cached_remote_address != nil
          return @cached_remote_address
        end
        return @cached_remote_address = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:remoteAddress, []).call(),::Vertx::SocketAddress)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remote_address()"
      end
    end
    # @overload resume()
    # @return [self]
    def resume
      if !block_given?
        @j_del.java_method(:resume, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resume()"
      end
    end
    #   Returns the HTTP headers when the WebSocket is first obtained in the handler.
    #   <p/>
    #   The headers will be <code>null</code> on subsequent interactions.
    # @overload headers()
    # @return [::Vertx::MultiMap] the headers
    def headers
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:headers, []).call(),::Vertx::MultiMap)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling headers()"
      end
    end
    # @overload frameHandler(handler)
    #   @yield 
    # @return [self]
    def frame_handler
      if true
        @j_del.java_method(:frameHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocketFrame)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling frame_handler()"
      end
    end
    # @overload closeHandler(handler)
    #   @yield 
    # @return [self]
    def close_handler
      if true
        @j_del.java_method(:closeHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close_handler()"
      end
    end
    # @overload pause()
    # @return [self]
    def pause
      if !block_given?
        @j_del.java_method(:pause, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pause()"
      end
    end
    # @overload isClosed()
    # @return [true,false] <code>true</code> if the WebSocket is closed
    def closed?
      if !block_given?
        return @j_del.java_method(:isClosed, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling closed?()"
      end
    end
    # @overload endHandler(endHandler)
    #   @yield 
    # @return [self]
    def end_handler
      if true
        @j_del.java_method(:endHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling end_handler()"
      end
    end
    # @overload localAddress()
    # @return [::Vertx::SocketAddress] the local address for this socket
    def local_address
      if !block_given?
        if @cached_local_address != nil
          return @cached_local_address
        end
        return @cached_local_address = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:localAddress, []).call(),::Vertx::SocketAddress)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling local_address()"
      end
    end
    # @overload fetch(amount)
    #   @param [Fixnum] amount 
    # @return [self]
    def fetch(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:fetch, [Java::long.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling fetch(#{args[0]})"
      end
    end
    # @overload writeFinalTextFrame(text,handler)
    #   @param [String] text 
    #   @yield 
    # @return [self]
    def write_final_text_frame(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:writeFinalTextFrame, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:writeFinalTextFrame, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write_final_text_frame(#{args[0]})"
      end
    end
    # @overload writeFrame(frame,handler)
    #   @param [::Vertx::WebSocketFrame] frame 
    #   @yield 
    # @return [self]
    def write_frame(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          @j_del.java_method(:writeFrame, [Java::IoVertxCoreHttp::WebSocketFrame.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:writeFrame, [Java::IoVertxCoreHttp::WebSocketFrame.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write_frame(#{args[0]})"
      end
    end
    # @overload exceptionHandler(handler)
    #   @yield 
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exception_handler()"
      end
    end
    # @overload isSsl()
    # @return [true,false] true if this {::Vertx::HttpConnection} is encrypted via SSL/TLS.
    def ssl?
      if !block_given?
        return @j_del.java_method(:isSsl, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling ssl?()"
      end
    end
  end
end
