/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.maven.modules;

import io.vertx.maven.modules.RepositoryTracer;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallResult;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.artifact.SubArtifact;
import org.eclipse.aether.util.filter.DependencyFilterUtils;

public class AetherHelper {
    final RepositorySystem system = AetherHelper.createRepositorySystem();
    final DefaultRepositorySystemSession session;

    public AetherHelper(String localRepo, Writer log) {
        this.session = AetherHelper.newRepositorySystemSession(this.system, localRepo);
        if (log != null) {
            this.session.setRepositoryListener((RepositoryListener)new RepositoryTracer(new PrintWriter(log)));
        }
    }

    public AetherHelper(String localRepo) {
        this.session = AetherHelper.newRepositorySystemSession(this.system, localRepo);
    }

    public void installArtifacts(Iterable<Artifact> artifacts) throws Exception {
        for (Artifact artifact : artifacts) {
            this.installArtifact(artifact);
        }
    }

    public void installArtifact(Artifact artifact) throws Exception {
        String path = artifact.getFile().getPath();
        this.installArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), artifact.getVersion(), artifact.getFile(), new File(path.substring(0, path.length() - 3) + "pom"));
    }

    public void installArtifact(String groupId, String artifactId, String version, File artifactFile, File pomFile) throws Exception {
        int extIndex = artifactFile.getName().lastIndexOf(46);
        String ext = artifactFile.getName().substring(extIndex + 1);
        String rawName = artifactFile.getName().substring(0, extIndex);
        int classifierIdx = rawName.lastIndexOf(45);
        String classifier = "";
        if (classifierIdx != -1) {
            classifier = rawName.substring(classifierIdx + 1, rawName.length());
        }
        this.installArtifact(groupId, artifactId, ext, classifier, version, artifactFile, pomFile);
    }

    public void installArtifact(String groupId, String artifactId, String ext, String classifier, String version, File artifactFile, File pomFile) throws Exception {
        DefaultArtifact jarArtifact = new DefaultArtifact(groupId, artifactId, classifier, ext, version);
        jarArtifact = jarArtifact.setFile(artifactFile);
        SubArtifact pomArtifact = new SubArtifact((Artifact)jarArtifact, "", "pom");
        pomArtifact = pomArtifact.setFile(pomFile);
        InstallRequest installRequest = new InstallRequest();
        installRequest.addArtifact((Artifact)jarArtifact).addArtifact((Artifact)pomArtifact);
        InstallResult result = this.system.install((RepositorySystemSession)this.session, installRequest);
        if (!result.getArtifacts().contains(jarArtifact)) {
            throw new AssertionError((Object)("Could not install jar " + jarArtifact));
        }
        if (!result.getArtifacts().contains(pomArtifact)) {
            throw new AssertionError((Object)("Could not install pom " + jarArtifact));
        }
    }

    public ArtifactResult resolveArtifact(String groupId, String artifactId, String extension, String version) throws Exception {
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, extension, version);
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact((Artifact)artifact);
        request.setRepositories(Collections.emptyList());
        return this.system.resolveArtifact((RepositorySystemSession)this.session, request);
    }

    public List<Artifact> getDependencies(String groupId, String artifactId, String extension, String version) throws Exception {
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, extension, version);
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency((Artifact)artifact, ""));
        collectRequest.setRepositories(Collections.emptyList());
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, DependencyFilterUtils.classpathFilter((String[])new String[]{"compile"}));
        DependencyResult dependencyResult = this.system.resolveDependencies((RepositorySystemSession)this.session, dependencyRequest);
        ArrayList<Artifact> dependencies = new ArrayList<Artifact>();
        for (ArtifactResult artifactResult : dependencyResult.getArtifactResults()) {
            if (!artifactResult.isResolved()) {
                throw new Exception("Could not resolve artifact " + artifactResult.getRequest().getArtifact());
            }
            dependencies.add(artifactResult.getArtifact());
        }
        return dependencies;
    }

    public static DefaultRepositorySystemSession newRepositorySystemSession(RepositorySystem system, String path) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(path);
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        return session;
    }

    public static RepositorySystem createRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                exception.printStackTrace();
            }
        });
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }
}

