/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.maven.modules;

import java.io.IOException;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthFilter
implements Filter {
    final int authenticationRequiredStatus;
    final String authenticateHeader;
    final String authorizationHeader;
    final String username;
    final String password;
    final AtomicBoolean authenticated;

    public static AuthFilter proxyAuthenticator(String username, String password) {
        return new AuthFilter(407, "Proxy-Authenticate", "Proxy-Authorization", username, password);
    }

    public static AuthFilter serverAuthenticator(String username, String password) {
        return new AuthFilter(401, "WWW-Authenticate", "Authorization", username, password);
    }

    private AuthFilter(int authenticationRequiredStatus, String authenticateHeader, String authorizationHeader, String username, String password) {
        this.authenticationRequiredStatus = authenticationRequiredStatus;
        this.authenticateHeader = authenticateHeader;
        this.authorizationHeader = authorizationHeader;
        this.username = username;
        this.password = password;
        this.authenticated = new AtomicBoolean();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        String authz = req.getHeader(this.authorizationHeader);
        if (authz != null && authz.startsWith("Basic ")) {
            String secret = authz.substring(6);
            String up = new String(Base64.getDecoder().decode(secret));
            int index = up.indexOf(58);
            String username = up.substring(0, index);
            String password = up.substring(index + 1);
            if (username.equals(this.username) && password.equals(this.password)) {
                this.authenticated.set(true);
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
        }
        HttpServletResponse resp = (HttpServletResponse)servletResponse;
        resp.addHeader(this.authenticateHeader, "Basic realm=\"Jetty Authorization\"");
        resp.setStatus(this.authenticationRequiredStatus);
    }

    public void destroy() {
    }
}

