/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.maven.utils;

import io.vertx.maven.utils.FileUtils;
import io.vertx.maven.utils.LocalArtifact;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class LocalRepoBuilder {
    private static final Logger LOGGER = Logger.getLogger(LocalRepoBuilder.class.getName());
    private final File output;
    private List<LocalArtifact> artifacts = new ArrayList<LocalArtifact>();

    public LocalRepoBuilder(File output) {
        this.output = output;
    }

    public LocalRepoBuilder addArtifact(LocalArtifact artifact) {
        this.artifacts.add(artifact);
        return this;
    }

    public void build() {
        this.build(true);
    }

    public void build(boolean clean) {
        if (this.output.isDirectory() && clean) {
            LOGGER.info("Deleting " + this.output.getAbsolutePath());
            FileUtils.deleteQuietly(this.output);
            this.output.mkdirs();
        }
        this.artifacts.stream().forEach(artifact -> {
            File directory = artifact.getArtifactDirectory(this.output);
            directory.mkdirs();
            File pom = artifact.getPomFile(this.output);
            FileUtils.write(pom, artifact.toPom());
            for (Map.Entry<String, File> entry : artifact.getFiles().entrySet()) {
                if (entry.getKey().equals("MAIN")) {
                    FileUtils.copyFile(entry.getValue(), artifact.getFile(this.output));
                    continue;
                }
                FileUtils.copyFile(entry.getValue(), artifact.getFile(entry.getKey(), this.output));
            }
            LOGGER.info("The artifact " + artifact.gav() + " has been installed in the local repository");
        });
    }
}

