/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.maven.modules;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.maven.MavenVerticleFactory;
import io.vertx.maven.modules.AetherHelper;
import io.vertx.maven.modules.AuthFilter;
import io.vertx.maven.modules.UrlCollectorFilter;
import io.vertx.maven.utils.FileUtils;
import io.vertx.test.core.VertxTestBase;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.concurrent.CountDownLatch;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.jetty.proxy.ProxyServlet;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class FactoryTest
extends VertxTestBase {
    private static final String FILE_SEP = System.getProperty("file.separator");
    private List<Server> servers = new ArrayList<Server>();

    @BeforeClass
    public static void loadConstants() throws IOException {
        File file = new File("target/test-classes/constants.json");
        if (!file.exists()) {
            throw new IllegalStateException("Cannot find the constants.json file, please run Maven first");
        }
        String content = new String(Files.readAllBytes(file.toPath()));
        JsonObject node = new JsonObject(content);
        System.setProperty("version", node.getString("version"));
        System.setProperty("localRepository", node.getString("localRepository"));
    }

    @BeforeClass
    public static void clearAllRepositories() {
        File repositories = new File("target" + FILE_SEP + "repositories");
        FileUtils.delete(repositories);
    }

    public void setUp() throws Exception {
        System.clearProperty("vertx.maven.localRepo");
        System.clearProperty("vertx.maven.remoteRepos");
        System.clearProperty("vertx.maven.httpProxy");
        MavenVerticleFactory.RESOLVE_CALLED = false;
        super.setUp();
        System.setProperty("javax.net.ssl.trustStore", new File(FactoryTest.class.getResource("client-truststore.jks").toURI()).getAbsolutePath());
        System.setProperty("javax.net.ssl.trustStorePassword", "wibble");
    }

    public void tearDown() throws Exception {
        for (Server server : this.servers) {
            server.stop();
        }
        FactoryTest.assertWaitUntil(() -> MavenVerticleFactory.RESOLVE_CALLED);
        super.tearDown();
    }

    @Test
    public void testDeploy() throws Exception {
        File testRepo = this.createMyModuleRepository("testDeploy");
        this.configureRepos(testRepo, null);
        this.vertx.deployVerticle("maven:my:module:1.0::my.serviceA", this.onSuccess(res -> this.testComplete()));
        this.await();
    }

    @Test
    public void testStartsOK() throws Exception {
        File testRepo = this.createMyModuleRepository("testStartsOK");
        this.configureRepos(testRepo, null);
        this.vertx.eventBus().localConsumer("mymodule").handler(message -> {
            this.assertEquals("whatever", message.body());
            this.testComplete();
        });
        this.vertx.deployVerticle("maven:my:module:1.0::my.serviceA");
        this.await();
    }

    @Test
    public void testUseMainVerticleFromManifest() throws Exception {
        File testRepo = this.createMyModuleMainVerticleRepository("testUseMainVerticleFromManifest");
        this.configureRepos(testRepo, null);
        this.vertx.eventBus().localConsumer("mymodule").handler(message -> {
            this.assertEquals("whatever", message.body());
            this.testComplete();
        });
        this.vertx.deployVerticle("maven:my:module:1.0");
        this.await();
    }

    @Test
    public void testOtherServiceStartsOK() throws Exception {
        File testRepo = this.createMyModuleRepository("testOtherServiceStartsOK");
        this.configureRepos(testRepo, null);
        this.vertx.eventBus().localConsumer("mymodule").handler(message -> {
            this.assertEquals("whatever2", message.body());
            this.testComplete();
        });
        this.vertx.deployVerticle("maven:my:module:1.0::my.serviceB");
        this.await();
    }

    @Test
    public void testZipExtension() throws Exception {
        this.waitFor(2);
        File testRepo = this.createMyModuleZipRepository("testZipExtension");
        this.configureRepos(testRepo, null);
        this.vertx.eventBus().localConsumer("mymodule").handler(message -> {
            this.assertEquals("whateverZip", message.body());
            this.complete();
        });
        this.vertx.deployVerticle("maven:my:module:1.0::my.serviceA", this.onFailure(err -> this.vertx.deployVerticle("maven:my:module:zip:1.0::my.serviceZip", this.onSuccess(id -> this.complete()))));
        this.await();
    }

    @Test
    public void testClassifier() throws Exception {
        this.waitFor(2);
        File testRepo = this.createMyModuleClassifierRepository("testClassifier");
        this.configureRepos(testRepo, null);
        this.vertx.eventBus().localConsumer("mymodule").handler(message -> {
            this.assertEquals("whateverClassifier", message.body());
            this.complete();
        });
        this.vertx.deployVerticle("maven:my:module:1.0::my.serviceA", this.onFailure(err -> this.vertx.deployVerticle("maven:my:module:jar:the_classifier:1.0::my.serviceClassifier", this.onSuccess(id -> this.complete()))));
        this.await();
    }

    @Test
    public void testConfiguredResolveFromLocalRepository() throws Exception {
        File testRepo = this.createMyModuleRepository("testConfiguredResolveFromLocalRepository");
        File emptyRepo = Files.createTempDirectory("vertx", new FileAttribute[0]).toFile();
        emptyRepo.deleteOnExit();
        this.startRemoteServer(this.createRemoteServer(testRepo));
        this.configureRepos(testRepo, "http://localhost:8080/");
        this.vertx.deployVerticle("maven:my:module:1.0::my.serviceA", new DeploymentOptions(), this.onSuccess(id -> this.testComplete()));
        this.await();
    }

    @Test
    public void testConfiguredResolveFromRemoteRepository() throws Exception {
        File testRepo = this.createMyModuleRepository("testConfiguredResolveFromRemoteRepository");
        File emptyRepo = Files.createTempDirectory("vertx", new FileAttribute[0]).toFile();
        emptyRepo.deleteOnExit();
        this.startRemoteServer(this.createRemoteServer(testRepo));
        this.configureRepos(emptyRepo, "http://localhost:8080/");
        this.vertx.deployVerticle("maven:my:module:1.0::my.serviceA", new DeploymentOptions(), this.onSuccess(id -> this.testComplete()));
        this.await();
    }

    @Test
    @Ignore
    public void testConfiguredResolveFromSecureRemoteRepository() throws Exception {
        File testRepo = this.createMyModuleRepository("testConfiguredResolveFromSecureRemoteRepository");
        File emptyRepo = Files.createTempDirectory("vertx", new FileAttribute[0]).toFile();
        emptyRepo.deleteOnExit();
        this.startRemoteServer(this.configureTls(this.createRemoteServer(testRepo)));
        this.configureRepos(emptyRepo, "https://localhost:8443/");
        this.vertx.deployVerticle("maven:my:module:1.0::my.serviceA", new DeploymentOptions(), this.onSuccess(id -> this.testComplete()));
        this.await();
    }

    @Test
    public void testConfiguredResolveFromRemoteAuthenticatingRepository() throws Exception {
        File testRepo = this.createMyModuleRepository("testConfiguredResolveFromRemoteAuthenticatingRepository");
        File emptyRepo = Files.createTempDirectory("vertx", new FileAttribute[0]).toFile();
        emptyRepo.deleteOnExit();
        Server server = this.createRemoteServer(testRepo);
        AuthFilter filter = AuthFilter.serverAuthenticator("username_value", "password_value");
        ((ServletContextHandler)server.getHandler()).addFilter(new FilterHolder((Filter)filter), "/*", EnumSet.of(DispatcherType.REQUEST));
        server.start();
        this.servers.add(server);
        this.configureRepos(emptyRepo, "http://username_value:password_value@localhost:8080/");
        this.vertx.deployVerticle("maven:my:module:1.0::my.serviceA", new DeploymentOptions(), this.onSuccess(id -> {
            this.assertTrue(filter.authenticated.get());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    @Ignore
    public void testConfiguredResolveFromSecureRemoteAuthenticatingRepository() throws Exception {
        File testRepo = this.createMyModuleRepository("testConfiguredResolveFromSecureRemoteAuthenticatingRepository");
        File emptyRepo = Files.createTempDirectory("vertx", new FileAttribute[0]).toFile();
        emptyRepo.deleteOnExit();
        Server server = this.createRemoteServer(testRepo);
        AuthFilter filter = AuthFilter.serverAuthenticator("username_value", "password_value");
        ((ServletContextHandler)server.getHandler()).addFilter(new FilterHolder((Filter)filter), "/*", EnumSet.of(DispatcherType.REQUEST));
        this.startRemoteServer(this.configureTls(server));
        this.configureRepos(emptyRepo, "https://username_value:password_value@localhost:8443/");
        this.vertx.deployVerticle("maven:my:module:1.0::my.serviceA", new DeploymentOptions(), this.onSuccess(id -> this.testComplete()));
        this.await();
    }

    @Test
    public void testConfiguredHttpProxy() throws Exception {
        System.setProperty("vertx.maven.httpProxy", "http://localhost:8081");
        File testRepo = this.createMyModuleRepository("testConfiguredHttpProxy");
        File emptyRepo = Files.createTempDirectory("vertx", new FileAttribute[0]).toFile();
        emptyRepo.deleteOnExit();
        this.startRemoteServer(this.createRemoteServer(testRepo));
        Server server = new Server(8081);
        ServletHandler handler = new ServletHandler();
        server.setHandler((Handler)handler);
        handler.addServletWithMapping(ProxyServlet.class, "/*").setInitParameter("maxThreads", "10");
        URL expectedHost = new URL("http://localhost:8080/");
        UrlCollectorFilter urlCollector = new UrlCollectorFilter();
        handler.addFilterWithMapping(new FilterHolder((Filter)urlCollector), "/*", 0);
        server.start();
        this.servers.add(server);
        this.configureRepos(emptyRepo, "http://localhost:8080/");
        this.vertx.deployVerticle("maven:my:module:1.0::my.serviceA", new DeploymentOptions(), this.onSuccess(id -> {
            this.assertTrue("Was expecting " + urlCollector.requestedHosts + " to contain " + expectedHost, urlCollector.requestedHosts.contains(expectedHost));
            this.testComplete();
        }));
        this.await();
    }

    public void testConfiguredHttpsProxy() throws Exception {
        File testRepo = this.createMyModuleRepository("testConfiguredHttpsProxy");
        File emptyRepo = Files.createTempDirectory("vertx", new FileAttribute[0]).toFile();
        emptyRepo.deleteOnExit();
        this.startRemoteServer(this.configureTls(this.createRemoteServer(testRepo)));
        Server server = new Server(8081);
        ServletHandler handler = new ServletHandler();
        server.setHandler((Handler)handler);
        handler.addServletWithMapping(ProxyServlet.class, "/").setInitParameter("maxThreads", "10");
        UrlCollectorFilter urlCollector = new UrlCollectorFilter();
        handler.addFilterWithMapping(new FilterHolder((Filter)urlCollector), "/*", 0);
        server.start();
        this.servers.add(server);
        System.setProperty("vertx.maven.httpProxy", "http://localhost:8081");
        this.configureRepos(emptyRepo, "https://localhost:8443/");
        URL expectedHost = new URL("http://localhost:8443/");
        this.vertx.deployVerticle("maven:my:module:1.0::my.serviceA", new DeploymentOptions(), this.onSuccess(id -> {
            this.assertTrue("Was expecting " + urlCollector.requestedHosts + " to contain " + expectedHost, urlCollector.requestedHosts.contains(expectedHost));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testConfiguredAuthenticatingHttpProxy() throws Exception {
        File testRepo = this.createMyModuleRepository("testConfiguredAuthenticatingHttpProxy");
        File emptyRepo = Files.createTempDirectory("vertx", new FileAttribute[0]).toFile();
        emptyRepo.deleteOnExit();
        this.startRemoteServer(this.createRemoteServer(testRepo));
        System.setProperty("vertx.maven.httpProxy", "http://username_value:password_value@localhost:8081");
        Server server = new Server(8081);
        ServletHandler handler = new ServletHandler();
        server.setHandler((Handler)handler);
        AuthFilter filter = AuthFilter.proxyAuthenticator("username_value", "password_value");
        handler.addFilterWithMapping(new FilterHolder((Filter)filter), "/*", 0);
        handler.addServletWithMapping(ProxyServlet.class, "/*").setInitParameter("maxThreads", "10");
        URL expectedHost = new URL("http://localhost:8080/");
        UrlCollectorFilter urlCollector = new UrlCollectorFilter();
        handler.addFilterWithMapping(new FilterHolder((Filter)urlCollector), "/*", 0);
        server.start();
        this.servers.add(server);
        this.configureRepos(emptyRepo, "http://localhost:8080/");
        this.vertx.deployVerticle("maven:my:module:1.0::my.serviceA", new DeploymentOptions(), this.onSuccess(id -> {
            this.assertTrue("Was expecting " + urlCollector.requestedHosts + " to contain " + expectedHost, urlCollector.requestedHosts.contains(expectedHost));
            this.assertTrue(filter.authenticated.get());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testConfiguredHttpProxyFailure() throws Exception {
        File testRepo = this.createMyModuleRepository("testConfiguredHttpProxyFailure");
        File emptyRepo = Files.createTempDirectory("vertx", new FileAttribute[0]).toFile();
        emptyRepo.deleteOnExit();
        this.startRemoteServer(this.createRemoteServer(testRepo));
        System.setProperty("vertx.maven.httpProxy", "http://localhost:8081");
        this.configureRepos(emptyRepo, "http://localhost:8080/");
        this.vertx.deployVerticle("maven:my:module:1.0::my.serviceA", new DeploymentOptions(), this.onFailure(err -> this.testComplete()));
        this.await();
    }

    @Test
    public void testLoadSystemDependencyFromVerticleLoaderWhenAbsent() throws Exception {
        File testRepo = this.createMyModuleRepositoryWithSystemDep("testLoadSystemDependencyFromVerticleLoaderWhenAbsent");
        File emptyRepo = Files.createTempDirectory("vertx", new FileAttribute[0]).toFile();
        emptyRepo.deleteOnExit();
        this.startRemoteServer(this.createRemoteServer(testRepo));
        this.configureRepos(emptyRepo, "http://localhost:8080/");
        this.vertx.deployVerticle("maven:my:module:1.0::my.serviceA", new DeploymentOptions().setConfig(new JsonObject().put("loaded_globally", (Object)false)), this.onSuccess(id -> this.testComplete()));
        this.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadSystemDependencyFromParentLoaderWhenPresent() throws Exception {
        String localRepository = System.getProperty("localRepository");
        AetherHelper localHelper = new AetherHelper(localRepository);
        ArtifactResult result = localHelper.resolveArtifact("javax.portlet", "portlet-api", "jar", "2.0");
        URLClassLoader loader = new URLClassLoader(new URL[]{result.getArtifact().getFile().toURI().toURL()}, FactoryTest.class.getClassLoader());
        loader.loadClass("javax.portlet.Portlet");
        this.assertTrue(result.isResolved());
        ClassLoader prev = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(loader);
        try {
            File testRepo = this.createMyModuleRepositoryWithSystemDep("testLoadSystemDependencyFromParentLoaderWhenPresent");
            File emptyRepo = Files.createTempDirectory("vertx", new FileAttribute[0]).toFile();
            emptyRepo.deleteOnExit();
            this.startRemoteServer(this.createRemoteServer(testRepo));
            this.configureRepos(emptyRepo, "http://localhost:8080/");
            this.vertx.deployVerticle("maven:my:module:1.0::my.serviceA", new DeploymentOptions().setConfig(new JsonObject().put("loaded_globally", (Object)true)), this.onSuccess(id -> this.testComplete()));
            this.await();
        }
        finally {
            Thread.currentThread().setContextClassLoader(prev);
        }
    }

    @Test
    public void testLoadDependencyFromVerticleLoaderWhenAbsent() throws Exception {
        File testRepo = this.createMyModuleRepositoryWithDep("testLoadDependencyFromVerticleLoaderWhenAbsent");
        File emptyRepo = Files.createTempDirectory("vertx", new FileAttribute[0]).toFile();
        emptyRepo.deleteOnExit();
        this.startRemoteServer(this.createRemoteServer(testRepo));
        this.configureRepos(emptyRepo, "http://localhost:8080/");
        this.vertx.deployVerticle("maven:my:module:1.0::my.serviceB", new DeploymentOptions(), this.onSuccess(id -> this.testComplete()));
        this.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadDependencyFromVerticleLoaderWhenPresent() throws Exception {
        String localRepository = System.getProperty("localRepository");
        AetherHelper localHelper = new AetherHelper(localRepository);
        ArtifactResult result = localHelper.resolveArtifact("org.junit.jupiter", "junit-jupiter-api", "jar", "5.0.0");
        URLClassLoader loader = new URLClassLoader(new URL[]{result.getArtifact().getFile().toURI().toURL()}, FactoryTest.class.getClassLoader());
        Class<?> clazz = loader.loadClass("org.junit.jupiter.api.Test");
        this.assertSame(clazz.getClassLoader(), loader);
        this.assertTrue(result.isResolved());
        ClassLoader prev = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(loader);
        try {
            File testRepo = this.createMyModuleRepositoryWithDep("testLoadDependencyFromVerticleLoaderWhenPresent");
            File emptyRepo = Files.createTempDirectory("vertx", new FileAttribute[0]).toFile();
            emptyRepo.deleteOnExit();
            this.startRemoteServer(this.createRemoteServer(testRepo));
            this.configureRepos(emptyRepo, "http://localhost:8080/");
            this.vertx.deployVerticle("maven:my:module:1.0::my.serviceA", new DeploymentOptions(), this.onSuccess(id -> this.testComplete()));
            this.await();
        }
        finally {
            Thread.currentThread().setContextClassLoader(prev);
        }
    }

    @Test
    public void testSysPropsBad() throws Exception {
        System.setProperty("vertx.maven.localRepo", "qiwhdiqowd");
        System.setProperty("vertx.maven.remoteRepos", "yqgwduyqwd");
        this.vertx.close();
        try {
            this.vertx = Vertx.vertx();
            this.fail("Exception expected");
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            // empty catch block
        }
        MavenVerticleFactory.RESOLVE_CALLED = true;
    }

    @Test
    public void testUndeploy() throws Exception {
        File testRepo = this.createMyModuleRepository("testUndeploy");
        this.configureRepos(testRepo, null);
        CountDownLatch latch = new CountDownLatch(2);
        this.vertx.eventBus().localConsumer("mymoduleStopped").handler(message -> latch.countDown());
        this.vertx.deployVerticle("maven:my:module:1.0::my.serviceA", this.onSuccess(id -> this.vertx.undeploy(id, this.onSuccess(v -> latch.countDown()))));
        this.awaitLatch(latch);
    }

    @Test
    public void testInvalidServiceIDNoVersion() throws Exception {
        this.vertx.deployVerticle("maven:my:module::my.module", this.onFailure(err -> {
            this.assertTrue(err instanceof IllegalArgumentException);
            this.assertTrue(err.getMessage().startsWith("Invalid service identifier"));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testNoServiceName() throws Exception {
        File testRepo = this.createMyModuleRepository("testNoServiceName");
        this.configureRepos(testRepo, null);
        this.vertx.deployVerticle("maven:my:module:1.0", this.onFailure(err -> {
            this.assertTrue(err instanceof IllegalArgumentException);
            this.assertTrue(err.getMessage().startsWith("Invalid service identifier"));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testNonExistentModule() throws Exception {
        this.vertx.deployVerticle("maven:foo:module:1.0::my.serviceA", this.onFailure(err -> {
            this.assertTrue(err instanceof IllegalArgumentException);
            this.assertTrue(err.getMessage().startsWith("Cannot resolve artifact"));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testMissingTransitiveDependency() throws Exception {
        File repository = this.createMyModuleRepository("testMissingTransitiveDependency", new File("target" + FILE_SEP + "test-projects" + FILE_SEP + "test-module" + FILE_SEP + "target" + FILE_SEP + "mymodule.jar"), new File("target" + FILE_SEP + "test-classes" + FILE_SEP + "poms" + FILE_SEP + "test-module-with-missing-deps.xml"));
        this.configureRepos(repository, null);
        this.vertx.deployVerticle("maven:my:module:1.0", this.onFailure(err -> {
            this.assertTrue(err instanceof IllegalArgumentException);
            this.assertTrue(err.getMessage().startsWith("Cannot resolve artifact"));
            this.assertTrue(err.getMessage().contains("missing:missing"));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testNonExistentService() throws Exception {
        File testRepo = this.createMyModuleRepository("testNonExistentService");
        this.configureRepos(testRepo, null);
        this.vertx.deployVerticle("maven:my:module:1.0::not.exists", this.onFailure(err -> {
            this.assertTrue(err instanceof IllegalArgumentException);
            this.assertTrue(err.getMessage().startsWith("Cannot find service descriptor file not.exists.json on classpath"));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testBadCoords() throws Exception {
        this.vertx.deployVerticle("maven:uhiuhuih::my.wibble", this.onFailure(err -> {
            this.assertTrue(err instanceof IllegalArgumentException);
            this.assertTrue(err.getMessage().startsWith("Invalid maven coordinates:"));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testNotDeployable() throws Exception {
        this.vertx.deployVerticle("maven:io.vertx:vertx-core:2.1.2::no-service", this.onFailure(err -> {
            this.assertTrue(err instanceof IllegalArgumentException);
            this.assertTrue(err.getMessage().startsWith("Cannot find service descriptor file no-service.json"));
            this.testComplete();
        }));
        this.await();
    }

    private File createMyModuleRepository(String repoPath) throws Exception {
        return this.createMyModuleRepository(repoPath, new File("target" + FILE_SEP + "test-projects" + FILE_SEP + "test-module" + FILE_SEP + "target" + FILE_SEP + "mymodule.jar"), new File("target" + FILE_SEP + "test-classes" + FILE_SEP + "poms" + FILE_SEP + "test-module.xml"));
    }

    private File createMyModuleZipRepository(String repoPath) throws Exception {
        return this.createMyModuleRepository(repoPath, new File("target" + FILE_SEP + "test-projects" + FILE_SEP + "test-module" + FILE_SEP + "target" + FILE_SEP + "mymodule.zip"), new File("target" + FILE_SEP + "test-classes" + FILE_SEP + "poms" + FILE_SEP + "test-module.xml"));
    }

    private File createMyModuleClassifierRepository(String repoPath) throws Exception {
        return this.createMyModuleRepository(repoPath, new File("target" + FILE_SEP + "test-projects" + FILE_SEP + "test-module" + FILE_SEP + "target" + FILE_SEP + "mymodule-the_classifier.jar"), new File("target" + FILE_SEP + "test-classes" + FILE_SEP + "poms" + FILE_SEP + "test-module.xml"));
    }

    private File createMyModuleMainVerticleRepository(String repoPath) throws Exception {
        return this.createMyModuleRepository(repoPath, new File("target" + FILE_SEP + "test-projects" + FILE_SEP + "test-module-main-verticle" + FILE_SEP + "target" + FILE_SEP + "mymodule.jar"), new File("target" + FILE_SEP + "test-classes" + FILE_SEP + "poms" + FILE_SEP + "test-module-main-verticle.xml"));
    }

    private File createMyModuleRepositoryWithSystemDep(String repoPath) throws Exception {
        return this.createMyModuleRepository(repoPath, new File("target" + FILE_SEP + "test-projects" + FILE_SEP + "test-module-system-dep" + FILE_SEP + "target" + FILE_SEP + "mymodule.jar"), new File("target" + FILE_SEP + "test-classes" + FILE_SEP + "poms" + FILE_SEP + "test-module-system-dep.xml"));
    }

    private File createMyModuleRepositoryWithDep(String repoPath) throws Exception {
        return this.createMyModuleRepository(repoPath, new File("target" + FILE_SEP + "test-projects" + FILE_SEP + "test-module-dep" + FILE_SEP + "target" + FILE_SEP + "mymodule.jar"), new File("target" + FILE_SEP + "test-classes" + FILE_SEP + "poms" + FILE_SEP + "test-module-dep.xml"));
    }

    private File getWorkDir(String path) {
        return new File("target" + FILE_SEP + "repositories" + FILE_SEP + path);
    }

    private File getLogFile(String path) {
        return new File("target" + FILE_SEP + path);
    }

    private File createMyModuleRepository(String repoPath, File artifactFile, File pomFile) throws Exception {
        File testRepo = this.getWorkDir(repoPath);
        this.assertFalse("Repository " + testRepo.getAbsolutePath() + " should not exists", testRepo.exists());
        AetherHelper testHelper = new AetherHelper(testRepo.getAbsolutePath(), new FileWriter(this.getLogFile(repoPath + ".log")));
        testHelper.installArtifact("my", "module", "1.0", artifactFile, pomFile);
        String localRepository = System.getProperty("localRepository");
        AetherHelper localHelper = new AetherHelper(localRepository);
        testHelper.installArtifacts(localHelper.getDependencies("io.vertx", "vertx-dependencies", "pom", System.getProperty("version")));
        testHelper.installArtifacts(localHelper.getDependencies("io.vertx", "vertx-core", "jar", System.getProperty("version")));
        this.assertTrue(testRepo.exists());
        this.assertTrue(testRepo.isDirectory());
        return testRepo;
    }

    private void configureRepos(File localRepo, String remoteRepo) {
        System.clearProperty("vertx.maven.localRepo");
        System.clearProperty("vertx.maven.remoteRepos");
        if (localRepo != null) {
            System.setProperty("vertx.maven.localRepo", localRepo.getAbsolutePath());
        }
        if (remoteRepo != null) {
            System.setProperty("vertx.maven.remoteRepos", remoteRepo);
        }
        this.vertx.close();
        this.vertx = Vertx.vertx();
    }

    private Server configureTls(Server server) throws Exception {
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.setSecureScheme("https");
        http_config.setSecurePort(8443);
        http_config.setOutputBufferSize(32768);
        ServerConnector http = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(http_config)});
        http.setPort(8080);
        http.setIdleTimeout(30000L);
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(new File(FactoryTest.class.getResource("server-keystore.jks").toURI()).getAbsolutePath());
        sslContextFactory.setKeyStorePassword("wibble");
        HttpConfiguration https_config = new HttpConfiguration(http_config);
        https_config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        ServerConnector https = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(https_config)});
        https.setPort(8443);
        https.setIdleTimeout(500000L);
        server.setConnectors(new Connector[]{https});
        return server;
    }

    private Server createRemoteServer(File remoteRepo) throws Exception {
        Server server = new Server(8080);
        ServletContextHandler handler = new ServletContextHandler(1);
        handler.setContextPath("/");
        handler.addServlet(DefaultServlet.class, "/").setInitParameter("resourceBase", remoteRepo.getAbsolutePath());
        server.setHandler((Handler)handler);
        return server;
    }

    private void startRemoteServer(Server server) throws Exception {
        server.start();
        this.servers.add(server);
    }
}

