/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.maven.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;

public class FileUtils {
    public static void write(File file, String content) {
        try {
            Files.write(file.toPath(), content.getBytes(), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void deleteQuietly(File file) {
        try {
            Files.deleteIfExists(file.toPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void copyFile(File source, File target) {
        Path s = source.toPath();
        Path t = target.toPath();
        try {
            Files.copy(s, t, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getExtension(File file) {
        int index = file.getName().lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        return file.getName().substring(index + 1);
    }

    public static void delete(File file) {
        if (file.isFile()) {
            FileUtils.deleteQuietly(file);
        } else if (file.isDirectory()) {
            Path directory = file.toPath();
            try {
                Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

