/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttPubAckMessage;
import io.netty.handler.timeout.IdleStateHandler;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.spi.metrics.NetworkMetrics;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.mqtt.MqttEndpoint;
import io.vertx.mqtt.impl.MqttAuthImpl;
import io.vertx.mqtt.impl.MqttEndpointImpl;
import io.vertx.mqtt.impl.MqttWillImpl;
import io.vertx.mqtt.messages.MqttPublishMessage;
import io.vertx.mqtt.messages.MqttSubscribeMessage;
import io.vertx.mqtt.messages.MqttUnsubscribeMessage;

public class MqttConnection
extends ConnectionBase {
    private Handler<MqttEndpoint> endpointHandler;
    private MqttEndpointImpl endpoint;
    private final TCPMetrics metrics;

    public NetworkMetrics metrics() {
        return this.metrics;
    }

    void setEndpointHandler(Handler<MqttEndpoint> endpointHandler) {
        this.endpointHandler = endpointHandler;
    }

    public MqttConnection(VertxInternal vertx, Channel channel, ContextImpl context, TCPMetrics metrics) {
        super(vertx, channel, context);
        this.metrics = metrics;
    }

    protected void handleInterestedOpsChanged() {
    }

    synchronized void handleMessage(Object msg) {
        if (msg instanceof MqttMessage) {
            MqttMessage mqttMessage = (MqttMessage)msg;
            DecoderResult result = mqttMessage.decoderResult();
            if (result.isFailure()) {
                this.channel.pipeline().fireExceptionCaught(result.cause());
                return;
            }
            if (!result.isFinished()) {
                this.channel.pipeline().fireExceptionCaught((Throwable)new Exception("Unfinished message"));
                return;
            }
            switch (mqttMessage.fixedHeader().messageType()) {
                case CONNECT: {
                    this.handleConnect((MqttConnectMessage)msg);
                    break;
                }
                case PUBACK: {
                    MqttPubAckMessage mqttPubackMessage = (MqttPubAckMessage)mqttMessage;
                    this.handlePuback(mqttPubackMessage.variableHeader().messageId());
                    break;
                }
                case PUBREC: {
                    int pubrecMessageId = ((MqttMessageIdVariableHeader)mqttMessage.variableHeader()).messageId();
                    this.handlePubrec(pubrecMessageId);
                    break;
                }
                case PUBREL: {
                    int pubrelMessageId = ((MqttMessageIdVariableHeader)mqttMessage.variableHeader()).messageId();
                    this.handlePubrel(pubrelMessageId);
                    break;
                }
                case PUBCOMP: {
                    int pubcompMessageId = ((MqttMessageIdVariableHeader)mqttMessage.variableHeader()).messageId();
                    this.handlePubcomp(pubcompMessageId);
                    break;
                }
                case PINGREQ: {
                    this.handlePingreq();
                    break;
                }
                case DISCONNECT: {
                    this.handleDisconnect();
                    break;
                }
                default: {
                    this.channel.pipeline().fireExceptionCaught((Throwable)new Exception("Wrong message type " + msg.getClass().getName()));
                    break;
                }
            }
        } else if (msg instanceof MqttSubscribeMessage) {
            this.handleSubscribe((MqttSubscribeMessage)msg);
        } else if (msg instanceof MqttUnsubscribeMessage) {
            this.handleUnsubscribe((MqttUnsubscribeMessage)msg);
        } else if (msg instanceof MqttPublishMessage) {
            this.handlePublish((MqttPublishMessage)msg);
        } else {
            this.channel.pipeline().fireExceptionCaught((Throwable)new Exception("Wrong message type"));
        }
    }

    private void handleConnect(MqttConnectMessage msg) {
        MqttWillImpl will = new MqttWillImpl(msg.variableHeader().isWillFlag(), msg.payload().willTopic(), msg.payload().willMessage(), msg.variableHeader().willQos(), msg.variableHeader().isWillRetain());
        MqttAuthImpl auth = msg.variableHeader().hasUserName() && msg.variableHeader().hasPassword() ? new MqttAuthImpl(msg.payload().userName(), msg.payload().password()) : null;
        this.endpoint = new MqttEndpointImpl(this, msg.payload().clientIdentifier(), auth, will, msg.variableHeader().isCleanSession(), msg.variableHeader().version(), msg.variableHeader().name(), msg.variableHeader().keepAliveTimeSeconds());
        if (msg.variableHeader().keepAliveTimeSeconds() != 0) {
            int timeout = msg.variableHeader().keepAliveTimeSeconds() + msg.variableHeader().keepAliveTimeSeconds() / 2;
            this.channel.pipeline().addBefore("handler", "idle", (ChannelHandler)new IdleStateHandler(0, 0, timeout));
        }
        this.endpointHandler.handle((Object)this.endpoint);
    }

    synchronized void handleSubscribe(MqttSubscribeMessage msg) {
        if (this.endpoint != null) {
            this.endpoint.handleSubscribe(msg);
        }
    }

    synchronized void handleUnsubscribe(MqttUnsubscribeMessage msg) {
        if (this.endpoint != null) {
            this.endpoint.handleUnsubscribe(msg);
        }
    }

    synchronized void handlePublish(MqttPublishMessage msg) {
        if (this.endpoint != null) {
            this.endpoint.handlePublish(msg);
        }
    }

    synchronized void handlePuback(int pubackMessageId) {
        if (this.endpoint != null) {
            this.endpoint.handlePuback(pubackMessageId);
        }
    }

    synchronized void handlePubrec(int pubrecMessageId) {
        if (this.endpoint != null) {
            this.endpoint.handlePubrec(pubrecMessageId);
        }
    }

    synchronized void handlePubrel(int pubrelMessageId) {
        if (this.endpoint != null) {
            this.endpoint.handlePubrel(pubrelMessageId);
        }
    }

    synchronized void handlePubcomp(int pubcompMessageId) {
        if (this.endpoint != null) {
            this.endpoint.handlePubcomp(pubcompMessageId);
        }
    }

    synchronized void handlePingreq() {
        if (this.endpoint != null) {
            this.endpoint.handlePingreq();
        }
    }

    synchronized void handleDisconnect() {
        if (this.endpoint != null) {
            this.endpoint.handleDisconnect();
        }
    }

    protected synchronized void handleClosed() {
        super.handleClosed();
        if (this.endpoint != null) {
            this.endpoint.handleClosed();
        }
    }
}

