/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mysqlclient.MySQLAuthenticationPlugin;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLConnection;
import io.vertx.mysqlclient.MySQLTestBase;
import io.vertx.sqlclient.Row;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MySQLAuthenticationPluginTest
extends MySQLTestBase {
    Vertx vertx;
    MySQLConnectOptions options;

    @Before
    public void setup() {
        this.vertx = Vertx.vertx();
        this.options = new MySQLConnectOptions(MySQLTestBase.options);
    }

    @After
    public void tearDown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testDefault(TestContext ctx) {
        MySQLConnectOptions connectOptions = this.options.setAuthenticationPlugin(MySQLAuthenticationPlugin.DEFAULT);
        this.verifyConnection(ctx, connectOptions);
    }

    @Test
    public void testNative41Plugin(TestContext ctx) {
        MySQLConnectOptions connectOptions = this.options.setAuthenticationPlugin(MySQLAuthenticationPlugin.MYSQL_NATIVE_PASSWORD);
        this.verifyConnection(ctx, connectOptions);
    }

    @Test
    public void testCleartextPasswordPlugin(TestContext ctx) {
        MySQLConnectOptions connectOptions = this.options.setAuthenticationPlugin(MySQLAuthenticationPlugin.MYSQL_CLEAR_PASSWORD);
        this.verifyConnection(ctx, connectOptions);
    }

    @Test
    public void testSha256Plugin(TestContext ctx) {
        MySQLConnectOptions connectOptions = this.options.setAuthenticationPlugin(MySQLAuthenticationPlugin.SHA256_PASSWORD);
        this.verifyConnection(ctx, connectOptions);
    }

    @Test
    public void testCachingSha2Plugin(TestContext ctx) {
        MySQLConnectOptions connectOptions = this.options.setAuthenticationPlugin(MySQLAuthenticationPlugin.CACHING_SHA2_PASSWORD);
        this.verifyConnection(ctx, connectOptions);
    }

    private void verifyConnection(TestContext ctx, MySQLConnectOptions connectOptions) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)connectOptions, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT 1;").execute(ctx.asyncAssertSuccess(res -> {
            Row row = (Row)res.iterator().next();
            ctx.assertEquals((Object)1, (Object)row.size());
            ctx.assertEquals((Object)1, (Object)row.getInteger(0));
            conn.close();
        }))));
    }
}

