/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestContext;
import io.vertx.mysqlclient.MySQLBatchException;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLConnection;
import io.vertx.mysqlclient.MySQLPool;
import io.vertx.mysqlclient.MySQLTestBase;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.Tuple;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class MySQLBatchInsertExceptionTestBase
extends MySQLTestBase {
    Vertx vertx;
    MySQLConnectOptions options;

    @Before
    public void setup(TestContext ctx) {
        this.vertx = Vertx.vertx();
        this.options = this.createOptions();
        this.cleanTestTable(ctx);
    }

    protected MySQLConnectOptions createOptions() {
        return new MySQLConnectOptions(rule.options());
    }

    @After
    public void teardown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testBatchInsertExceptionConn(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options).onComplete(ctx.asyncAssertSuccess(conn -> this.testBatchInsertException(ctx, (SqlClient)conn)));
    }

    @Test
    public void testBatchInsertExceptionPool(TestContext ctx) {
        SqlClient client = MySQLPool.client((Vertx)this.vertx, (MySQLConnectOptions)this.options, (PoolOptions)new PoolOptions().setMaxSize(8));
        this.testBatchInsertException(ctx, client);
    }

    private void testBatchInsertException(TestContext ctx, SqlClient client) {
        int total = 50;
        ArrayList<Tuple> batchParams = new ArrayList<Tuple>();
        for (int i = 0; i < total; ++i) {
            int val = (i & 1) == 1 ? i - 1 : i;
            batchParams.add(Tuple.of((Object)val, (Object)String.format("val-%d", val)));
        }
        client.preparedQuery("INSERT INTO mutable(id, val) VALUES (?, ?)").executeBatch(batchParams).onComplete(ctx.asyncAssertFailure(error -> {
            ctx.assertEquals(MySQLBatchException.class, error.getClass());
            MySQLBatchException mySQLBatchException = (MySQLBatchException)error;
            ctx.assertEquals(IntStream.iterate(1, i -> i + 2).limit(total / 2).boxed().collect(Collectors.toSet()), mySQLBatchException.getIterationError().keySet());
            client.query("SELECT id, val FROM mutable").execute().onComplete(ctx.asyncAssertSuccess(res2 -> {
                ctx.assertEquals((Object)(total / 2), (Object)res2.size());
                int i = 0;
                for (Row row : res2) {
                    ctx.assertEquals((Object)2, (Object)row.size());
                    ctx.assertEquals((Object)i, (Object)row.getInteger(0));
                    ctx.assertEquals((Object)String.format("val-%d", i), (Object)row.getString(1));
                    i += 2;
                }
                client.close();
            }));
        }));
    }

    private void cleanTestTable(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("TRUNCATE TABLE mutable;").execute(ctx.asyncAssertSuccess(result -> conn.close()))));
    }
}

