/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLConnection;
import io.vertx.mysqlclient.MySQLTestBase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MySQLClientCapabilitiesTest
extends MySQLTestBase {
    private static final String PREPARE_TESTING_TABLE_DATA = "CREATE TEMPORARY TABLE vehicle (\n\tid INTEGER,\n\ttype VARCHAR(20));\nINSERT INTO vehicle VALUES (1, 'bike');\n";
    Vertx vertx;
    MySQLConnectOptions options;

    @Before
    public void setup() {
        this.vertx = Vertx.vertx();
        this.options = new MySQLConnectOptions(MySQLTestBase.options);
    }

    @After
    public void tearDown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testAffectedRowsEnabledClientCapability(TestContext ctx) {
        this.testAffectedRowsClientCapability(ctx, true, 0);
    }

    @Test
    public void testAffectedRowsDisabledClientCapability(TestContext ctx) {
        this.testAffectedRowsClientCapability(ctx, false, 1);
    }

    private void testAffectedRowsClientCapability(TestContext ctx, boolean useAffectedRows, int expectedRowCount) {
        MySQLConnectOptions connectOptions = this.options.setUseAffectedRows(useAffectedRows);
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)connectOptions, (Handler)ctx.asyncAssertSuccess(conn -> conn.query(PREPARE_TESTING_TABLE_DATA).execute(ctx.asyncAssertSuccess(res0 -> conn.query("UPDATE vehicle SET type = 'bike' WHERE id = 1;").execute(ctx.asyncAssertSuccess(res1 -> {
            ctx.assertEquals((Object)expectedRowCount, (Object)res1.rowCount());
            conn.close();
        }))))));
    }
}

