/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLConnection;
import io.vertx.mysqlclient.MySQLTestBase;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowIterator;
import io.vertx.sqlclient.Tuple;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MySQLCollationTest
extends MySQLTestBase {
    private static final String PREPARE_TESTING_TABLE_DATA = "CREATE TEMPORARY TABLE chinese_city (\n\tid INTEGER,\n\tcity_name VARCHAR(20)) COLLATE utf8_general_ci;\nINSERT INTO chinese_city VALUES (1, '\u5317\u4eac');\nINSERT INTO chinese_city VALUES (2, '\u4e0a\u6d77');\nINSERT INTO chinese_city VALUES (3, '\u5e7f\u5dde');\nINSERT INTO chinese_city VALUES (4, '\u6df1\u5733');\nINSERT INTO chinese_city VALUES (5, '\u6b66\u6c49');\nINSERT INTO chinese_city VALUES (6, '\u6210\u90fd');";
    private static final String PREPARE_TESTING_COLUMN_DATA = "CREATE TEMPORARY TABLE chinese_city (\n\tid INTEGER,\n\tcity_name VARCHAR(20) COLLATE gbk_chinese_ci);\nINSERT INTO chinese_city VALUES (1, '\u5317\u4eac');\nINSERT INTO chinese_city VALUES (2, '\u4e0a\u6d77');\nINSERT INTO chinese_city VALUES (3, '\u5e7f\u5dde');\nINSERT INTO chinese_city VALUES (4, '\u6df1\u5733');\nINSERT INTO chinese_city VALUES (5, '\u6b66\u6c49');\nINSERT INTO chinese_city VALUES (6, '\u6210\u90fd');";
    Vertx vertx;
    MySQLConnectOptions options;

    @Before
    public void setup() {
        this.vertx = Vertx.vertx();
        this.options = new MySQLConnectOptions(MySQLTestBase.options);
    }

    @After
    public void tearDown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testConnectionCollation(TestContext ctx) {
        MySQLConnectOptions connectOptions = this.options.setCollation("gbk_chinese_ci");
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)connectOptions, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SHOW VARIABLES LIKE 'collation_connection';").execute(ctx.asyncAssertSuccess(res -> {
            Row row = (Row)res.iterator().next();
            ctx.assertEquals((Object)"gbk_chinese_ci", (Object)row.getString("Value"));
            conn.close();
        }))));
    }

    @Test
    public void testConnectionCharset(TestContext ctx) {
        MySQLConnectOptions connectOptions = this.options.setCollation(null).setCharset("gbk");
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)connectOptions, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SHOW VARIABLES LIKE 'collation_connection';").execute(ctx.asyncAssertSuccess(res -> {
            ctx.assertEquals((Object)"gbk_chinese_ci", (Object)((Row)res.iterator().next()).getString("Value"));
            conn.query("SHOW VARIABLES LIKE 'character_set_connection';").execute(ctx.asyncAssertSuccess(res2 -> {
                ctx.assertEquals((Object)"gbk", (Object)((Row)res2.iterator().next()).getString("Value"));
                conn.close();
            }));
        }))));
    }

    @Test
    public void testTableCollationBinary(TestContext ctx) {
        this.testBinary(ctx, PREPARE_TESTING_TABLE_DATA);
    }

    @Test
    public void testTableCollationText(TestContext ctx) {
        this.testText(ctx, PREPARE_TESTING_TABLE_DATA);
    }

    @Test
    public void testTableCharsetBinary(TestContext ctx) {
        this.testBinary(ctx, PREPARE_TESTING_TABLE_DATA);
    }

    @Test
    public void testTableCharsetText(TestContext ctx) {
        this.testText(ctx, PREPARE_TESTING_TABLE_DATA);
    }

    @Test
    public void testColumnCollationBinary(TestContext ctx) {
        this.testBinary(ctx, PREPARE_TESTING_COLUMN_DATA);
    }

    @Test
    public void testColumnCollationText(TestContext ctx) {
        this.testText(ctx, PREPARE_TESTING_COLUMN_DATA);
    }

    @Test
    public void testColumnCharsetBinary(TestContext ctx) {
        this.testBinary(ctx, PREPARE_TESTING_COLUMN_DATA);
    }

    @Test
    public void testColumnCharsetText(TestContext ctx) {
        this.testText(ctx, PREPARE_TESTING_COLUMN_DATA);
    }

    @Test
    public void testEmoji(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("CREATE TEMPORARY TABLE emoji(\n\tid INTEGER,\n\texpression VARCHAR(10)\n);\nINSERT INTO emoji VALUES (1, '\ud83d\ude00');\nINSERT INTO emoji VALUES (2, '\ud83e\udd23');\nINSERT INTO emoji VALUES (3, '\ud83d\ude0a');\nINSERT INTO emoji VALUES (4, '\ud83d\ude07');\nINSERT INTO emoji VALUES (5, '\ud83d\ude33');\nINSERT INTO emoji VALUES (6, '\ud83d\ude31');\nINSERT INTO emoji VALUES (7, '\ud83d\udc4d');\nINSERT INTO emoji VALUES (8, '\ud83d\udd90');\nINSERT INTO emoji VALUES (9, '\u26bd');").execute(ctx.asyncAssertSuccess(res0 -> conn.query("SELECT id, expression FROM emoji").execute(ctx.asyncAssertSuccess(res1 -> {
            RowIterator iterator = res1.iterator();
            Row row1 = (Row)iterator.next();
            ctx.assertEquals((Object)1, (Object)row1.getInteger("id"));
            ctx.assertEquals((Object)"\ud83d\ude00", (Object)row1.getString("expression"));
            Row row2 = (Row)iterator.next();
            ctx.assertEquals((Object)2, (Object)row2.getInteger("id"));
            ctx.assertEquals((Object)"\ud83e\udd23", (Object)row2.getString("expression"));
            Row row3 = (Row)iterator.next();
            ctx.assertEquals((Object)3, (Object)row3.getInteger("id"));
            ctx.assertEquals((Object)"\ud83d\ude0a", (Object)row3.getString("expression"));
            Row row4 = (Row)iterator.next();
            ctx.assertEquals((Object)4, (Object)row4.getInteger("id"));
            ctx.assertEquals((Object)"\ud83d\ude07", (Object)row4.getString("expression"));
            Row row5 = (Row)iterator.next();
            ctx.assertEquals((Object)5, (Object)row5.getInteger("id"));
            ctx.assertEquals((Object)"\ud83d\ude33", (Object)row5.getString("expression"));
            Row row6 = (Row)iterator.next();
            ctx.assertEquals((Object)6, (Object)row6.getInteger("id"));
            ctx.assertEquals((Object)"\ud83d\ude31", (Object)row6.getString("expression"));
            Row row7 = (Row)iterator.next();
            ctx.assertEquals((Object)7, (Object)row7.getInteger("id"));
            ctx.assertEquals((Object)"\ud83d\udc4d", (Object)row7.getString("expression"));
            Row row8 = (Row)iterator.next();
            ctx.assertEquals((Object)8, (Object)row8.getInteger("id"));
            ctx.assertEquals((Object)"\ud83d\udd90", (Object)row8.getString("expression"));
            Row row9 = (Row)iterator.next();
            ctx.assertEquals((Object)9, (Object)row9.getInteger("id"));
            ctx.assertEquals((Object)"\u26bd", (Object)row9.getString("expression"));
            conn.close();
        }))))));
    }

    private void testBinary(TestContext ctx, String prepareDataSql) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query(prepareDataSql).execute(ctx.asyncAssertSuccess(res0 -> conn.preparedQuery("SELECT id, city_name FROM chinese_city where city_name = ?").execute(Tuple.tuple().addString("\u5317\u4eac"), ctx.asyncAssertSuccess(res1 -> {
            ctx.assertEquals((Object)1, (Object)res1.size());
            Row row = (Row)res1.iterator().next();
            ctx.assertEquals((Object)1, (Object)row.getInteger("id"));
            ctx.assertEquals((Object)"\u5317\u4eac", (Object)row.getString("city_name"));
            conn.close();
        }))))));
    }

    private void testText(TestContext ctx, String prepareDataSql) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query(prepareDataSql).execute(ctx.asyncAssertSuccess(res0 -> conn.query("SELECT id, city_name FROM chinese_city").execute(ctx.asyncAssertSuccess(res1 -> {
            ctx.assertEquals((Object)6, (Object)res1.size());
            RowIterator iterator = res1.iterator();
            Row row1 = (Row)iterator.next();
            ctx.assertEquals((Object)1, (Object)row1.getInteger("id"));
            ctx.assertEquals((Object)"\u5317\u4eac", (Object)row1.getString("city_name"));
            Row row2 = (Row)iterator.next();
            ctx.assertEquals((Object)2, (Object)row2.getInteger("id"));
            ctx.assertEquals((Object)"\u4e0a\u6d77", (Object)row2.getString("city_name"));
            Row row3 = (Row)iterator.next();
            ctx.assertEquals((Object)3, (Object)row3.getInteger("id"));
            ctx.assertEquals((Object)"\u5e7f\u5dde", (Object)row3.getString("city_name"));
            Row row4 = (Row)iterator.next();
            ctx.assertEquals((Object)4, (Object)row4.getInteger("id"));
            ctx.assertEquals((Object)"\u6df1\u5733", (Object)row4.getString("city_name"));
            Row row5 = (Row)iterator.next();
            ctx.assertEquals((Object)5, (Object)row5.getInteger("id"));
            ctx.assertEquals((Object)"\u6b66\u6c49", (Object)row5.getString("city_name"));
            Row row6 = (Row)iterator.next();
            ctx.assertEquals((Object)6, (Object)row6.getInteger("id"));
            ctx.assertEquals((Object)"\u6210\u90fd", (Object)row6.getString("city_name"));
            conn.close();
        }))))));
    }
}

