/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.mysqlclient.MySQLConnectOptions;
import org.junit.Assert;
import org.junit.Test;

public class MySQLConnectOptionsProviderTest {
    private String connectionUri;
    private MySQLConnectOptions expectedConfiguration;
    private MySQLConnectOptions actualConfiguration;

    @Test
    public void testValidUri1() {
        this.connectionUri = "mysql://localhost";
        this.actualConfiguration = MySQLConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new MySQLConnectOptions();
        MySQLConnectOptionsProviderTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test
    public void testValidUri2() {
        this.connectionUri = "mysql://myhost";
        this.actualConfiguration = MySQLConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new MySQLConnectOptions().setHost("myhost");
        MySQLConnectOptionsProviderTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test
    public void testValidUri3() {
        this.connectionUri = "mysql://myhost:3306";
        this.actualConfiguration = MySQLConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new MySQLConnectOptions().setHost("myhost").setPort(3306);
        MySQLConnectOptionsProviderTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test
    public void testValidUri4() {
        this.connectionUri = "mysql://myhost/mydb";
        this.actualConfiguration = MySQLConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new MySQLConnectOptions().setHost("myhost").setDatabase("mydb");
        MySQLConnectOptionsProviderTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test
    public void testValidUri5() {
        this.connectionUri = "mysql://user@myhost";
        this.actualConfiguration = MySQLConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new MySQLConnectOptions().setUser("user").setHost("myhost");
        MySQLConnectOptionsProviderTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test
    public void testValidUri6() {
        this.connectionUri = "mysql://user:secret@myhost";
        this.actualConfiguration = MySQLConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new MySQLConnectOptions().setUser("user").setPassword("secret").setHost("myhost");
        MySQLConnectOptionsProviderTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test
    public void testValidUri7() {
        this.connectionUri = "mysql://other@localhost/otherdb?port=3306&password=secret";
        this.actualConfiguration = MySQLConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new MySQLConnectOptions().setUser("other").setPassword("secret").setHost("localhost").setPort(3306).setDatabase("otherdb");
        MySQLConnectOptionsProviderTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test
    public void testValidUri8() {
        this.connectionUri = "mariadb://other@localhost/otherdb?port=3306&password=secret";
        this.actualConfiguration = MySQLConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new MySQLConnectOptions().setUser("other").setPassword("secret").setHost("localhost").setPort(3306).setDatabase("otherdb");
        MySQLConnectOptionsProviderTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test
    public void testValidUri9() {
        this.connectionUri = "mysql://myhost?useAffectedRows=true";
        this.actualConfiguration = MySQLConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new MySQLConnectOptions().setHost("myhost").setUseAffectedRows(true);
        MySQLConnectOptionsProviderTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test
    public void testValidUri10() {
        this.connectionUri = "mysql://myhost?useAffectedRows=all_except_true_is_false";
        this.actualConfiguration = MySQLConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new MySQLConnectOptions().setHost("myhost").setUseAffectedRows(false);
        MySQLConnectOptionsProviderTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidUri1() {
        this.connectionUri = "mysql://username:password@loc//dbname";
        this.actualConfiguration = MySQLConnectOptions.fromUri((String)this.connectionUri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidUri2() {
        this.connectionUri = "mysql://user@:passowrd@localhost/dbname/qwer";
        this.actualConfiguration = MySQLConnectOptions.fromUri((String)this.connectionUri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidUri3() {
        this.connectionUri = "mysql://user:password@localhost:655355/dbname";
        this.actualConfiguration = MySQLConnectOptions.fromUri((String)this.connectionUri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidUri4() {
        this.connectionUri = "mysql://user@localhost?port=1234&port";
        this.actualConfiguration = MySQLConnectOptions.fromUri((String)this.connectionUri);
    }

    private static void assertEquals(MySQLConnectOptions expectedConfiguration, MySQLConnectOptions actualConfiguration) {
        Assert.assertEquals((Object)expectedConfiguration.toJson(), (Object)actualConfiguration.toJson());
    }
}

