/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLConnection;
import io.vertx.mysqlclient.MySQLTestBase;
import io.vertx.sqlclient.Row;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MySQLConnectionTest
extends MySQLTestBase {
    Vertx vertx;
    MySQLConnectOptions options;

    @Before
    public void setup() {
        this.vertx = Vertx.vertx();
        this.options = new MySQLConnectOptions(MySQLTestBase.options);
    }

    @After
    public void tearDown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testAuthenticationWithEncryptPasswordByServerPublicKey(TestContext ctx) {
        this.options.setServerRsaPublicKeyValue(Buffer.buffer((String)"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA3yvG5s0qrV7jxVlp0sMj\nxP0a6BuLKCMjb0o88hDsJ3xz7PpHNKazuEAfPxiRFVAV3edqfSiXoQw+lJf4haEG\nHQe12Nfhs+UhcAeTKXRlZP/JNmI+BGoBduQ1rCId9bKYbXn4pvyS/a1ft7SwFkhx\naogCur7iIB0WUWvwkQ0fEj/Mlhw93lLVyx7hcGFq4FOAKFYr3A0xrHP1IdgnD8QZ\n0fUbgGLWWLOossKrbUP5HWko1ghLPIbfmU6o890oj1ZWQewj1Rs9Er92/UDj/JXx\n7ha1P+ZOgPBlV037KDQMS6cUh9vTablEHsMLhDZanymXzzjBkL+wH/b9cdL16LkQ\n5QIDAQAB\n-----END PUBLIC KEY-----\n"));
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.close()));
    }

    @Test
    public void testAuthenticationWithEncryptPasswordByServerPublicKeyInPath(TestContext ctx) {
        this.options.setServerRsaPublicKeyPath("tls/files/public_key.pem");
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.close()));
    }

    @Test
    public void testConnectWithEmptyPassword(TestContext ctx) {
        this.options.setUser("emptypassuser").setPassword("").setDatabase("emptyschema");
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.close()));
    }

    @Test
    public void testInflightCommandsFailWhenConnectionClosed(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn1 -> {
            conn1.query("DO SLEEP(20)").execute(ctx.asyncAssertFailure(t -> ctx.assertEquals((Object)"Fail to read any response from the server, the underlying connection might get lost unexpectedly.", (Object)t.getMessage())));
            MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn2 -> conn2.query("SHOW PROCESSLIST").execute(ctx.asyncAssertSuccess(processRes -> {
                for (Row row : processRes) {
                    Long id = row.getLong("Id");
                    String state = row.getString("State");
                    String info = row.getString("Info");
                    if (!"User sleep".equals(state) && !"DO SLEEP(10)".equals(info)) continue;
                    conn2.query("KILL CONNECTION " + id).execute(ctx.asyncAssertSuccess(v -> conn2.close()));
                    break;
                }
            }))));
        }));
    }
}

